/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.crypto.symmetric;

import java.io.Serializable;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.aoju.bus.core.codec.Base64;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.HexUtils;
import org.aoju.bus.core.utils.StringUtils;

public class RC4
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int SBOX_LENGTH = 256;
    private static final int KEY_MIN_LENGTH = 5;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private int[] sbox;

    public RC4(String key) throws InstrumentException {
        this.setKey(key);
    }

    public byte[] encrypt(String message, java.nio.charset.Charset charset) throws InstrumentException {
        return this.crypt(StringUtils.bytes((CharSequence)message, (java.nio.charset.Charset)charset));
    }

    public byte[] encrypt(String message) throws InstrumentException {
        return this.encrypt(message, Charset.UTF_8);
    }

    public String encryptHex(byte[] data) {
        return HexUtils.encodeHexStr((byte[])this.crypt(data));
    }

    public String encryptBase64(byte[] data) {
        return Base64.encode((byte[])this.crypt(data));
    }

    public String encryptHex(String data, java.nio.charset.Charset charset) {
        return HexUtils.encodeHexStr((byte[])this.encrypt(data, charset));
    }

    public String encryptBase64(String data, java.nio.charset.Charset charset) {
        return Base64.encode((byte[])this.encrypt(data, charset));
    }

    public String decrypt(byte[] message, java.nio.charset.Charset charset) throws InstrumentException {
        return StringUtils.str((byte[])this.crypt(message), (java.nio.charset.Charset)charset);
    }

    public String decrypt(byte[] message) throws InstrumentException {
        return this.decrypt(message, Charset.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] crypt(byte[] msg) {
        byte[] code;
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            int[] sbox = (int[])this.sbox.clone();
            code = new byte[msg.length];
            int i = 0;
            int j = 0;
            for (int n = 0; n < msg.length; ++n) {
                i = (i + 1) % 256;
                j = (j + sbox[i]) % 256;
                this.swap(i, j, sbox);
                int rand = sbox[(sbox[i] + sbox[j]) % 256];
                code[n] = (byte)(rand ^ msg[n]);
            }
        }
        finally {
            readLock.unlock();
        }
        return code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKey(String key) throws InstrumentException {
        int length = key.length();
        if (length < 5 || length >= 256) {
            throw new InstrumentException("Key length has to be between {} and {}", new Object[]{5, 255});
        }
        ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            this.sbox = this.initSBox(StringUtils.bytes((CharSequence)key));
        }
        finally {
            writeLock.unlock();
        }
    }

    private int[] initSBox(byte[] key) {
        int i;
        int[] sbox = new int[256];
        int j = 0;
        for (i = 0; i < 256; ++i) {
            sbox[i] = i;
        }
        for (i = 0; i < 256; ++i) {
            j = (j + sbox[i] + key[i % key.length] & 0xFF) % 256;
            this.swap(i, j, sbox);
        }
        return sbox;
    }

    private void swap(int i, int j, int[] sbox) {
        int temp = sbox[i];
        sbox[i] = sbox[j];
        sbox[j] = temp;
    }
}

