/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.crypto.asymmetric;

import java.security.PrivateKey;
import java.security.PublicKey;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.HexKit;
import org.aoju.bus.crypto.Builder;
import org.aoju.bus.crypto.asymmetric.KeyType;
import org.aoju.bus.crypto.asymmetric.Safety;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithID;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.DSAEncoding;
import org.bouncycastle.crypto.signers.PlainDSAEncoding;
import org.bouncycastle.crypto.signers.SM2Signer;
import org.bouncycastle.crypto.signers.StandardDSAEncoding;

public class SM2
extends Safety<SM2> {
    protected SM2Engine engine;
    protected SM2Signer signer;
    private SM2Engine.Mode mode = SM2Engine.Mode.C1C3C2;
    private ECPrivateKeyParameters privateKeyParams;
    private ECPublicKeyParameters publicKeyParams;
    private DSAEncoding encoding = StandardDSAEncoding.INSTANCE;
    private Digest digest = new SM3Digest();

    public SM2() {
        this(null, (byte[])null);
    }

    public SM2(String privateKeyStr, String publicKeyStr) {
        this(Builder.decode(privateKeyStr), Builder.decode(publicKeyStr));
    }

    public SM2(byte[] privateKey, byte[] publicKey) {
        this(Builder.generatePrivateKey("SM2", privateKey), Builder.generatePublicKey("SM2", publicKey));
    }

    public SM2(PrivateKey privateKey, PublicKey publicKey) {
        this(Builder.toParams(privateKey), Builder.toParams(publicKey));
        if (null != privateKey) {
            this.privateKey = privateKey;
        }
        if (null != publicKey) {
            this.publicKey = publicKey;
        }
    }

    public SM2(String privateKeyHex, String publicKeyPointXHex, String publicKeyPointYHex) {
        this(Builder.toSm2Params(privateKeyHex), Builder.toSm2Params(publicKeyPointXHex, publicKeyPointYHex));
    }

    public SM2(byte[] privateKey, byte[] publicKeyPointX, byte[] publicKeyPointY) {
        this(Builder.toSm2Params(privateKey), Builder.toSm2Params(publicKeyPointX, publicKeyPointY));
    }

    public SM2(ECPrivateKeyParameters privateKeyParams, ECPublicKeyParameters publicKeyParams) {
        super("SM2", null, null);
        this.privateKeyParams = privateKeyParams;
        this.publicKeyParams = publicKeyParams;
        this.init();
    }

    public SM2 init() {
        if (null == this.privateKeyParams && null == this.publicKeyParams) {
            super.initKeys();
            this.privateKeyParams = Builder.toParams(this.privateKey);
            this.publicKeyParams = Builder.toParams(this.publicKey);
        }
        return this;
    }

    @Override
    public SM2 initKeys() {
        return this;
    }

    @Override
    public byte[] encrypt(byte[] data, KeyType keyType) throws InstrumentException {
        if (KeyType.PublicKey != keyType) {
            throw new IllegalArgumentException("Encrypt is only support by public key");
        }
        this.lock.lock();
        SM2Engine engine = this.getEngine();
        try {
            engine.init(true, (CipherParameters)new ParametersWithRandom(this.getCipherParameters(keyType)));
            byte[] byArray = engine.processBlock(data, 0, data.length);
            return byArray;
        }
        catch (InvalidCipherTextException e) {
            throw new InstrumentException((Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public byte[] decrypt(byte[] data, KeyType keyType) {
        if (KeyType.PrivateKey != keyType) {
            throw new IllegalArgumentException("Decrypt is only support by private key");
        }
        this.lock.lock();
        SM2Engine engine = this.getEngine();
        try {
            engine.init(false, this.getCipherParameters(keyType));
            byte[] byArray = engine.processBlock(data, 0, data.length);
            return byArray;
        }
        catch (InvalidCipherTextException e) {
            throw new InstrumentException((Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public String sign(String dataHex) {
        return this.sign(dataHex, null);
    }

    public byte[] sign(byte[] data) {
        return this.sign(data, null);
    }

    public String sign(String dataHex, String idHex) {
        return HexKit.encodeHexStr((byte[])this.sign(HexKit.decodeHex((String)dataHex), HexKit.decodeHex((String)idHex)));
    }

    public byte[] sign(byte[] data, byte[] id) {
        this.lock.lock();
        SM2Signer signer = this.getSigner();
        try {
            ParametersWithRandom param = new ParametersWithRandom(this.getCipherParameters(KeyType.PrivateKey));
            if (id != null) {
                param = new ParametersWithID((CipherParameters)param, id);
            }
            signer.init(true, (CipherParameters)param);
            signer.update(data, 0, data.length);
            byte[] byArray = signer.generateSignature();
            return byArray;
        }
        catch (CryptoException e) {
            throw new InstrumentException((Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean verify(String dataHex, String signHex) {
        return this.verify(dataHex, signHex, null);
    }

    public boolean verify(byte[] data, byte[] sign) {
        return this.verify(data, sign, null);
    }

    public boolean verify(String dataHex, String signHex, String idHex) {
        return this.verify(HexKit.decodeHex((String)dataHex), HexKit.decodeHex((String)signHex), HexKit.decodeHex((String)idHex));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verify(byte[] data, byte[] sign, byte[] id) {
        this.lock.lock();
        SM2Signer signer = this.getSigner();
        try {
            CipherParameters param = this.getCipherParameters(KeyType.PublicKey);
            if (id != null) {
                param = new ParametersWithID(param, id);
            }
            signer.init(false, param);
            signer.update(data, 0, data.length);
            boolean bl = signer.verifySignature(sign);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public SM2 setPrivateKey(PrivateKey privateKey) {
        super.setPrivateKey(privateKey);
        this.privateKeyParams = Builder.toParams(privateKey);
        return this;
    }

    public SM2 setPrivateKeyParams(ECPrivateKeyParameters privateKeyParams) {
        this.privateKeyParams = privateKeyParams;
        return this;
    }

    @Override
    public SM2 setPublicKey(PublicKey publicKey) {
        super.setPublicKey(publicKey);
        this.publicKeyParams = Builder.toParams(publicKey);
        return this;
    }

    public SM2 setPublicKeyParams(ECPublicKeyParameters publicKeyParams) {
        this.publicKeyParams = publicKeyParams;
        return this;
    }

    public SM2 setMode(SM2Engine.Mode mode) {
        this.mode = mode;
        this.engine = null;
        return this;
    }

    private CipherParameters getCipherParameters(KeyType keyType) {
        switch (keyType) {
            case PublicKey: {
                Assert.notNull((Object)this.publicKeyParams, (String)"PublicKey must be not null !", (Object[])new Object[0]);
                return this.publicKeyParams;
            }
            case PrivateKey: {
                Assert.notNull((Object)this.privateKeyParams, (String)"PrivateKey must be not null !", (Object[])new Object[0]);
                return this.privateKeyParams;
            }
        }
        return null;
    }

    private SM2Engine getEngine() {
        if (null == this.engine) {
            this.engine = new SM2Engine(this.digest, this.mode);
        }
        return this.engine;
    }

    private SM2Signer getSigner() {
        if (null == this.signer) {
            this.signer = new SM2Signer(this.encoding, this.digest);
        }
        return this.signer;
    }

    public SM2 setEncoding() {
        return this.setEncoding((DSAEncoding)PlainDSAEncoding.INSTANCE);
    }

    public SM2 setEncoding(DSAEncoding encoding) {
        this.encoding = encoding;
        this.signer = null;
        return this;
    }

    public SM2 setDigest(Digest digest) {
        this.digest = digest;
        this.engine = null;
        this.signer = null;
        return this;
    }
}

