/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.crypto.provider;

import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.crypto.Builder;
import org.aoju.bus.crypto.Provider;
import org.aoju.bus.crypto.asymmetric.KeyType;
import org.aoju.bus.crypto.asymmetric.SM2;
import org.bouncycastle.crypto.engines.SM2Engine;

public class SM2Provider
implements Provider {
    @Override
    public byte[] encrypt(String key, byte[] content) {
        if (StringKit.isEmpty((CharSequence)key)) {
            throw new InstrumentException("key is null!");
        }
        String[] array = StringKit.split((CharSequence)key, (CharSequence)",");
        SM2 sm2 = Builder.sm2(array[0], array[1]);
        sm2.setMode(SM2Engine.Mode.C1C3C2);
        return sm2.encrypt(content, KeyType.valueOf(array[2]));
    }

    @Override
    public byte[] decrypt(String key, byte[] content) {
        if (StringKit.isEmpty((CharSequence)key)) {
            throw new InstrumentException("key is null!");
        }
        String[] array = StringKit.split((CharSequence)key, (CharSequence)",");
        SM2 sm2 = Builder.sm2(array[0], array[1]);
        sm2.setMode(SM2Engine.Mode.C1C3C2);
        return sm2.decrypt(content, KeyType.valueOf(array[2]));
    }
}

