/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.crypto.asymmetric;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Set;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.HexKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.crypto.Builder;
import org.aoju.bus.crypto.asymmetric.Keys;

public class Sign
extends Keys<Sign> {
    protected Signature signature;

    public Sign(String algorithm) {
        this(algorithm, (byte[])null, null);
    }

    public Sign(String algorithm, KeyPair keyPair) {
        super(algorithm, keyPair.getPrivate(), keyPair.getPublic());
    }

    public Sign(String algorithm, byte[] privateKey, byte[] publicKey) {
        super(algorithm, Builder.generatePrivateKey(algorithm, privateKey), Builder.generatePublicKey(algorithm, publicKey));
    }

    public Sign(String algorithm, String privateKey, String publicKey) {
        this(algorithm, Builder.decode(privateKey), Builder.decode(publicKey));
    }

    @Override
    public Sign init(String algorithm, PrivateKey privateKey, PublicKey publicKey) {
        try {
            this.signature = Signature.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InstrumentException((Throwable)e);
        }
        super.init(algorithm, privateKey, publicKey);
        return this;
    }

    public Sign setParameter(AlgorithmParameterSpec params) {
        try {
            this.signature.setParameter(params);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InstrumentException((Throwable)e);
        }
        return this;
    }

    public byte[] sign(String data, java.nio.charset.Charset charset) {
        return this.sign(StringKit.bytes((CharSequence)data, (java.nio.charset.Charset)charset));
    }

    public byte[] sign(String data) {
        return this.sign(data, Charset.UTF_8);
    }

    public String signHex(String data, java.nio.charset.Charset charset) {
        return HexKit.encodeHexStr((byte[])this.sign(data, charset));
    }

    public String signHex(String data) {
        return this.signHex(data, Charset.UTF_8);
    }

    public byte[] sign(byte[] data) {
        return this.sign(new ByteArrayInputStream(data), -1);
    }

    public String signHex(byte[] data) {
        return HexKit.encodeHexStr((byte[])this.sign(data));
    }

    public String signHex(InputStream data) {
        return HexKit.encodeHexStr((byte[])this.sign(data));
    }

    public byte[] sign(InputStream data) {
        return this.sign(data, 8192);
    }

    public String digestHex(InputStream data, int bufferLength) {
        return HexKit.encodeHexStr((byte[])this.sign(data, bufferLength));
    }

    public byte[] sign(InputStream data, int bufferLength) {
        if (bufferLength < 1) {
            bufferLength = 8192;
        }
        byte[] buffer = new byte[bufferLength];
        this.lock.lock();
        try {
            byte[] result;
            this.signature.initSign(this.privateKey);
            try {
                int read = data.read(buffer, 0, bufferLength);
                while (read > -1) {
                    this.signature.update(buffer, 0, read);
                    read = data.read(buffer, 0, bufferLength);
                }
                result = this.signature.sign();
            }
            catch (Exception e) {
                throw new InstrumentException((Throwable)e);
            }
            byte[] byArray = result;
            return byArray;
        }
        catch (Exception e) {
            throw new InstrumentException((Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean verify(byte[] data, byte[] sign) {
        this.lock.lock();
        try {
            this.signature.initVerify(this.publicKey);
            this.signature.update(data);
            boolean bl = this.signature.verify(sign);
            return bl;
        }
        catch (Exception e) {
            throw new InstrumentException((Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public Signature getSignature() {
        return this.signature;
    }

    public Sign setSignature(Signature signature) {
        this.signature = signature;
        return this;
    }

    public Sign setCertificate(Certificate certificate) {
        boolean[] keyUsageInfo;
        X509Certificate cert;
        Set<String> critSet;
        if (certificate instanceof X509Certificate && CollKit.isNotEmpty(critSet = (cert = (X509Certificate)certificate).getCriticalExtensionOIDs()) && critSet.contains("2.5.29.15") && null != (keyUsageInfo = cert.getKeyUsage()) && !keyUsageInfo[0]) {
            throw new InstrumentException("Wrong key usage");
        }
        this.publicKey = certificate.getPublicKey();
        return this;
    }
}

