/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.crypto;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.aoju.bus.core.codec.Base64;
import org.aoju.bus.core.instance.Instances;
import org.aoju.bus.core.io.streams.ByteArrayOutputStream;
import org.aoju.bus.core.lang.Algorithm;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.Validator;
import org.aoju.bus.core.lang.exception.CryptoException;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.HexKit;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.MapKit;
import org.aoju.bus.core.toolkit.RandomKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.crypto.Holder;
import org.aoju.bus.crypto.Provider;
import org.aoju.bus.crypto.Registry;
import org.aoju.bus.crypto.asymmetric.RSA;
import org.aoju.bus.crypto.asymmetric.SM2;
import org.aoju.bus.crypto.asymmetric.Sign;
import org.aoju.bus.crypto.digest.BCrypt;
import org.aoju.bus.crypto.digest.Digester;
import org.aoju.bus.crypto.digest.HMac;
import org.aoju.bus.crypto.digest.MD5;
import org.aoju.bus.crypto.digest.SM3;
import org.aoju.bus.crypto.digest.mac.BCHMacEngine;
import org.aoju.bus.crypto.digest.mac.MacEngine;
import org.aoju.bus.crypto.symmetric.Crypto;
import org.aoju.bus.crypto.symmetric.SM4;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.BERSequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.sec.ECPrivateKey;
import org.bouncycastle.asn1.util.ASN1Dump;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.signers.StandardDSAEncoding;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.bouncycastle.jcajce.spec.OpenSSHPrivateKeySpec;
import org.bouncycastle.jcajce.spec.OpenSSHPublicKeySpec;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.FixedPointCombMultiplier;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemReader;
import org.bouncycastle.util.io.pem.PemWriter;

public class Builder {
    public static final String KEY_TYPE_JKS = "JKS";
    public static final String KEY_TYPE_PKCS12 = "pkcs12";
    public static final String CERT_TYPE_X509 = "X.509";
    public static final int DEFAULT_KEY_SIZE = 1024;
    public static final String SM2_DEFAULT_CURVE = "sm2p256v1";
    public static final ECDomainParameters SM2_DOMAIN_PARAMS = Builder.toDomainParams(GMNamedCurves.getByName((String)"sm2p256v1"));
    public static final ASN1ObjectIdentifier ID_SM2_PUBLIC_KEY_PARAM = new ASN1ObjectIdentifier("1.2.156.10197.1.301");

    public static MD5 md5() {
        return new MD5();
    }

    public static byte[] md5(byte[] data) {
        return new MD5().digest(data);
    }

    public static byte[] md5(String data, String charset) {
        return new MD5().digest(data, charset);
    }

    public static byte[] md5(String data) {
        return Builder.md5(data, "UTF-8");
    }

    public static byte[] md5(InputStream data) {
        return new MD5().digest(data);
    }

    public static byte[] md5(File file) {
        return new MD5().digest(file);
    }

    public static String md5Hex(byte[] data) {
        return new MD5().digestHex(data);
    }

    public static String md5Hex(String data, String charset) {
        return new MD5().digestHex(data, charset);
    }

    public static String md5Hex(String data, Charset charset) {
        return new MD5().digestHex(data, charset);
    }

    public static String md5Hex(String data) {
        return Builder.md5Hex(data, "UTF-8");
    }

    public static String md5Hex(InputStream data) {
        return new MD5().digestHex(data);
    }

    public static String md5Hex(File file) {
        return new MD5().digestHex(file);
    }

    public static String md5Hex16(byte[] data) {
        return new MD5().digestHex16(data);
    }

    public static String md5Hex16(String data, Charset charset) {
        return new MD5().digestHex16(data, charset);
    }

    public static String md5Hex16(String data) {
        return Builder.md5Hex16(data, org.aoju.bus.core.lang.Charset.UTF_8);
    }

    public static String md5Hex16(InputStream data) {
        return new MD5().digestHex16(data);
    }

    public static String md5Hex16(File file) {
        return new MD5().digestHex16(file);
    }

    public static String md5HexTo16(String md5Hex) {
        return md5Hex.substring(8, 24);
    }

    public static Digester sha1() {
        return new Digester(Algorithm.SHA1);
    }

    public static byte[] sha1(byte[] data) {
        return new Digester(Algorithm.SHA1).digest(data);
    }

    public static byte[] sha1(String data, String charset) {
        return new Digester(Algorithm.SHA1).digest(data, charset);
    }

    public static byte[] sha1(String data) {
        return Builder.sha1(data, "UTF-8");
    }

    public static byte[] sha1(InputStream data) {
        return new Digester(Algorithm.SHA1).digest(data);
    }

    public static byte[] sha1(File file) {
        return new Digester(Algorithm.SHA1).digest(file);
    }

    public static String sha1Hex(byte[] data) {
        return new Digester(Algorithm.SHA1).digestHex(data);
    }

    public static String sha1Hex(String data, String charset) {
        return new Digester(Algorithm.SHA1).digestHex(data, charset);
    }

    public static String sha1Hex(String data) {
        return Builder.sha1Hex(data, "UTF-8");
    }

    public static String sha1Hex(InputStream data) {
        return new Digester(Algorithm.SHA1).digestHex(data);
    }

    public static String sha1Hex(File file) {
        return new Digester(Algorithm.SHA1).digestHex(file);
    }

    public static Digester sha256() {
        return new Digester(Algorithm.SHA256);
    }

    public static byte[] sha256(byte[] data) {
        return new Digester(Algorithm.SHA256).digest(data);
    }

    public static byte[] sha256(String data, String charset) {
        return new Digester(Algorithm.SHA256).digest(data, charset);
    }

    public static byte[] sha256(String data) {
        return Builder.sha256(data, "UTF-8");
    }

    public static byte[] sha256(InputStream data) {
        return new Digester(Algorithm.SHA256).digest(data);
    }

    public static byte[] sha256(File file) {
        return new Digester(Algorithm.SHA256).digest(file);
    }

    public static String sha256Hex(byte[] data) {
        return new Digester(Algorithm.SHA256).digestHex(data);
    }

    public static String sha256Hex(String data, String charset) {
        return new Digester(Algorithm.SHA256).digestHex(data, charset);
    }

    public static String sha256Hex(String data) {
        return Builder.sha256Hex(data, "UTF-8");
    }

    public static String sha256Hex(InputStream data) {
        return new Digester(Algorithm.SHA256).digestHex(data);
    }

    public static String sha256Hex(File file) {
        return new Digester(Algorithm.SHA256).digestHex(file);
    }

    public static HMac hmac(Algorithm algorithm, String key) {
        return new HMac(algorithm, StringKit.bytes((CharSequence)key));
    }

    public static HMac hmac(Algorithm algorithm, byte[] key) {
        return new HMac(algorithm, key);
    }

    public static HMac hmac(Algorithm algorithm, SecretKey key) {
        return new HMac(algorithm, (Key)key);
    }

    public static HMac hmacMd5(String key) {
        return Builder.hmacMd5(StringKit.bytes((CharSequence)key));
    }

    public static HMac hmacMd5(byte[] key) {
        return new HMac(Algorithm.HMACMD5, key);
    }

    public static HMac hmacMd5() {
        return new HMac(Algorithm.HMACMD5);
    }

    public static HMac hmacSha1(String key) {
        return Builder.hmacSha1(StringKit.bytes((CharSequence)key));
    }

    public static HMac hmacSha1(byte[] key) {
        return new HMac(Algorithm.HMACSHA1, key);
    }

    public static HMac hmacSha1() {
        return new HMac(Algorithm.HMACSHA1);
    }

    public static HMac hmacSha256(String key) {
        return Builder.hmacSha256(StringKit.bytes((CharSequence)key));
    }

    public static HMac hmacSha256(byte[] key) {
        return new HMac(Algorithm.HMACSHA256, key);
    }

    public static HMac hmacSha256() {
        return new HMac(Algorithm.HMACSHA256);
    }

    public static RSA rsa() {
        return new RSA();
    }

    public static RSA rsa(String privateKey, String publicKey) {
        return new RSA(privateKey, publicKey);
    }

    public static RSA rsa(byte[] privateKey, byte[] publicKey) {
        return new RSA(privateKey, publicKey);
    }

    public static Sign sign(Algorithm algorithm) {
        return new Sign(algorithm);
    }

    public static Sign sign(Algorithm algorithm, String privateKey, String publicKey) {
        return new Sign(algorithm, privateKey, publicKey);
    }

    public static Sign sign(Algorithm algorithm, byte[] privateKey, byte[] publicKey) {
        return new Sign(algorithm, privateKey, publicKey);
    }

    public static Digester digester(Algorithm algorithm) {
        return new Digester(algorithm);
    }

    public static Digester digester(String algorithm) {
        return new Digester(algorithm);
    }

    public static SM2 sm2() {
        return new SM2();
    }

    public static SM2 sm2(String privateKey, String publicKey) {
        return new SM2(privateKey, publicKey);
    }

    public static SM2 sm2(byte[] privateKey, byte[] publicKey) {
        return new SM2(privateKey, publicKey);
    }

    public static SM2 sm2(PrivateKey privateKey, PublicKey publicKey) {
        return new SM2(privateKey, publicKey);
    }

    public static SM2 sm2(ECPrivateKeyParameters privateKeyParams, ECPublicKeyParameters publicKeyParams) {
        return new SM2(privateKeyParams, publicKeyParams);
    }

    public static SM3 sm3() {
        return new SM3();
    }

    public static String sm3(String data) {
        return Builder.sm3().digestHex(data);
    }

    public static SM3 sm3(byte[] salt) {
        return new SM3(salt);
    }

    public static String sm3(InputStream data) {
        return Builder.sm3().digestHex(data);
    }

    public static String sm3(File dataFile) {
        return Builder.sm3().digestHex(dataFile);
    }

    public static SM4 sm4() {
        return new SM4();
    }

    public static SM4 sm4(byte[] key) {
        return new SM4(key);
    }

    public static byte[] encrypt(String algorithm, String key, byte[] content) {
        Provider provider = Registry.require(algorithm);
        return provider.encrypt(key, content);
    }

    public static String encrypt(String algorithm, String key, String content, Charset charset) {
        return HexKit.encodeHexStr((byte[])Builder.encrypt(algorithm, key, content.getBytes(charset)));
    }

    public static InputStream encrypt(String algorithm, String key, InputStream inputStream) {
        Provider provider = Registry.require(algorithm);
        return new ByteArrayInputStream(provider.encrypt(key, IoKit.readBytes((InputStream)inputStream)));
    }

    public static byte[] decrypt(String algorithm, String key, byte[] content) {
        return Registry.require(algorithm).decrypt(key, content);
    }

    public static String decrypt(String algorithm, String key, String content, Charset charset) {
        return new String(Builder.decrypt(algorithm, key, HexKit.decodeHex((CharSequence)content)), charset);
    }

    public static InputStream decrypt(String algorithm, String key, InputStream inputStream) {
        return new ByteArrayInputStream(Registry.require(algorithm).decrypt(key, IoKit.readBytes((InputStream)inputStream)));
    }

    public static byte[] encode(ASN1Encodable ... elements) {
        return Builder.encode("DER", elements);
    }

    public static byte[] encode(String asn1Encoding, ASN1Encodable ... elements) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Builder.encode(asn1Encoding, (OutputStream)out, elements);
        return out.toByteArray();
    }

    public static void encode(String asn1Encoding, OutputStream out, ASN1Encodable ... elements) {
        DERSequence sequence;
        switch (asn1Encoding) {
            case "DER": {
                sequence = new DERSequence(elements);
                break;
            }
            case "BER": {
                sequence = new BERSequence(elements);
                break;
            }
            case "DL": {
                sequence = new DLSequence(elements);
                break;
            }
            default: {
                throw new CryptoException("Unsupported ASN1 encoding: {}", new Object[]{asn1Encoding});
            }
        }
        try {
            sequence.encodeTo(out);
        }
        catch (IOException e) {
            throw new CryptoException((Throwable)e);
        }
    }

    public static ASN1Object decode(InputStream in) {
        ASN1InputStream asn1In = new ASN1InputStream(in);
        try {
            return asn1In.readObject();
        }
        catch (IOException e) {
            throw new CryptoException((Throwable)e);
        }
    }

    public static String getDumpStr(InputStream in) {
        return ASN1Dump.dumpAsString((Object)Builder.decode(in));
    }

    public static byte[] encodeECPrivateKey(PrivateKey privateKey) {
        return ((BCECPrivateKey)privateKey).getD().toByteArray();
    }

    public static byte[] encodeECPublicKey(PublicKey publicKey) {
        return Builder.encodeECPublicKey(publicKey, true);
    }

    public static byte[] encodeECPublicKey(PublicKey publicKey, boolean isCompressed) {
        return ((BCECPublicKey)publicKey).getQ().getEncoded(isCompressed);
    }

    public static byte[] decode(String key) {
        return Validator.isHex((CharSequence)key) ? HexKit.decodeHex((CharSequence)key) : Base64.decode((CharSequence)key);
    }

    public static PublicKey decodeECPoint(String encode, String curveName) {
        return Builder.decodeECPoint(Builder.decode(encode), curveName);
    }

    public static PublicKey decodeECPoint(byte[] encodeByte, String curveName) {
        X9ECParameters x9ECParameters = ECUtil.getNamedCurveByName((String)curveName);
        ECCurve curve = x9ECParameters.getCurve();
        ECPoint point = EC5Util.convertPoint((org.bouncycastle.math.ec.ECPoint)curve.decodePoint(encodeByte));
        ECNamedCurveSpec ecSpec = new ECNamedCurveSpec(curveName, curve, x9ECParameters.getG(), x9ECParameters.getN());
        return Builder.generatePublicKey("EC", new ECPublicKeySpec(point, (ECParameterSpec)ecSpec));
    }

    public static ECDomainParameters toDomainParams(org.bouncycastle.jce.spec.ECParameterSpec parameterSpec) {
        return new ECDomainParameters(parameterSpec.getCurve(), parameterSpec.getG(), parameterSpec.getN(), parameterSpec.getH());
    }

    public static ECDomainParameters toDomainParams(String curveName) {
        return Builder.toDomainParams(ECUtil.getNamedCurveByName((String)curveName));
    }

    public static ECDomainParameters toDomainParams(X9ECParameters x9ECParameters) {
        return new ECDomainParameters(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH());
    }

    public static ECPrivateKeyParameters toSm2Params(String d) {
        return Builder.toSm2PrivateParams(d);
    }

    public static ECPrivateKeyParameters toParams(String dHex, ECDomainParameters domainParameters) {
        return Builder.toPrivateParams(dHex, domainParameters);
    }

    public static ECPrivateKeyParameters toSm2Params(byte[] d) {
        return Builder.toSm2PrivateParams(d);
    }

    public static ECPrivateKeyParameters toParams(byte[] d, ECDomainParameters domainParameters) {
        return Builder.toPrivateParams(d, domainParameters);
    }

    public static ECPrivateKeyParameters toSm2Params(BigInteger d) {
        return Builder.toSm2PrivateParams(d);
    }

    public static ECPrivateKeyParameters toParams(BigInteger d, ECDomainParameters domainParameters) {
        return Builder.toPrivateParams(d, domainParameters);
    }

    public static ECPublicKeyParameters toParams(BigInteger x, BigInteger y, ECDomainParameters domainParameters) {
        return Builder.toPublicParams(x, y, domainParameters);
    }

    public static ECPublicKeyParameters toSm2Params(String xHex, String yHex) {
        return Builder.toSm2PublicParams(xHex, yHex);
    }

    public static ECPublicKeyParameters toParams(String xHex, String yHex, ECDomainParameters domainParameters) {
        return Builder.toPublicParams(xHex, yHex, domainParameters);
    }

    public static ECPublicKeyParameters toSm2Params(byte[] xBytes, byte[] yBytes) {
        return Builder.toSm2PublicParams(xBytes, yBytes);
    }

    public static ECPublicKeyParameters toParams(byte[] xBytes, byte[] yBytes, ECDomainParameters domainParameters) {
        return Builder.toPublicParams(xBytes, yBytes, domainParameters);
    }

    public static ECPublicKeyParameters toParams(PublicKey publicKey) {
        return Builder.toPublicParams(publicKey);
    }

    public static ECPrivateKeyParameters toParams(PrivateKey privateKey) {
        return Builder.toPrivateParams(privateKey);
    }

    public static byte[] toPkcs1(PrivateKey privateKey) {
        PrivateKeyInfo pkInfo = PrivateKeyInfo.getInstance((Object)privateKey.getEncoded());
        try {
            return pkInfo.parsePrivateKey().toASN1Primitive().getEncoded();
        }
        catch (IOException e) {
            throw new CryptoException((Throwable)e);
        }
    }

    public static byte[] toPkcs1(PublicKey publicKey) {
        SubjectPublicKeyInfo spkInfo = SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded());
        try {
            return spkInfo.parsePublicKey().getEncoded();
        }
        catch (IOException e) {
            throw new CryptoException((Throwable)e);
        }
    }

    public static String signParams(Crypto crypto, Map<?, ?> params, String ... other) {
        return Builder.signParams(crypto, params, "", "", true, other);
    }

    public static String signParams(Crypto crypto, Map<?, ?> params, String separator, String keyValueSeparator, boolean isIgnoreNull, String ... other) {
        return crypto.encryptHex(MapKit.sortJoin(params, (String)separator, (String)keyValueSeparator, (boolean)isIgnoreNull, (String[])other));
    }

    public static String signParamsMd5(Map<?, ?> params, String ... other) {
        return Builder.signParams(Algorithm.MD5, params, other);
    }

    public static String signParamsSha1(Map<?, ?> params, String ... other) {
        return Builder.signParams(Algorithm.SHA1, params, other);
    }

    public static String signParamsSha256(Map<?, ?> params, String ... other) {
        return Builder.signParams(Algorithm.SHA256, params, other);
    }

    public static String signParams(Algorithm algorithm, Map<?, ?> params, String ... other) {
        return Builder.signParams(algorithm, params, "", "", true, other);
    }

    public static String signParams(Algorithm algorithm, Map<?, ?> params, String separator, String keyValueSeparator, boolean isIgnoreNull, String ... other) {
        return new Digester(algorithm).digestHex(MapKit.sortJoin(params, (String)separator, (String)keyValueSeparator, (boolean)isIgnoreNull, (String[])other));
    }

    public static AsymmetricKeyParameter toParams(Key key) {
        if (key instanceof PrivateKey) {
            return Builder.toPrivateParams((PrivateKey)key);
        }
        if (key instanceof PublicKey) {
            return Builder.toPublicParams((PublicKey)key);
        }
        return null;
    }

    public static ECPublicKeyParameters getPublicParams(ECPrivateKeyParameters privateKeyParameters) {
        ECDomainParameters domainParameters = privateKeyParameters.getParameters();
        org.bouncycastle.math.ec.ECPoint q = new FixedPointCombMultiplier().multiply(domainParameters.getG(), privateKeyParameters.getD());
        return new ECPublicKeyParameters(q, domainParameters);
    }

    public static ECPublicKeyParameters toSm2PublicParams(byte[] q) {
        return Builder.toPublicParams(q, SM2_DOMAIN_PARAMS);
    }

    public static ECPublicKeyParameters toSm2PublicParams(String q) {
        return Builder.toPublicParams(q, SM2_DOMAIN_PARAMS);
    }

    public static ECPublicKeyParameters toSm2PublicParams(String x, String y) {
        return Builder.toPublicParams(x, y, SM2_DOMAIN_PARAMS);
    }

    public static ECPublicKeyParameters toSm2PublicParams(byte[] xBytes, byte[] yBytes) {
        return Builder.toPublicParams(xBytes, yBytes, SM2_DOMAIN_PARAMS);
    }

    public static ECPublicKeyParameters toPublicParams(String x, String y, ECDomainParameters domainParameters) {
        return Builder.toPublicParams(Builder.decode(x), Builder.decode(y), domainParameters);
    }

    public static ECPublicKeyParameters toPublicParams(byte[] xBytes, byte[] yBytes, ECDomainParameters domainParameters) {
        if (null == xBytes || null == yBytes) {
            return null;
        }
        return Builder.toPublicParams(BigIntegers.fromUnsignedByteArray((byte[])xBytes), BigIntegers.fromUnsignedByteArray((byte[])yBytes), domainParameters);
    }

    public static ECPublicKeyParameters toPublicParams(BigInteger x, BigInteger y, ECDomainParameters domainParameters) {
        if (null == x || null == y) {
            return null;
        }
        ECCurve curve = domainParameters.getCurve();
        return Builder.toPublicParams(curve.createPoint(x, y), domainParameters);
    }

    public static ECPublicKeyParameters toPublicParams(String pointEncoded, ECDomainParameters domainParameters) {
        ECCurve curve = domainParameters.getCurve();
        return Builder.toPublicParams(curve.decodePoint(Builder.decode(pointEncoded)), domainParameters);
    }

    public static ECPublicKeyParameters toPublicParams(byte[] pointEncoded, ECDomainParameters domainParameters) {
        ECCurve curve = domainParameters.getCurve();
        return Builder.toPublicParams(curve.decodePoint(pointEncoded), domainParameters);
    }

    public static ECPublicKeyParameters toPublicParams(org.bouncycastle.math.ec.ECPoint point, ECDomainParameters domainParameters) {
        return new ECPublicKeyParameters(point, domainParameters);
    }

    public static ECPublicKeyParameters toPublicParams(PublicKey publicKey) {
        if (null == publicKey) {
            return null;
        }
        try {
            return (ECPublicKeyParameters)ECUtil.generatePublicKeyParameter((PublicKey)publicKey);
        }
        catch (InvalidKeyException e) {
            throw new CryptoException((Throwable)e);
        }
    }

    public static ECPrivateKeyParameters toSm2PrivateParams(String d) {
        return Builder.toPrivateParams(d, SM2_DOMAIN_PARAMS);
    }

    public static ECPrivateKeyParameters toSm2PrivateParams(byte[] d) {
        return Builder.toPrivateParams(d, SM2_DOMAIN_PARAMS);
    }

    public static ECPrivateKeyParameters toSm2PrivateParams(BigInteger d) {
        return Builder.toPrivateParams(d, SM2_DOMAIN_PARAMS);
    }

    public static ECPrivateKeyParameters toPrivateParams(String d, ECDomainParameters domainParameters) {
        return Builder.toPrivateParams(BigIntegers.fromUnsignedByteArray((byte[])Builder.decode(d)), domainParameters);
    }

    public static ECPrivateKeyParameters toPrivateParams(byte[] d, ECDomainParameters domainParameters) {
        return Builder.toPrivateParams(BigIntegers.fromUnsignedByteArray((byte[])d), domainParameters);
    }

    public static ECPrivateKeyParameters toPrivateParams(BigInteger d, ECDomainParameters domainParameters) {
        if (null == d) {
            return null;
        }
        return new ECPrivateKeyParameters(d, domainParameters);
    }

    public static ECPrivateKeyParameters toPrivateParams(PrivateKey privateKey) {
        if (null == privateKey) {
            return null;
        }
        try {
            return (ECPrivateKeyParameters)ECUtil.generatePrivateKeyParameter((PrivateKey)privateKey);
        }
        catch (InvalidKeyException e) {
            throw new CryptoException((Throwable)e);
        }
    }

    public static PrivateKey toSm2PrivateKey(ECPrivateKey privateKey) {
        try {
            PrivateKeyInfo info = new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)ID_SM2_PUBLIC_KEY_PARAM), (ASN1Encodable)privateKey);
            return Builder.generatePrivateKey("SM2", info.getEncoded());
        }
        catch (IOException e) {
            throw new CryptoException((Throwable)e);
        }
    }

    public static SecretKey generateKey(String algorithm) {
        return Builder.generateKey(algorithm, -1);
    }

    public static KeySpec createOpenSSHPrivateKeySpec(byte[] key) {
        return new OpenSSHPrivateKeySpec(key);
    }

    public static KeySpec createOpenSSHPublicKeySpec(byte[] key) {
        return new OpenSSHPublicKeySpec(key);
    }

    public static ECPrivateKeyParameters decodePrivateKeyParams(byte[] privateKeyBytes) {
        try {
            return Builder.toSm2PrivateParams(privateKeyBytes);
        }
        catch (Exception exception) {
            PrivateKey privateKey;
            try {
                privateKey = Builder.generatePrivateKey("sm2", privateKeyBytes);
            }
            catch (Exception ignore) {
                privateKey = Builder.generatePrivateKey("sm2", Builder.createOpenSSHPrivateKeySpec(privateKeyBytes));
            }
            return Builder.toPrivateParams(privateKey);
        }
    }

    public static ECPublicKeyParameters decodePublicKeyParams(byte[] publicKeyBytes) {
        try {
            return Builder.toSm2PublicParams(publicKeyBytes);
        }
        catch (Exception exception) {
            PublicKey publicKey;
            try {
                publicKey = Builder.generatePublicKey(Algorithm.SM2.getValue(), publicKeyBytes);
            }
            catch (Exception ignore) {
                publicKey = Builder.generatePublicKey(Algorithm.SM2.getValue(), Builder.createOpenSSHPublicKeySpec(publicKeyBytes));
            }
            return Builder.toPublicParams(publicKey);
        }
    }

    public static SecretKey generateKey(String algorithm, int keySize) {
        return Builder.generateKey(algorithm, keySize, null);
    }

    public static SecretKey generateKey(String algorithm, int keySize, SecureRandom random) {
        algorithm = Builder.getMainAlgorithm(algorithm);
        KeyGenerator keyGenerator = Builder.getKeyGenerator(algorithm);
        if (keySize <= 0 && Algorithm.AES.getValue().equals(algorithm)) {
            keySize = 128;
        }
        if (keySize > 0) {
            if (null == random) {
                keyGenerator.init(keySize);
            } else {
                keyGenerator.init(keySize, random);
            }
        }
        return keyGenerator.generateKey();
    }

    public static SecretKey generateKey(String algorithm, byte[] key) {
        Assert.notBlank((CharSequence)algorithm, (String)"Algorithm is blank!", (Object[])new Object[0]);
        SecretKey secretKey = algorithm.startsWith("PBE") ? Builder.generatePBEKey(algorithm, null == key ? null : StringKit.toString((Object)key).toCharArray()) : (algorithm.startsWith("DES") ? Builder.generateDESKey(algorithm, key) : (null == key ? Builder.generateKey(algorithm) : new SecretKeySpec(key, algorithm)));
        return secretKey;
    }

    public static SecretKey generateDESKey(String algorithm, byte[] key) {
        SecretKey secretKey;
        if (StringKit.isBlank((CharSequence)algorithm) || !algorithm.startsWith("DES")) {
            throw new CryptoException("Algorithm [{}] is not a DES algorithm!", new Object[]{algorithm});
        }
        if (null == key) {
            secretKey = Builder.generateKey(algorithm);
        } else {
            KeySpec keySpec;
            try {
                keySpec = algorithm.startsWith(Algorithm.DESEDE.getValue()) ? new DESedeKeySpec(key) : new DESKeySpec(key);
            }
            catch (InvalidKeyException e) {
                throw new CryptoException((Throwable)e);
            }
            secretKey = Builder.generateKey(algorithm, keySpec);
        }
        return secretKey;
    }

    public static SecretKey generatePBEKey(String algorithm, char[] key) {
        if (StringKit.isBlank((CharSequence)algorithm) || !algorithm.startsWith("PBE")) {
            throw new CryptoException("Algorithm [{}] is not a PBE algorithm!", new Object[]{algorithm});
        }
        if (null == key) {
            key = RandomKit.randomString((int)32).toCharArray();
        }
        PBEKeySpec keySpec = new PBEKeySpec(key);
        return Builder.generateKey(algorithm, keySpec);
    }

    public static SecretKey generateKey(String algorithm, KeySpec keySpec) {
        SecretKeyFactory keyFactory = Builder.getSecretKeyFactory(algorithm);
        try {
            return keyFactory.generateSecret(keySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new CryptoException((Throwable)e);
        }
    }

    public static PrivateKey generateRSAPrivateKey(byte[] key) {
        return Builder.generatePrivateKey(Algorithm.RSA.getValue(), key);
    }

    public static PublicKey generatePublicKey(String algorithm, byte[] key) {
        if (null == key) {
            return null;
        }
        return Builder.generatePublicKey(algorithm, new X509EncodedKeySpec(key));
    }

    public static PrivateKey generatePrivateKey(String algorithm, byte[] key) {
        if (null == key) {
            return null;
        }
        return Builder.generatePrivateKey(algorithm, new PKCS8EncodedKeySpec(key));
    }

    public static PrivateKey generatePrivateKey(String algorithm, KeySpec keySpec) {
        if (null == keySpec) {
            return null;
        }
        algorithm = Builder.getAlgorithmAfterWith(algorithm);
        try {
            return Builder.getKeyFactory(algorithm).generatePrivate(keySpec);
        }
        catch (Exception e) {
            throw new CryptoException((Throwable)e);
        }
    }

    public static PrivateKey generatePrivateKey(KeyStore keyStore, String alias, char[] password) {
        try {
            return (PrivateKey)keyStore.getKey(alias, password);
        }
        catch (Exception e) {
            throw new CryptoException((Throwable)e);
        }
    }

    public static PublicKey generateRSAPublicKey(byte[] key) {
        return Builder.generatePublicKey(Algorithm.RSA.getValue(), key);
    }

    public static KeyPair generateKeyPair(String algorithm, AlgorithmParameterSpec params) {
        return Builder.generateKeyPair(algorithm, null, params);
    }

    public static KeyPair generateKeyPair(String algorithm, byte[] seed, AlgorithmParameterSpec param) {
        return Builder.generateKeyPair(algorithm, 1024, seed, param);
    }

    public static PublicKey generatePublicKey(String algorithm, KeySpec keySpec) {
        if (null == keySpec) {
            return null;
        }
        algorithm = Builder.getAlgorithmAfterWith(algorithm);
        try {
            return Builder.getKeyFactory(algorithm).generatePublic(keySpec);
        }
        catch (Exception e) {
            throw new CryptoException((Throwable)e);
        }
    }

    public static KeyPair generateKeyPair(String algorithm) {
        int keySize = 1024;
        if ("ECIES".equalsIgnoreCase(algorithm)) {
            keySize = 256;
        }
        return Builder.generateKeyPair(algorithm, keySize);
    }

    public static KeyPair generateKeyPair(String algorithm, int keySize) {
        return Builder.generateKeyPair(algorithm, keySize, null);
    }

    public static KeyPair generateKeyPair(String algorithm, int keySize, byte[] seed) {
        if (Algorithm.SM2.getValue().equalsIgnoreCase(algorithm)) {
            ECGenParameterSpec sm2p256v1 = new ECGenParameterSpec(SM2_DEFAULT_CURVE);
            return Builder.generateKeyPair(algorithm, keySize, seed, sm2p256v1);
        }
        return Builder.generateKeyPair(algorithm, keySize, seed, (AlgorithmParameterSpec[])null);
    }

    public static KeyPair generateKeyPair(String algorithm, int keySize, byte[] seed, AlgorithmParameterSpec ... params) {
        return Builder.generateKeyPair(algorithm, keySize, RandomKit.getSecureRandom((byte[])seed), params);
    }

    public static KeyPair generateKeyPair(String algorithm, int keySize, SecureRandom random, AlgorithmParameterSpec ... params) {
        algorithm = Builder.getAlgorithmAfterWith(algorithm);
        KeyPairGenerator keyPairGen = Builder.getKeyPairGenerator(algorithm);
        if (keySize > 0) {
            if ("EC".equalsIgnoreCase(algorithm) && keySize > 256) {
                keySize = 256;
            }
            if (null != random) {
                keyPairGen.initialize(keySize, random);
            } else {
                keyPairGen.initialize(keySize);
            }
        }
        if (ArrayKit.isNotEmpty((Object[])params)) {
            for (AlgorithmParameterSpec param : params) {
                if (null == param) continue;
                try {
                    if (null != random) {
                        keyPairGen.initialize(param, random);
                        continue;
                    }
                    keyPairGen.initialize(param);
                }
                catch (InvalidAlgorithmParameterException e) {
                    throw new CryptoException((Throwable)e);
                }
            }
        }
        return keyPairGen.generateKeyPair();
    }

    public static KeyPairGenerator getKeyPairGenerator(String algorithm) {
        KeyPairGenerator keyPairGen;
        java.security.Provider provider = ((Holder)Instances.singletion(Holder.class)).getProvider();
        try {
            keyPairGen = null == provider ? KeyPairGenerator.getInstance(Builder.getMainAlgorithm(algorithm)) : KeyPairGenerator.getInstance(Builder.getMainAlgorithm(algorithm), provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException((Throwable)e);
        }
        return keyPairGen;
    }

    public static KeyFactory getKeyFactory(String algorithm) {
        KeyFactory keyFactory;
        java.security.Provider provider = ((Holder)Instances.singletion(Holder.class)).getProvider();
        try {
            keyFactory = null == provider ? KeyFactory.getInstance(Builder.getMainAlgorithm(algorithm)) : KeyFactory.getInstance(Builder.getMainAlgorithm(algorithm), provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException((Throwable)e);
        }
        return keyFactory;
    }

    public static KeyStore readJKSKeyStore(File keyFile, char[] password) {
        return Builder.readKeyStore(KEY_TYPE_JKS, keyFile, password);
    }

    public static SecretKeyFactory getSecretKeyFactory(String algorithm) {
        SecretKeyFactory keyFactory;
        java.security.Provider provider = ((Holder)Instances.singletion(Holder.class)).getProvider();
        try {
            keyFactory = null == provider ? SecretKeyFactory.getInstance(Builder.getMainAlgorithm(algorithm)) : SecretKeyFactory.getInstance(Builder.getMainAlgorithm(algorithm), provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException((Throwable)e);
        }
        return keyFactory;
    }

    public static KeyStore readPKCS12KeyStore(File keyFile, char[] password) {
        return Builder.readKeyStore(KEY_TYPE_PKCS12, keyFile, password);
    }

    public static KeyStore readPKCS12KeyStore(InputStream in, char[] password) {
        return Builder.readKeyStore(KEY_TYPE_PKCS12, in, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore readKeyStore(String type, File keyFile, char[] password) {
        BufferedInputStream in = null;
        try {
            in = FileKit.getInputStream((File)keyFile);
            KeyStore keyStore = Builder.readKeyStore(type, in, password);
            return keyStore;
        }
        finally {
            IoKit.close((Closeable)in);
        }
    }

    public static KeyGenerator getKeyGenerator(String algorithm) {
        KeyGenerator generator;
        java.security.Provider provider = ((Holder)Instances.singletion(Holder.class)).getProvider();
        try {
            generator = null == provider ? KeyGenerator.getInstance(Builder.getMainAlgorithm(algorithm)) : KeyGenerator.getInstance(Builder.getMainAlgorithm(algorithm), provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException((Throwable)e);
        }
        return generator;
    }

    public static KeyPair getKeyPair(String type, InputStream in, char[] password, String alias) {
        KeyStore keyStore = Builder.readKeyStore(type, in, password);
        return Builder.getKeyPair(keyStore, password, alias);
    }

    public static String getMainAlgorithm(String algorithm) {
        Assert.notBlank((CharSequence)algorithm, (String)"Algorithm must be not blank!", (Object[])new Object[0]);
        int slashIndex = algorithm.indexOf(47);
        if (slashIndex > 0) {
            return algorithm.substring(0, slashIndex);
        }
        return algorithm;
    }

    public static String getAlgorithmAfterWith(String algorithm) {
        Assert.notNull((Object)algorithm, (String)"algorithm must be not null !", (Object[])new Object[0]);
        if (StringKit.startWithIgnoreCase((CharSequence)algorithm, (CharSequence)"ECIESWith")) {
            return "EC";
        }
        int indexOfWith = StringKit.lastIndexOfIgnoreCase((CharSequence)algorithm, (CharSequence)"with");
        if (indexOfWith > 0) {
            algorithm = StringKit.subSuf((CharSequence)algorithm, (int)(indexOfWith + "with".length()));
        }
        if ("ECDSA".equalsIgnoreCase(algorithm) || "SM2".equalsIgnoreCase(algorithm) || "ECIES".equalsIgnoreCase(algorithm)) {
            algorithm = "EC";
        }
        return algorithm;
    }

    public static KeyStore readJKSKeyStore(InputStream in, char[] password) {
        return Builder.readKeyStore(KEY_TYPE_JKS, in, password);
    }

    public static KeyStore readKeyStore(String type, InputStream in, char[] password) {
        KeyStore keyStore;
        try {
            keyStore = KeyStore.getInstance(type);
            keyStore.load(in, password);
        }
        catch (Exception e) {
            throw new CryptoException((Throwable)e);
        }
        return keyStore;
    }

    public static KeyPair getKeyPair(KeyStore keyStore, char[] password, String alias) {
        PrivateKey privateKey;
        PublicKey publicKey;
        try {
            publicKey = keyStore.getCertificate(alias).getPublicKey();
            privateKey = (PrivateKey)keyStore.getKey(alias, password);
        }
        catch (Exception e) {
            throw new CryptoException((Throwable)e);
        }
        return new KeyPair(publicKey, privateKey);
    }

    public static Certificate readX509Certificate(InputStream in, char[] password, String alias) {
        return Builder.readCertificate(CERT_TYPE_X509, in, password, alias);
    }

    public static PublicKey readPublicKeyFromCert(InputStream in) {
        Certificate certificate = Builder.readX509Certificate(in);
        if (null != certificate) {
            return certificate.getPublicKey();
        }
        return null;
    }

    public static Certificate readX509Certificate(InputStream in) {
        return Builder.readCertificate(CERT_TYPE_X509, in);
    }

    public static Certificate readCertificate(String type, InputStream in, char[] password, String alias) {
        KeyStore keyStore = Builder.readKeyStore(type, in, password);
        try {
            return keyStore.getCertificate(alias);
        }
        catch (KeyStoreException e) {
            throw new CryptoException((Throwable)e);
        }
    }

    public static Certificate readCertificate(String type, InputStream in) {
        try {
            return Builder.getCertificateFactory(type).generateCertificate(in);
        }
        catch (CertificateException e) {
            throw new CryptoException((Throwable)e);
        }
    }

    public static Certificate getCertificate(KeyStore keyStore, String alias) {
        try {
            return keyStore.getCertificate(alias);
        }
        catch (Exception e) {
            throw new CryptoException((Throwable)e);
        }
    }

    public static CertificateFactory getCertificateFactory(String type) {
        CertificateFactory factory;
        java.security.Provider provider = ((Holder)Instances.singletion(Holder.class)).getProvider();
        try {
            factory = null == provider ? CertificateFactory.getInstance(type) : CertificateFactory.getInstance(type, provider);
        }
        catch (CertificateException e) {
            throw new CryptoException((Throwable)e);
        }
        return factory;
    }

    public static PublicKey getRSAPublicKey(PrivateKey privateKey) {
        if (privateKey instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey privk = (RSAPrivateCrtKey)privateKey;
            return Builder.getRSAPublicKey(privk.getModulus(), privk.getPublicExponent());
        }
        return null;
    }

    public static PublicKey getRSAPublicKey(String modulus, String publicExponent) {
        return Builder.getRSAPublicKey(new BigInteger(modulus, 16), new BigInteger(publicExponent, 16));
    }

    public static byte[] readPem(InputStream keyStream) {
        PemObject pemObject = Builder.readPemObject(keyStream);
        if (null != pemObject) {
            return pemObject.getContent();
        }
        return null;
    }

    public static PublicKey getRSAPublicKey(BigInteger modulus, BigInteger publicExponent) {
        RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(modulus, publicExponent);
        try {
            return Builder.getKeyFactory(Algorithm.RSA.name()).generatePublic(publicKeySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new CryptoException((Throwable)e);
        }
    }

    public static PrivateKey readPrivateKey(InputStream pemStream) {
        return (PrivateKey)Builder.readPemKey(pemStream);
    }

    public static PublicKey readPublicKey(InputStream pemStream) {
        return (PublicKey)Builder.readPemKey(pemStream);
    }

    public static Key readPemKey(InputStream keyStream) {
        PemObject object = Builder.readPemObject(keyStream);
        String type = object.getType();
        if (StringKit.isNotBlank((CharSequence)type)) {
            if (type.endsWith("EC PRIVATE KEY")) {
                return Builder.generatePrivateKey("EC", object.getContent());
            }
            if (type.endsWith("PRIVATE KEY")) {
                return Builder.generateRSAPrivateKey(object.getContent());
            }
            if (type.endsWith("EC PUBLIC KEY")) {
                return Builder.generatePublicKey("EC", object.getContent());
            }
            if (type.endsWith("PUBLIC KEY")) {
                return Builder.generateRSAPublicKey(object.getContent());
            }
            if (type.endsWith("CERTIFICATE")) {
                return Builder.readPublicKeyFromCert(IoKit.toStream((byte[])object.getContent()));
            }
        }
        return null;
    }

    public static void writePemObject(String type, byte[] content, OutputStream keyStream) {
        Builder.writePemObject((PemObjectGenerator)new PemObject(type, content), keyStream);
    }

    public static void writePemObject(String type, byte[] content, Writer writer) {
        Builder.writePemObject((PemObjectGenerator)new PemObject(type, content), writer);
    }

    public static PemObject readPemObject(InputStream keyStream) {
        return Builder.readPemObject(IoKit.getReader((InputStream)keyStream, (Charset)org.aoju.bus.core.lang.Charset.UTF_8));
    }

    public static PemObject readPemObject(Reader reader) {
        PemObject pemObject;
        PemReader pemReader = null;
        try {
            pemReader = new PemReader(reader);
            pemObject = pemReader.readPemObject();
        }
        catch (IOException e) {
            try {
                throw new CryptoException((Throwable)e);
            }
            catch (Throwable throwable) {
                IoKit.close(pemReader);
                throw throwable;
            }
        }
        IoKit.close((Closeable)pemReader);
        return pemObject;
    }

    public static PrivateKey readSm2PemPrivateKey(InputStream keyStream) {
        try {
            PrivateKey privateKey = Builder.generatePrivateKey(Algorithm.SM2.getValue(), Builder.createOpenSSHPrivateKeySpec(Builder.readPem(keyStream)));
            return privateKey;
        }
        finally {
            IoKit.close((Closeable)keyStream);
        }
    }

    public static String toPem(String type, byte[] content) {
        StringWriter stringWriter = new StringWriter();
        Builder.writePemObject(type, content, stringWriter);
        return stringWriter.toString();
    }

    public static void writePemObject(PemObjectGenerator pemObject, OutputStream keyStream) {
        Builder.writePemObject(pemObject, IoKit.getWriter((OutputStream)keyStream, (Charset)org.aoju.bus.core.lang.Charset.UTF_8));
    }

    public static void writePemObject(PemObjectGenerator pemObject, Writer writer) {
        PemWriter pemWriter = new PemWriter(writer);
        try {
            pemWriter.writeObject(pemObject);
        }
        catch (IOException e) {
            throw new CryptoException((Throwable)e);
        }
        finally {
            IoKit.close((Closeable)pemWriter);
        }
    }

    public static String hashpw(String password) {
        return new BCrypt().hashpw(password);
    }

    public static boolean checkpw(String password, String hashed) {
        return new BCrypt().checkpw(password, hashed);
    }

    public static byte[] changeC1C2C3ToC1C3C2(byte[] c1c2c3, ECDomainParameters ecDomainParameters) {
        int c1Len = (ecDomainParameters.getCurve().getFieldSize() + 7) / 8 * 2 + 1;
        int c3Len = 32;
        byte[] result = new byte[c1c2c3.length];
        System.arraycopy(c1c2c3, 0, result, 0, c1Len);
        System.arraycopy(c1c2c3, c1c2c3.length - 32, result, c1Len, 32);
        System.arraycopy(c1c2c3, c1Len, result, c1Len + 32, c1c2c3.length - c1Len - 32);
        return result;
    }

    public static byte[] changeC1C3C2ToC1C2C3(byte[] c1c3c2, ECDomainParameters ecDomainParameters) {
        int c1Len = (ecDomainParameters.getCurve().getFieldSize() + 7) / 8 * 2 + 1;
        int c3Len = 32;
        byte[] result = new byte[c1c3c2.length];
        System.arraycopy(c1c3c2, 0, result, 0, c1Len);
        System.arraycopy(c1c3c2, c1Len + 32, result, c1Len, c1c3c2.length - c1Len - 32);
        System.arraycopy(c1c3c2, c1Len, result, c1c3c2.length - 32, 32);
        return result;
    }

    public static byte[] rsAsn1ToPlain(byte[] rsDer) {
        BigInteger[] decode;
        try {
            decode = StandardDSAEncoding.INSTANCE.decode(SM2_DOMAIN_PARAMS.getN(), rsDer);
        }
        catch (IOException e) {
            throw new CryptoException((Throwable)e);
        }
        byte[] r = Builder.bigIntToFixedLengthBytes(decode[0]);
        byte[] s = Builder.bigIntToFixedLengthBytes(decode[1]);
        return ArrayKit.addAll((byte[][])new byte[][]{r, s});
    }

    public static byte[] rsPlainToAsn1(byte[] sign) {
        if (sign.length != 64) {
            throw new CryptoException("err rs. ");
        }
        BigInteger r = new BigInteger(1, Arrays.copyOfRange((byte[])sign, (int)0, (int)32));
        BigInteger s = new BigInteger(1, Arrays.copyOfRange((byte[])sign, (int)32, (int)64));
        try {
            return StandardDSAEncoding.INSTANCE.encode(SM2_DOMAIN_PARAMS.getN(), r, s);
        }
        catch (IOException e) {
            throw new CryptoException((Throwable)e);
        }
    }

    public static MacEngine createHmacSm3Engine(byte[] key) {
        return new BCHMacEngine((Digest)new SM3Digest(), key);
    }

    public static void addProvider(java.security.Provider provider) {
        Security.insertProviderAt(provider, 0);
    }

    public static Cipher createCipher(String algorithm) {
        Cipher cipher;
        java.security.Provider provider = ((Holder)Instances.singletion(Holder.class)).getProvider();
        try {
            cipher = null == provider ? Cipher.getInstance(algorithm) : Cipher.getInstance(algorithm, provider);
        }
        catch (Exception e) {
            throw new CryptoException((Throwable)e);
        }
        return cipher;
    }

    public static MessageDigest createMessageDigest(String algorithm) {
        MessageDigest messageDigest;
        java.security.Provider provider = ((Holder)Instances.singletion(Holder.class)).getProvider();
        try {
            messageDigest = null == provider ? MessageDigest.getInstance(algorithm) : MessageDigest.getInstance(algorithm, provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException((Throwable)e);
        }
        return messageDigest;
    }

    public static Mac createMac(String algorithm) {
        Mac mac;
        java.security.Provider provider = ((Holder)Instances.singletion(Holder.class)).getProvider();
        try {
            mac = null == provider ? Mac.getInstance(algorithm) : Mac.getInstance(algorithm, provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException((Throwable)e);
        }
        return mac;
    }

    public static Signature createSignature(String algorithm) {
        Signature signature;
        java.security.Provider provider = ((Holder)Instances.singletion(Holder.class)).getProvider();
        try {
            signature = null == provider ? Signature.getInstance(algorithm) : Signature.getInstance(algorithm, provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException((Throwable)e);
        }
        return signature;
    }

    private static byte[] bigIntToFixedLengthBytes(BigInteger rOrS) {
        byte[] rs = rOrS.toByteArray();
        if (rs.length == 32) {
            return rs;
        }
        if (rs.length == 33 && rs[0] == 0) {
            return Arrays.copyOfRange((byte[])rs, (int)1, (int)33);
        }
        if (rs.length < 32) {
            byte[] result = new byte[32];
            Arrays.fill((byte[])result, (byte)0);
            System.arraycopy(rs, 0, result, 32 - rs.length, rs.length);
            return result;
        }
        throw new CryptoException("Error rs: {}", new Object[]{Hex.toHexString((byte[])rs)});
    }
}

