/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.crypto.asymmetric;

import java.io.InputStream;
import org.aoju.bus.core.codec.BCD;
import org.aoju.bus.core.exception.CryptoException;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.crypto.Builder;
import org.aoju.bus.crypto.asymmetric.KeyType;

public interface Decryptor {
    public byte[] decrypt(byte[] var1, KeyType var2);

    default public byte[] decrypt(InputStream data, KeyType keyType) throws CryptoException {
        return this.decrypt(IoKit.readBytes((InputStream)data), keyType);
    }

    default public byte[] decrypt(String data, KeyType keyType) {
        return this.decrypt(Builder.decode(data), keyType);
    }

    default public String decryptStr(String data, KeyType keyType, java.nio.charset.Charset charset) {
        return StringKit.toString((byte[])this.decrypt(data, keyType), (java.nio.charset.Charset)charset);
    }

    default public String decryptStr(String data, KeyType keyType) {
        return this.decryptStr(data, keyType, Charset.UTF_8);
    }

    default public byte[] decryptFromBcd(String data, KeyType keyType) {
        return this.decryptFromBcd(data, keyType, Charset.UTF_8);
    }

    default public byte[] decryptFromBcd(String data, KeyType keyType, java.nio.charset.Charset charset) {
        Assert.notNull((Object)data, (String)"Bcd string must be not null!", (Object[])new Object[0]);
        byte[] dataBytes = BCD.ascToBcd((byte[])StringKit.bytes((CharSequence)data, (java.nio.charset.Charset)charset));
        return this.decrypt(dataBytes, keyType);
    }

    default public String decryptStrFromBcd(String data, KeyType keyType, java.nio.charset.Charset charset) {
        return StringKit.toString((byte[])this.decryptFromBcd(data, keyType, charset), (java.nio.charset.Charset)charset);
    }

    default public String decryptStrFromBcd(String data, KeyType keyType) {
        return this.decryptStrFromBcd(data, keyType, Charset.UTF_8);
    }
}

