/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.crypto.symmetric;

import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.aoju.bus.core.lang.Algorithm;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.crypto.Builder;
import org.aoju.bus.crypto.Mode;
import org.aoju.bus.crypto.Padding;
import org.aoju.bus.crypto.symmetric.Crypto;

public class DES
extends Crypto {
    private static final long serialVersionUID = 1L;

    public DES() {
        super(Algorithm.DES);
    }

    public DES(byte[] key) {
        super(Algorithm.DES, key);
    }

    public DES(Mode mode, Padding padding) {
        this(mode.name(), padding.name());
    }

    public DES(Mode mode, Padding padding, byte[] key) {
        this(mode, padding, key, null);
    }

    public DES(Mode mode, Padding padding, byte[] key, byte[] iv) {
        this(mode.name(), padding.name(), key, iv);
    }

    public DES(Mode mode, Padding padding, SecretKey key) {
        this(mode, padding, key, null);
    }

    public DES(Mode mode, Padding padding, SecretKey key, IvParameterSpec iv) {
        this(mode.name(), padding.name(), key, iv);
    }

    public DES(String mode, String padding) {
        this(mode, padding, (byte[])null);
    }

    public DES(String mode, String padding, byte[] key) {
        this(mode, padding, Builder.generateKey(Algorithm.DES.getValue(), key), null);
    }

    public DES(String mode, String padding, byte[] key, byte[] iv) {
        this(mode, padding, Builder.generateKey(Algorithm.DES.getValue(), key), null == iv ? null : new IvParameterSpec(iv));
    }

    public DES(String mode, String padding, SecretKey key) {
        this(mode, padding, key, null);
    }

    public DES(String mode, String padding, SecretKey key, IvParameterSpec iv) {
        super(StringKit.format((CharSequence)"DES/{}/{}", (Object[])new Object[]{mode, padding}), key, iv);
    }
}

