/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.crypto.symmetric;

import java.io.InputStream;
import java.io.OutputStream;
import org.aoju.bus.core.codec.Base64;
import org.aoju.bus.core.exception.CryptoException;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.toolkit.HexKit;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.StringKit;

public interface Encryptor {
    public byte[] encrypt(byte[] var1);

    public void encrypt(InputStream var1, OutputStream var2, boolean var3);

    default public String encryptHex(byte[] data) {
        return HexKit.encodeHexString((byte[])this.encrypt(data));
    }

    default public String encryptBase64(byte[] data) {
        return Base64.encode((byte[])this.encrypt(data));
    }

    default public byte[] encrypt(String data, String charset) {
        return this.encrypt(StringKit.bytes((CharSequence)data, (String)charset));
    }

    default public byte[] encrypt(String data, java.nio.charset.Charset charset) {
        return this.encrypt(StringKit.bytes((CharSequence)data, (java.nio.charset.Charset)charset));
    }

    default public String encryptHex(String data, String charset) {
        return HexKit.encodeHexString((byte[])this.encrypt(data, charset));
    }

    default public String encryptHex(String data, java.nio.charset.Charset charset) {
        return HexKit.encodeHexString((byte[])this.encrypt(data, charset));
    }

    default public String encryptBase64(String data, String charset) {
        return Base64.encode((byte[])this.encrypt(data, charset));
    }

    default public String encryptBase64(String data, java.nio.charset.Charset charset) {
        return Base64.encode((byte[])this.encrypt(data, charset));
    }

    default public byte[] encrypt(String data) {
        return this.encrypt(StringKit.bytes((CharSequence)data, (java.nio.charset.Charset)Charset.UTF_8));
    }

    default public String encryptHex(String data) {
        return HexKit.encodeHexString((byte[])this.encrypt(data));
    }

    default public String encryptBase64(String data) {
        return Base64.encode((byte[])this.encrypt(data));
    }

    default public byte[] encrypt(InputStream data) throws CryptoException {
        return this.encrypt(IoKit.readBytes((InputStream)data));
    }

    default public String encryptHex(InputStream data) {
        return HexKit.encodeHexString((byte[])this.encrypt(data));
    }

    default public String encryptBase64(InputStream data) {
        return Base64.encode((byte[])this.encrypt(data));
    }
}

