/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.crypto.symmetric;

import javax.crypto.SecretKey;
import javax.crypto.spec.PBEKeySpec;
import org.aoju.bus.core.toolkit.HexKit;
import org.aoju.bus.crypto.Builder;

public class PBKDF2 {
    private String algorithm = "PBKDF2WithHmacSHA1";
    private int keyLength = 512;
    private int iterationCount = 1000;

    public PBKDF2() {
    }

    public PBKDF2(String algorithm, int keyLength, int iterationCount) {
        this.algorithm = algorithm;
        this.keyLength = keyLength;
        this.iterationCount = iterationCount;
    }

    public byte[] encrypt(char[] password, byte[] salt) {
        PBEKeySpec pbeKeySpec = new PBEKeySpec(password, salt, this.iterationCount, this.keyLength);
        SecretKey secretKey = Builder.generateKey(this.algorithm, pbeKeySpec);
        return secretKey.getEncoded();
    }

    public String encryptHex(char[] password, byte[] salt) {
        return HexKit.encodeHexString((byte[])this.encrypt(password, salt));
    }
}

