/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.crypto.asymmetric;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import org.aoju.bus.core.codec.Base64;
import org.aoju.bus.core.exception.CryptoException;
import org.aoju.bus.core.io.stream.FastByteOutputStream;
import org.aoju.bus.core.lang.Algorithm;
import org.aoju.bus.crypto.Builder;
import org.aoju.bus.crypto.Ciphers;
import org.aoju.bus.crypto.asymmetric.AbstractCrypto;
import org.aoju.bus.crypto.asymmetric.KeyType;

public class Crypto
extends AbstractCrypto<Crypto> {
    private static final long serialVersionUID = 1L;
    protected Ciphers ciphers;
    protected int encryptBlockSize = -1;
    protected int decryptBlockSize = -1;

    public Crypto(Algorithm algorithm) {
        this(algorithm, (byte[])null, (byte[])null);
    }

    public Crypto(String algorithm) {
        this(algorithm, (byte[])null, (byte[])null);
    }

    public Crypto(Algorithm algorithm, String privateKeyStr, String publicKeyStr) {
        this(algorithm.getValue(), Builder.decode(privateKeyStr), Builder.decode(publicKeyStr));
    }

    public Crypto(Algorithm algorithm, byte[] privateKey, byte[] publicKey) {
        this(algorithm.getValue(), privateKey, publicKey);
    }

    public Crypto(Algorithm algorithm, PrivateKey privateKey, PublicKey publicKey) {
        this(algorithm.getValue(), privateKey, publicKey);
    }

    public Crypto(String algorithm, String privateKeyBase64, String publicKeyBase64) {
        this(algorithm, Base64.decode((CharSequence)privateKeyBase64), Base64.decode((CharSequence)publicKeyBase64));
    }

    public Crypto(String algorithm, byte[] privateKey, byte[] publicKey) {
        this(algorithm, Builder.generatePrivateKey(algorithm, privateKey), Builder.generatePublicKey(algorithm, publicKey));
    }

    public Crypto(String algorithm, PrivateKey privateKey, PublicKey publicKey) {
        super(algorithm, privateKey, publicKey);
    }

    public int getEncryptBlockSize() {
        return this.encryptBlockSize;
    }

    public void setEncryptBlockSize(int encryptBlockSize) {
        this.encryptBlockSize = encryptBlockSize;
    }

    public int getDecryptBlockSize() {
        return this.decryptBlockSize;
    }

    public void setDecryptBlockSize(int decryptBlockSize) {
        this.decryptBlockSize = decryptBlockSize;
    }

    public AlgorithmParameterSpec getAlgorithmParameterSpec() {
        return this.ciphers.getParams();
    }

    public void setAlgorithmParameterSpec(AlgorithmParameterSpec algorithmParameterSpec) {
        this.ciphers.setParams(algorithmParameterSpec);
    }

    public Crypto setRandom(SecureRandom random) {
        this.ciphers.setRandom(random);
        return this;
    }

    @Override
    public Crypto init(String algorithm, PrivateKey privateKey, PublicKey publicKey) {
        super.init(algorithm, privateKey, publicKey);
        this.initCipher();
        return this;
    }

    @Override
    public byte[] encrypt(byte[] data, KeyType keyType) {
        Key key = this.getKeyByType(keyType);
        this.lock.lock();
        try {
            int blockSize;
            Cipher cipher = this.initMode(1, key);
            if (this.encryptBlockSize < 0 && (blockSize = cipher.getBlockSize()) > 0) {
                this.encryptBlockSize = blockSize;
            }
            byte[] byArray = this.doFinal(data, this.encryptBlockSize < 0 ? data.length : this.encryptBlockSize);
            return byArray;
        }
        catch (Exception e) {
            throw new CryptoException((Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public byte[] decrypt(byte[] data, KeyType keyType) {
        Key key = this.getKeyByType(keyType);
        this.lock.lock();
        try {
            int blockSize;
            Cipher cipher = this.initMode(2, key);
            if (this.decryptBlockSize < 0 && (blockSize = cipher.getBlockSize()) > 0) {
                this.decryptBlockSize = blockSize;
            }
            byte[] byArray = this.doFinal(data, this.decryptBlockSize < 0 ? data.length : this.decryptBlockSize);
            return byArray;
        }
        catch (Exception e) {
            throw new CryptoException((Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public Cipher getCipher() {
        return this.ciphers.getCipher();
    }

    protected void initCipher() {
        this.ciphers = new Ciphers(this.algorithm);
    }

    private byte[] doFinal(byte[] data, int maxBlockSize) throws IllegalBlockSizeException, BadPaddingException, IOException {
        int dataLength = data.length;
        if (dataLength <= maxBlockSize) {
            return this.getCipher().doFinal(data, 0, dataLength);
        }
        return this.doFinalWithBlock(data, maxBlockSize);
    }

    private byte[] doFinalWithBlock(byte[] data, int maxBlockSize) throws IllegalBlockSizeException, BadPaddingException, IOException {
        int dataLength = data.length;
        FastByteOutputStream out = new FastByteOutputStream();
        int offSet = 0;
        int remainLength = dataLength;
        while (remainLength > 0) {
            int blockSize = Math.min(remainLength, maxBlockSize);
            out.write(this.getCipher().doFinal(data, offSet, blockSize));
            remainLength = dataLength - (offSet += blockSize);
        }
        return out.toByteArray();
    }

    private Cipher initMode(int mode, Key key) throws InvalidAlgorithmParameterException, InvalidKeyException {
        return this.ciphers.initMode(mode, key).getCipher();
    }
}

