/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.crypto.digest.otp;

import org.aoju.bus.core.codec.Base32;
import org.aoju.bus.core.lang.Algorithm;
import org.aoju.bus.core.toolkit.RandomKit;
import org.aoju.bus.crypto.digest.HMac;

public class HOTP {
    public static final int DEFAULT_PASSWORD_LENGTH = 6;
    private static final int[] MOD_DIVISORS = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000};
    private final HMac mac;
    private final int passwordLength;
    private final int modDivisor;
    private final byte[] buffer;

    public HOTP(byte[] key) {
        this(6, key);
    }

    public HOTP(int passwordLength, byte[] key) {
        this(passwordLength, Algorithm.HMACSHA1, key);
    }

    public HOTP(int passwordLength, Algorithm algorithm, byte[] key) {
        if (passwordLength >= MOD_DIVISORS.length) {
            throw new IllegalArgumentException("Password length must be < " + MOD_DIVISORS.length);
        }
        this.mac = new HMac(algorithm, key);
        this.modDivisor = MOD_DIVISORS[passwordLength];
        this.passwordLength = passwordLength;
        this.buffer = new byte[8];
    }

    public static String generateSecretKey(int numBytes) {
        return Base32.encode((byte[])RandomKit.getSecureRandom((byte[])RandomKit.randomBytes((int)256)).generateSeed(numBytes));
    }

    public synchronized int generate(long counter) {
        this.buffer[0] = (byte)((counter & 0xFF00000000000000L) >>> 56);
        this.buffer[1] = (byte)((counter & 0xFF000000000000L) >>> 48);
        this.buffer[2] = (byte)((counter & 0xFF0000000000L) >>> 40);
        this.buffer[3] = (byte)((counter & 0xFF00000000L) >>> 32);
        this.buffer[4] = (byte)((counter & 0xFF000000L) >>> 24);
        this.buffer[5] = (byte)((counter & 0xFF0000L) >>> 16);
        this.buffer[6] = (byte)((counter & 0xFF00L) >>> 8);
        this.buffer[7] = (byte)(counter & 0xFFL);
        byte[] digest = this.mac.digest(this.buffer);
        return this.truncate(digest);
    }

    public int getPasswordLength() {
        return this.passwordLength;
    }

    public String getAlgorithm() {
        return this.mac.getAlgorithm();
    }

    private int truncate(byte[] digest) {
        int offset = digest[digest.length - 1] & 0xF;
        return ((digest[offset] & 0x7F) << 24 | (digest[offset + 1] & 0xFF) << 16 | (digest[offset + 2] & 0xFF) << 8 | digest[offset + 3] & 0xFF) % this.modDivisor;
    }
}

