/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import org.aoju.bus.core.lang.function.XWrapper;
import org.aoju.bus.crypto.Builder;

public class Ciphers
implements XWrapper<Cipher> {
    private final Cipher cipher;
    private AlgorithmParameterSpec params;
    private SecureRandom random;

    public Ciphers(String algorithm) {
        this(Builder.createCipher(algorithm));
    }

    public Ciphers(Cipher cipher) {
        this.cipher = cipher;
    }

    public AlgorithmParameterSpec getParams() {
        return this.params;
    }

    public Ciphers setParams(AlgorithmParameterSpec params) {
        this.params = params;
        return this;
    }

    public Ciphers setRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public Cipher getRaw() {
        return this.cipher;
    }

    public Ciphers initMode(int mode, Key key) throws InvalidKeyException, InvalidAlgorithmParameterException {
        Cipher cipher = this.cipher;
        AlgorithmParameterSpec params = this.params;
        SecureRandom random = this.random;
        if (null != params) {
            if (null != random) {
                cipher.init(mode, key, params, random);
            } else {
                cipher.init(mode, key, params);
            }
        } else if (null != random) {
            cipher.init(mode, key, random);
        } else {
            cipher.init(mode, key);
        }
        return this;
    }
}

