/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.crypto.asymmetric;

import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAKey;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import org.aoju.bus.core.exception.CryptoException;
import org.aoju.bus.core.instance.Instances;
import org.aoju.bus.core.lang.Algorithm;
import org.aoju.bus.crypto.Builder;
import org.aoju.bus.crypto.Holder;
import org.aoju.bus.crypto.asymmetric.Crypto;
import org.aoju.bus.crypto.asymmetric.KeyType;

public class RSA
extends Crypto {
    private static final long serialVersionUID = 1L;

    public RSA() {
        super(Algorithm.RSA_ECB_PKCS1);
    }

    public RSA(String rsaAlgorithm) {
        super(rsaAlgorithm);
    }

    public RSA(String privateKeyStr, String publicKeyStr) {
        super(Algorithm.RSA_ECB_PKCS1, privateKeyStr, publicKeyStr);
    }

    public RSA(String rsaAlgorithm, String privateKeyStr, String publicKeyStr) {
        super(rsaAlgorithm, privateKeyStr, publicKeyStr);
    }

    public RSA(byte[] privateKey, byte[] publicKey) {
        super(Algorithm.RSA_ECB_PKCS1, privateKey, publicKey);
    }

    public RSA(BigInteger modulus, BigInteger privateExponent, BigInteger publicExponent) {
        this(RSA.generatePrivateKey(modulus, privateExponent), RSA.generatePublicKey(modulus, publicExponent));
    }

    public RSA(PrivateKey privateKey, PublicKey publicKey) {
        super(Algorithm.RSA_ECB_PKCS1, privateKey, publicKey);
    }

    public RSA(String rsaAlgorithm, PrivateKey privateKey, PublicKey publicKey) {
        super(rsaAlgorithm, privateKey, publicKey);
    }

    public static PrivateKey generatePrivateKey(BigInteger modulus, BigInteger privateExponent) {
        return Builder.generatePrivateKey(Algorithm.RSA_ECB_PKCS1.getValue(), new RSAPrivateKeySpec(modulus, privateExponent));
    }

    public static PublicKey generatePublicKey(BigInteger modulus, BigInteger publicExponent) {
        return Builder.generatePublicKey(Algorithm.RSA_ECB_PKCS1.getValue(), new RSAPublicKeySpec(modulus, publicExponent));
    }

    @Override
    public byte[] encrypt(byte[] data, KeyType keyType) {
        if (this.encryptBlockSize < 0 && null == ((Holder)Instances.singletion(Holder.class)).getProvider()) {
            this.encryptBlockSize = ((RSAKey)((Object)this.getKeyByType(keyType))).getModulus().bitLength() / 8 - 11;
        }
        return super.encrypt(data, keyType);
    }

    @Override
    public byte[] decrypt(byte[] bytes, KeyType keyType) {
        if (this.decryptBlockSize < 0 && null == ((Holder)Instances.singletion(Holder.class)).getProvider()) {
            this.decryptBlockSize = ((RSAKey)((Object)this.getKeyByType(keyType))).getModulus().bitLength() / 8;
        }
        return super.decrypt(bytes, keyType);
    }

    @Override
    protected void initCipher() {
        try {
            super.initCipher();
        }
        catch (CryptoException e) {
            Throwable cause = e.getCause();
            if (cause instanceof NoSuchAlgorithmException) {
                this.algorithm = Algorithm.RSA.getValue();
                super.initCipher();
            }
            throw e;
        }
    }
}

