/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.crypto.asymmetric;

import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.aoju.bus.core.lang.Algorithm;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.toolkit.HexKit;
import org.aoju.bus.crypto.Builder;
import org.aoju.bus.crypto.asymmetric.AbstractCrypto;
import org.aoju.bus.crypto.asymmetric.KeyType;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithID;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.DSAEncoding;
import org.bouncycastle.crypto.signers.PlainDSAEncoding;
import org.bouncycastle.crypto.signers.SM2Signer;
import org.bouncycastle.crypto.signers.StandardDSAEncoding;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Hex;

public class SM2
extends AbstractCrypto<SM2> {
    private static final long serialVersionUID = 1L;
    protected SM2Engine engine;
    protected SM2Signer signer;
    private ECPrivateKeyParameters privateKeyParams;
    private ECPublicKeyParameters publicKeyParams;
    private DSAEncoding encoding = StandardDSAEncoding.INSTANCE;
    private Digest digest = new SM3Digest();
    private SM2Engine.Mode mode = SM2Engine.Mode.C1C3C2;

    public SM2() {
        this(null, (byte[])null);
    }

    public SM2(String privateKey, String publicKey) {
        this(Builder.decode(privateKey), Builder.decode(publicKey));
    }

    public SM2(byte[] privateKey, byte[] publicKey) {
        this(Builder.decodePrivateKeyParams(privateKey), Builder.decodePublicKeyParams(publicKey));
    }

    public SM2(PrivateKey privateKey, PublicKey publicKey) {
        this(Builder.toParams(privateKey), Builder.toParams(publicKey));
        if (null != privateKey) {
            this.privateKey = privateKey;
        }
        if (null != publicKey) {
            this.publicKey = publicKey;
        }
    }

    public SM2(String privateKey, String publicKeyPointX, String publicKeyPointY) {
        this(Builder.toSm2Params(privateKey), Builder.toSm2Params(publicKeyPointX, publicKeyPointY));
    }

    public SM2(byte[] privateKey, byte[] publicKeyPointX, byte[] publicKeyPointY) {
        this(Builder.toSm2Params(privateKey), Builder.toSm2Params(publicKeyPointX, publicKeyPointY));
    }

    public SM2(ECPrivateKeyParameters privateKeyParams, ECPublicKeyParameters publicKeyParams) {
        super(Algorithm.SM2.getValue(), null, null);
        this.privateKeyParams = privateKeyParams;
        this.publicKeyParams = publicKeyParams;
        this.init();
    }

    public SM2 init() {
        if (null == this.privateKeyParams && null == this.publicKeyParams) {
            super.initKeys();
            this.privateKeyParams = Builder.toParams(this.privateKey);
            this.publicKeyParams = Builder.toParams(this.publicKey);
        }
        return this;
    }

    @Override
    public SM2 initKeys() {
        return this;
    }

    public byte[] encrypt(byte[] data) throws org.aoju.bus.core.exception.CryptoException {
        return this.encrypt(data, KeyType.PublicKey);
    }

    @Override
    public byte[] encrypt(byte[] data, KeyType keyType) throws org.aoju.bus.core.exception.CryptoException {
        if (KeyType.PublicKey != keyType) {
            throw new IllegalArgumentException("Encrypt is only support by public key");
        }
        return this.encrypt(data, (CipherParameters)new ParametersWithRandom(this.getCipherParameters(keyType)));
    }

    public byte[] encrypt(byte[] data, CipherParameters pubKeyParameters) throws org.aoju.bus.core.exception.CryptoException {
        this.lock.lock();
        SM2Engine engine = this.getEngine();
        try {
            engine.init(true, pubKeyParameters);
            byte[] byArray = engine.processBlock(data, 0, data.length);
            return byArray;
        }
        catch (InvalidCipherTextException e) {
            throw new org.aoju.bus.core.exception.CryptoException((Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public byte[] decrypt(byte[] data) throws org.aoju.bus.core.exception.CryptoException {
        return this.decrypt(data, KeyType.PrivateKey);
    }

    @Override
    public byte[] decrypt(byte[] data, KeyType keyType) throws org.aoju.bus.core.exception.CryptoException {
        if (KeyType.PrivateKey != keyType) {
            throw new IllegalArgumentException("Decrypt is only support by private key");
        }
        return this.decrypt(data, this.getCipherParameters(keyType));
    }

    public byte[] decrypt(byte[] data, CipherParameters privateKeyParameters) throws org.aoju.bus.core.exception.CryptoException {
        this.lock.lock();
        SM2Engine engine = this.getEngine();
        try {
            engine.init(false, privateKeyParameters);
            byte[] byArray = engine.processBlock(data, 0, data.length);
            return byArray;
        }
        catch (InvalidCipherTextException e) {
            throw new org.aoju.bus.core.exception.CryptoException((Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public String signHex(String dataHex) {
        return this.signHex(dataHex, null);
    }

    public byte[] sign(byte[] data) {
        return this.sign(data, null);
    }

    public String signHex(String dataHex, String idHex) {
        return HexKit.encodeHexString((byte[])this.sign(HexKit.decodeHex((CharSequence)dataHex), HexKit.decodeHex((CharSequence)idHex)));
    }

    public byte[] sign(byte[] data, byte[] id) {
        this.lock.lock();
        SM2Signer signer = this.getSigner();
        try {
            ParametersWithRandom param = new ParametersWithRandom(this.getCipherParameters(KeyType.PrivateKey));
            if (id != null) {
                param = new ParametersWithID((CipherParameters)param, id);
            }
            signer.init(true, (CipherParameters)param);
            signer.update(data, 0, data.length);
            byte[] byArray = signer.generateSignature();
            return byArray;
        }
        catch (CryptoException e) {
            throw new org.aoju.bus.core.exception.CryptoException((Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean verifyHex(String dataHex, String signHex) {
        return this.verifyHex(dataHex, signHex, null);
    }

    public boolean verify(byte[] data, byte[] sign) {
        return this.verify(data, sign, null);
    }

    public boolean verifyHex(String dataHex, String signHex, String idHex) {
        return this.verify(HexKit.decodeHex((CharSequence)dataHex), HexKit.decodeHex((CharSequence)signHex), HexKit.decodeHex((CharSequence)idHex));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verify(byte[] data, byte[] sign, byte[] id) {
        this.lock.lock();
        SM2Signer signer = this.getSigner();
        try {
            CipherParameters param = this.getCipherParameters(KeyType.PublicKey);
            if (id != null) {
                param = new ParametersWithID(param, id);
            }
            signer.init(false, param);
            signer.update(data, 0, data.length);
            boolean bl = signer.verifySignature(sign);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public SM2 setPrivateKey(PrivateKey privateKey) {
        super.setPrivateKey(privateKey);
        this.privateKeyParams = Builder.toParams(privateKey);
        return this;
    }

    public SM2 setPrivateKeyParams(ECPrivateKeyParameters privateKeyParams) {
        this.privateKeyParams = privateKeyParams;
        return this;
    }

    @Override
    public SM2 setPublicKey(PublicKey publicKey) {
        super.setPublicKey(publicKey);
        this.publicKeyParams = Builder.toParams(publicKey);
        return this;
    }

    public SM2 setPublicKeyParams(ECPublicKeyParameters publicKeyParams) {
        this.publicKeyParams = publicKeyParams;
        return this;
    }

    public SM2 usePlainEncoding() {
        return this.setEncoding((DSAEncoding)PlainDSAEncoding.INSTANCE);
    }

    public SM2 setEncoding(DSAEncoding encoding) {
        this.encoding = encoding;
        this.signer = null;
        return this;
    }

    public SM2 setDigest(Digest digest) {
        this.digest = digest;
        this.engine = null;
        this.signer = null;
        return this;
    }

    public SM2 setMode(SM2Engine.Mode mode) {
        this.mode = mode;
        this.engine = null;
        return this;
    }

    public byte[] getD() {
        return BigIntegers.asUnsignedByteArray((int)32, (BigInteger)this.getDBigInteger());
    }

    public String getDHex() {
        return new String(Hex.encode((byte[])this.getD()));
    }

    public BigInteger getDBigInteger() {
        return this.privateKeyParams.getD();
    }

    public byte[] getQ(boolean isCompressed) {
        return this.publicKeyParams.getQ().getEncoded(isCompressed);
    }

    private CipherParameters getCipherParameters(KeyType keyType) {
        switch (keyType) {
            case PublicKey: {
                Assert.notNull((Object)this.publicKeyParams, (String)"PublicKey must be not null !", (Object[])new Object[0]);
                return this.publicKeyParams;
            }
            case PrivateKey: {
                Assert.notNull((Object)this.privateKeyParams, (String)"PrivateKey must be not null !", (Object[])new Object[0]);
                return this.privateKeyParams;
            }
        }
        return null;
    }

    private SM2Engine getEngine() {
        if (null == this.engine) {
            Assert.notNull((Object)this.digest, (String)"digest must be not null !", (Object[])new Object[0]);
            this.engine = new SM2Engine(this.digest, this.mode);
        }
        this.digest.reset();
        return this.engine;
    }

    private SM2Signer getSigner() {
        if (null == this.signer) {
            Assert.notNull((Object)this.digest, (String)"digest must be not null !", (Object[])new Object[0]);
            this.signer = new SM2Signer(this.encoding, this.digest);
        }
        this.digest.reset();
        return this.signer;
    }
}

