/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.crypto.digest;

import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.aoju.bus.core.lang.Algorithm;
import org.aoju.bus.crypto.digest.mac.Mac;
import org.aoju.bus.crypto.digest.mac.MacEngine;
import org.aoju.bus.crypto.digest.mac.MacEngineFactory;

public class HMac
extends Mac {
    private static final long serialVersionUID = 1L;

    public HMac(Algorithm algorithm) {
        this(algorithm, (Key)null);
    }

    public HMac(Algorithm algorithm, byte[] key) {
        this(algorithm.getValue(), key);
    }

    public HMac(Algorithm algorithm, Key key) {
        this(algorithm.getValue(), key);
    }

    public HMac(String algorithm, byte[] key) {
        this(algorithm, (Key)new SecretKeySpec(key, algorithm));
    }

    public HMac(String algorithm, Key key) {
        this(algorithm, key, null);
    }

    public HMac(String algorithm, Key key, AlgorithmParameterSpec spec) {
        this(MacEngineFactory.createEngine(algorithm, key, spec));
    }

    public HMac(MacEngine engine) {
        super(engine);
    }
}

