/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.crypto.digest.mac;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import org.aoju.bus.core.codec.Base64;
import org.aoju.bus.core.exception.CryptoException;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.HexKit;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.crypto.digest.mac.MacEngine;

public class Mac
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final MacEngine engine;

    public Mac(MacEngine engine) {
        this.engine = engine;
    }

    public MacEngine getEngine() {
        return this.engine;
    }

    public byte[] digest(String data, java.nio.charset.Charset charset) {
        return this.digest(StringKit.bytes((CharSequence)data, (java.nio.charset.Charset)charset));
    }

    public byte[] digest(String data) {
        return this.digest(data, Charset.UTF_8);
    }

    public String digestBase64(String data, boolean isUrlSafe) {
        return this.digestBase64(data, Charset.UTF_8, isUrlSafe);
    }

    public String digestBase64(String data, java.nio.charset.Charset charset, boolean isUrlSafe) {
        byte[] digest = this.digest(data, charset);
        return isUrlSafe ? Base64.encodeUrlSafe((byte[])digest) : Base64.encode((byte[])digest);
    }

    public String digestHex(String data, java.nio.charset.Charset charset) {
        return HexKit.encodeHexString((byte[])this.digest(data, charset));
    }

    public String digestHex(String data) {
        return this.digestHex(data, Charset.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] digest(File file) throws CryptoException {
        BufferedInputStream in = null;
        try {
            in = FileKit.getInputStream((File)file);
            byte[] byArray = this.digest(in);
            return byArray;
        }
        finally {
            IoKit.close((Closeable)in);
        }
    }

    public String digestHex(File file) {
        return HexKit.encodeHexString((byte[])this.digest(file));
    }

    public byte[] digest(byte[] data) {
        return this.digest(new ByteArrayInputStream(data), -1);
    }

    public String digestHex(byte[] data) {
        return HexKit.encodeHexString((byte[])this.digest(data));
    }

    public byte[] digest(InputStream data) {
        return this.digest(data, 8192);
    }

    public String digestHex(InputStream data) {
        return HexKit.encodeHexString((byte[])this.digest(data));
    }

    public byte[] digest(InputStream data, int bufferLength) {
        return this.engine.digest(data, bufferLength);
    }

    public String digestHex(InputStream data, int bufferLength) {
        return HexKit.encodeHexString((byte[])this.digest(data, bufferLength));
    }

    public boolean verify(byte[] digest, byte[] digestToCompare) {
        return MessageDigest.isEqual(digest, digestToCompare);
    }

    public int getMacLength() {
        return this.engine.getMacLength();
    }

    public String getAlgorithm() {
        return this.engine.getAlgorithm();
    }
}

