/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.extra.mail;

import java.io.File;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.aoju.bus.core.lang.exception.CommonException;
import org.aoju.bus.core.utils.ArrayUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.extra.mail.GlobalMailAccount;
import org.aoju.bus.extra.mail.InternalMail;
import org.aoju.bus.extra.mail.MailAccount;
import org.aoju.bus.extra.mail.UserPassAuthenticator;

public class Mail {
    private MailAccount mailAccount;
    private String[] tos;
    private String[] ccs;
    private String[] bccs;
    private String title;
    private String content;
    private boolean isHtml;
    private DataSource[] attachments;
    private boolean useGlobalSession = true;

    public Mail() {
        this(GlobalMailAccount.INSTANCE.getAccount());
    }

    public Mail(MailAccount mailAccount) {
        mailAccount = null != mailAccount ? mailAccount : GlobalMailAccount.INSTANCE.getAccount();
        this.mailAccount = mailAccount.defaultIfEmpty();
    }

    public static Mail create(MailAccount mailAccount) {
        return new Mail(mailAccount);
    }

    public static Mail create() {
        return new Mail();
    }

    public Mail to(String ... tos) {
        return this.setTos(tos);
    }

    public Mail setTos(String ... tos) {
        this.tos = tos;
        return this;
    }

    public Mail setCcs(String ... ccs) {
        this.ccs = ccs;
        return this;
    }

    public Mail setBccs(String ... bccs) {
        this.bccs = bccs;
        return this;
    }

    public Mail setTitle(String title) {
        this.title = title;
        return this;
    }

    public Mail setContent(String content) {
        this.content = content;
        return this;
    }

    public Mail setHtml(boolean isHtml) {
        this.isHtml = isHtml;
        return this;
    }

    public Mail setFiles(File ... files) {
        DataSource[] attachments = new DataSource[files.length];
        for (int i = 0; i < files.length; ++i) {
            attachments[i] = new FileDataSource(files[i]);
        }
        return this.setAttachments(attachments);
    }

    public Mail setAttachments(DataSource ... attachments) {
        this.attachments = attachments;
        return this;
    }

    public Mail setCharset(Charset charset) {
        this.mailAccount.setCharset(charset);
        return this;
    }

    public Mail setUseGlobalSession(boolean isUseGlobalSession) {
        this.useGlobalSession = isUseGlobalSession;
        return this;
    }

    public Mail send() throws CommonException {
        try {
            return this.doSend();
        }
        catch (MessagingException e) {
            throw new CommonException((Throwable)e);
        }
    }

    private Mail doSend() throws MessagingException {
        Transport.send((Message)this.buildMsg());
        return this;
    }

    private MimeMessage buildMsg() throws MessagingException {
        Charset charset = this.mailAccount.getCharset();
        MimeMessage msg = new MimeMessage(this.getSession(this.useGlobalSession));
        String from = this.mailAccount.getFrom();
        if (StringUtils.isEmpty((Object)from)) {
            msg.setFrom();
        } else {
            msg.setFrom((Address)InternalMail.parseFirstAddress(from, charset));
        }
        msg.setSubject(this.title, charset.name());
        msg.setSentDate(new Date());
        msg.setContent(this.buildContent(charset));
        msg.setRecipients(MimeMessage.RecipientType.TO, (Address[])InternalMail.parseAddressFromStrs(this.tos, charset));
        if (ArrayUtils.isNotEmpty((Object[])this.ccs)) {
            msg.setRecipients(MimeMessage.RecipientType.CC, (Address[])InternalMail.parseAddressFromStrs(this.ccs, charset));
        }
        if (ArrayUtils.isNotEmpty((Object[])this.bccs)) {
            msg.setRecipients(MimeMessage.RecipientType.BCC, (Address[])InternalMail.parseAddressFromStrs(this.bccs, charset));
        }
        return msg;
    }

    private Multipart buildContent(Charset charset) throws MessagingException {
        MimeMultipart mainPart = new MimeMultipart();
        MimeBodyPart body = new MimeBodyPart();
        body.setContent((Object)this.content, StringUtils.format((String)"text/{}; charset={}", (Object[])new Object[]{this.isHtml ? "html" : "plain", charset}));
        mainPart.addBodyPart((BodyPart)body);
        if (ArrayUtils.isNotEmpty((Object[])this.attachments)) {
            for (DataSource attachment : this.attachments) {
                MimeBodyPart bodyPart = new MimeBodyPart();
                bodyPart.setDataHandler(new DataHandler(attachment));
                bodyPart.setFileName(InternalMail.encodeText(attachment.getName(), charset));
                mainPart.addBodyPart((BodyPart)bodyPart);
            }
        }
        return mainPart;
    }

    private Session getSession(boolean isSingleton) {
        MailAccount mailAccount = this.mailAccount;
        UserPassAuthenticator authenticator = null;
        if (mailAccount.isAuth().booleanValue()) {
            authenticator = new UserPassAuthenticator(mailAccount.getUser(), mailAccount.getPass());
        }
        return isSingleton ? Session.getDefaultInstance((Properties)mailAccount.getSmtpProps(), authenticator) : Session.getInstance((Properties)mailAccount.getSmtpProps(), authenticator);
    }
}

