/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.extra;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aoju.bus.core.bean.copier.CopyOptions;
import org.aoju.bus.core.bean.copier.ValueProvider;
import org.aoju.bus.core.consts.Charset;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.ArrayUtils;
import org.aoju.bus.core.utils.BeanUtils;
import org.aoju.bus.core.utils.FileUtils;
import org.aoju.bus.core.utils.IoUtils;
import org.aoju.bus.core.utils.ObjectUtils;
import org.aoju.bus.core.utils.ReflectUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.core.utils.UriUtils;

public class ServletUtils {
    public static Map<String, String[]> getParams(ServletRequest request) {
        Map map = request.getParameterMap();
        return Collections.unmodifiableMap(map);
    }

    public static Map<String, String> getParamMap(ServletRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        for (Map.Entry<String, String[]> entry : ServletUtils.getParams(request).entrySet()) {
            params.put(entry.getKey(), ArrayUtils.join((Object)entry.getValue(), (CharSequence)","));
        }
        return params;
    }

    public static String getBody(ServletRequest request) {
        try {
            return IoUtils.read((Reader)request.getReader());
        }
        catch (IOException e) {
            throw new InstrumentException((Throwable)e);
        }
    }

    public static byte[] getBodyBytes(ServletRequest request) {
        try {
            return IoUtils.readBytes((InputStream)request.getInputStream());
        }
        catch (IOException e) {
            throw new InstrumentException((Throwable)e);
        }
    }

    public static <T> T fillBean(final ServletRequest request, T bean, CopyOptions copyOptions) {
        final String beanName = StringUtils.lowerFirst((CharSequence)bean.getClass().getSimpleName());
        return (T)BeanUtils.fillBean(bean, (ValueProvider)new ValueProvider<String>(){

            public Object value(String key, Type valueType) {
                String value = request.getParameter(key);
                if (StringUtils.isEmpty((Object)value) && StringUtils.isEmpty((Object)(value = request.getParameter(beanName + "." + key)))) {
                    value = null;
                }
                return value;
            }

            public boolean containsKey(String key) {
                return null != request.getParameter(key) || null != request.getParameter(beanName + "." + key);
            }
        }, (CopyOptions)copyOptions);
    }

    public static <T> T fillBean(ServletRequest request, T bean, boolean isIgnoreError) {
        return ServletUtils.fillBean(request, bean, CopyOptions.create().setIgnoreError(isIgnoreError));
    }

    public static <T> T toBean(ServletRequest request, Class<T> beanClass, boolean isIgnoreError) {
        return (T)ServletUtils.fillBean(request, ReflectUtils.newInstance(beanClass, (Object[])new Object[0]), isIgnoreError);
    }

    public static String getClientIP(HttpServletRequest request, String ... otherHeaderNames) {
        Object[] headers = new String[]{"X-Forwarded-For", "X-Real-IP", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR"};
        if (ArrayUtils.isNotEmpty((Object[])otherHeaderNames)) {
            headers = (String[])ArrayUtils.addAll((Object[])headers, (Object[])otherHeaderNames);
        }
        return ServletUtils.getClientIPByHeader(request, (String[])headers);
    }

    public static String getClientIPByHeader(HttpServletRequest request, String ... headerNames) {
        String ip;
        for (String header : headerNames) {
            ip = request.getHeader(header);
            if (ServletUtils.isUnknow(ip)) continue;
            return ServletUtils.getMultistageReverseProxyIp(ip);
        }
        ip = request.getRemoteAddr();
        return ServletUtils.getMultistageReverseProxyIp(ip);
    }

    public static final String getHeaderIgnoreCase(HttpServletRequest request, String nameIgnoreCase) {
        Enumeration names = request.getHeaderNames();
        String name = null;
        while (names.hasMoreElements()) {
            name = (String)names.nextElement();
            if (name == null || !name.equalsIgnoreCase(nameIgnoreCase)) continue;
            return request.getHeader(name);
        }
        return null;
    }

    public static final String getHeader(HttpServletRequest request, String name, String charset) {
        String header = request.getHeader(name);
        if (null != header) {
            try {
                return new String(header.getBytes(Charset.ISO_8859_1), charset);
            }
            catch (UnsupportedEncodingException e) {
                throw new InstrumentException(StringUtils.format((String)"Error charset {} for http request header.", (Object[])new Object[]{charset}));
            }
        }
        return null;
    }

    public static boolean isIE(HttpServletRequest request) {
        String userAgent = ServletUtils.getHeaderIgnoreCase(request, "User-Agent");
        return StringUtils.isNotBlank((CharSequence)userAgent) && ((userAgent = userAgent.toUpperCase()).contains("MSIE") || userAgent.contains("TRIDENT"));
    }

    public static boolean isGetMethod(HttpServletRequest request) {
        return "GET".equalsIgnoreCase(request.getMethod());
    }

    public static boolean isPostMethod(HttpServletRequest request) {
        return "POST".equalsIgnoreCase(request.getMethod());
    }

    public static boolean isMultipart(HttpServletRequest request) {
        if (!ServletUtils.isPostMethod(request)) {
            return false;
        }
        String contentType = request.getContentType();
        if (StringUtils.isBlank((CharSequence)contentType)) {
            return false;
        }
        return contentType.toLowerCase().startsWith("multipart/");
    }

    public static final Cookie getCookie(HttpServletRequest httpServletRequest, String name) {
        Map<String, Cookie> cookieMap = ServletUtils.readCookieMap(httpServletRequest);
        return cookieMap == null ? null : cookieMap.get(name);
    }

    public static final Map<String, Cookie> readCookieMap(HttpServletRequest httpServletRequest) {
        HashMap<String, Cookie> cookieMap = new HashMap<String, Cookie>();
        Cookie[] cookies = httpServletRequest.getCookies();
        if (null == cookies) {
            return null;
        }
        for (Cookie cookie : cookies) {
            cookieMap.put(cookie.getName().toLowerCase(), cookie);
        }
        return cookieMap;
    }

    public static final void addCookie(HttpServletResponse response, Cookie cookie) {
        response.addCookie(cookie);
    }

    public static final void addCookie(HttpServletResponse response, String name, String value) {
        response.addCookie(new Cookie(name, value));
    }

    public static final void addCookie(HttpServletResponse response, String name, String value, int maxAgeInSeconds, String path, String domain) {
        Cookie cookie = new Cookie(name, value);
        if (domain != null) {
            cookie.setDomain(domain);
        }
        cookie.setMaxAge(maxAgeInSeconds);
        cookie.setPath(path);
        ServletUtils.addCookie(response, cookie);
    }

    public static final void addCookie(HttpServletResponse response, String name, String value, int maxAgeInSeconds) {
        ServletUtils.addCookie(response, name, value, maxAgeInSeconds, "/", null);
    }

    public static PrintWriter getWriter(HttpServletResponse response) throws InstrumentException {
        try {
            return response.getWriter();
        }
        catch (IOException e) {
            throw new InstrumentException((Throwable)e);
        }
    }

    public static void write(HttpServletResponse response, String text, String contentType) {
        response.setContentType(contentType);
        PrintWriter writer = null;
        try {
            writer = response.getWriter();
            ((Writer)writer).write(text);
            ((Writer)writer).flush();
        }
        catch (IOException e) {
            throw new InstrumentException((Throwable)e);
        }
        finally {
            IoUtils.close((Closeable)writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(HttpServletResponse response, File file) {
        String fileName = file.getName();
        String contentType = (String)ObjectUtils.defaultIfNull((Object)FileUtils.getMimeType((String)fileName), (Object)"application/octet-stream");
        BufferedInputStream in = null;
        try {
            in = FileUtils.getInputStream((File)file);
            ServletUtils.write(response, in, contentType, fileName);
        }
        finally {
            IoUtils.close((Closeable)in);
        }
    }

    public static void write(HttpServletResponse response, InputStream in, String contentType, String fileName) {
        String charset = (String)ObjectUtils.defaultIfNull((Object)response.getCharacterEncoding(), (Object)"UTF-8");
        response.setHeader("Content-Disposition", StringUtils.format((String)"attachment;filename={}", (Object[])new Object[]{UriUtils.encode((String)fileName, (String)charset)}));
        response.setContentType(contentType);
        ServletUtils.write(response, in);
    }

    public static void write(HttpServletResponse response, InputStream in, String contentType) {
        response.setContentType(contentType);
        ServletUtils.write(response, in);
    }

    public static void write(HttpServletResponse response, InputStream in) {
        ServletUtils.write(response, in, 1024);
    }

    public static void write(HttpServletResponse response, InputStream in, int bufferSize) {
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
            IoUtils.copy((InputStream)in, (OutputStream)out, (int)bufferSize);
        }
        catch (IOException e) {
            throw new InstrumentException((Throwable)e);
        }
        finally {
            IoUtils.close((Closeable)out);
            IoUtils.close((Closeable)in);
        }
    }

    public static void setHeader(HttpServletResponse response, String name, Object value) {
        if (value instanceof String) {
            response.setHeader(name, (String)value);
        } else if (Date.class.isAssignableFrom(value.getClass())) {
            response.setDateHeader(name, ((Date)value).getTime());
        } else if (value instanceof Integer || "int".equals(value.getClass().getSimpleName().toLowerCase())) {
            response.setIntHeader(name, ((Integer)value).intValue());
        } else {
            response.setHeader(name, value.toString());
        }
    }

    private static String getMultistageReverseProxyIp(String ip) {
        if (ip != null && ip.indexOf(",") > 0) {
            String[] ips;
            for (String subIp : ips = ip.trim().split(",")) {
                if (ServletUtils.isUnknow(subIp)) continue;
                ip = subIp;
                break;
            }
        }
        return ip;
    }

    private static boolean isUnknow(String checkString) {
        return StringUtils.isBlank((CharSequence)checkString) || "unknown".equalsIgnoreCase(checkString);
    }
}

