/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.extra.mail;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeUtility;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.ArrayUtils;

public class InternalMail {
    public static InternetAddress[] parseAddressFromStrs(String[] addrStrs, Charset charset) {
        ArrayList<Object> resultList = new ArrayList<Object>(addrStrs.length);
        for (int i = 0; i < addrStrs.length; ++i) {
            Object[] addrs = InternalMail.parseAddress(addrStrs[i], charset);
            if (!ArrayUtils.isNotEmpty((Object[])addrs)) continue;
            for (int j = 0; j < addrs.length; ++j) {
                resultList.add(addrs[j]);
            }
        }
        return resultList.toArray(new InternetAddress[resultList.size()]);
    }

    public static InternetAddress parseFirstAddress(String address, Charset charset) {
        Object[] internetAddresses = InternalMail.parseAddress(address, charset);
        if (ArrayUtils.isEmpty((Object[])internetAddresses)) {
            try {
                return new InternetAddress(address);
            }
            catch (AddressException e) {
                throw new InstrumentException((Throwable)e);
            }
        }
        return internetAddresses[0];
    }

    public static InternetAddress[] parseAddress(String address, Charset charset) {
        Object[] addresses;
        try {
            addresses = InternetAddress.parse((String)address);
        }
        catch (AddressException e) {
            throw new InstrumentException((Throwable)e);
        }
        if (ArrayUtils.isNotEmpty((Object[])addresses)) {
            for (Object internetAddress : addresses) {
                try {
                    internetAddress.setPersonal(internetAddress.getPersonal(), charset.name());
                }
                catch (UnsupportedEncodingException e) {
                    throw new InstrumentException((Throwable)e);
                }
            }
        }
        return addresses;
    }

    public static String encodeText(String text, Charset charset) {
        try {
            return MimeUtility.encodeText((String)text, (String)charset.name(), null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return text;
        }
    }
}

