/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.extra.effect;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.aoju.bus.core.annotation.SPI;
import org.aoju.bus.extra.effect.Provider;

public enum Factory {
    CF;

    Map<String, Provider> compressMap = new HashMap<String, Provider>();

    private Factory() {
        ServiceLoader<Provider> compresses = ServiceLoader.load(Provider.class);
        for (Provider provider : compresses) {
            SPI spi = provider.getClass().getAnnotation(SPI.class);
            if (spi == null) continue;
            String name = spi.value();
            if (this.compressMap.containsKey(name)) {
                throw new RuntimeException("The @SPI value(" + name + ") repeat, for class(" + provider.getClass() + ") and class(" + this.compressMap.get(name).getClass() + ").");
            }
            this.compressMap.put(name, provider);
        }
    }

    public Provider get(String name) {
        return this.compressMap.get(name);
    }
}

