/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.extra.ftp;

import java.io.Closeable;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import org.aoju.bus.core.utils.CollUtils;
import org.aoju.bus.core.utils.FileUtils;
import org.aoju.bus.core.utils.StringUtils;

public abstract class AbstractFtp
implements Closeable {
    public static final Charset DEFAULT_CHARSET = org.aoju.bus.core.lang.Charset.UTF_8;
    protected String host;
    protected int port;
    protected String user;
    protected String password;
    protected Charset charset;

    private static boolean containsIgnoreCase(List<String> names, String nameToFind) {
        if (CollUtils.isEmpty(names)) {
            return false;
        }
        if (StringUtils.isEmpty((Object)nameToFind)) {
            return false;
        }
        for (String name : names) {
            if (!nameToFind.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public abstract AbstractFtp reconnectIfTimeout();

    public abstract boolean cd(String var1);

    public boolean toParent() {
        return this.cd("..");
    }

    public abstract String pwd();

    public abstract boolean mkdir(String var1);

    public boolean exist(String path) {
        String fileName = FileUtils.getName((String)path);
        String dir = StringUtils.removeSuffix((CharSequence)path, (CharSequence)fileName);
        List<String> names = this.ls(dir);
        return AbstractFtp.containsIgnoreCase(names, fileName);
    }

    public abstract List<String> ls(String var1);

    public abstract boolean delFile(String var1);

    public abstract boolean delDir(String var1);

    public void mkDirs(String dir) {
        String[] dirs = StringUtils.trim((String)dir).split("[\\\\/]+");
        String now = this.pwd();
        if (dirs.length > 0 && StringUtils.isEmpty((Object)dirs[0])) {
            this.cd("/");
        }
        for (int i = 0; i < dirs.length; ++i) {
            if (!StringUtils.isNotEmpty((String)dirs[i]) || this.cd(dirs[i])) continue;
            this.mkdir(dirs[i]);
            this.cd(dirs[i]);
        }
        this.cd(now);
    }

    public abstract boolean upload(String var1, File var2);

    public abstract void download(String var1, File var2);
}

