/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.extra.captcha;

import java.awt.Font;
import java.io.OutputStream;
import java.util.Random;
import org.aoju.bus.extra.captcha.AbstractCaptcha;
import org.aoju.bus.extra.captcha.ChineseCaptcha;
import org.aoju.bus.extra.captcha.ChineseGifCaptcha;
import org.aoju.bus.extra.captcha.GifCaptcha;
import org.aoju.bus.extra.captcha.MathCaptcha;
import org.aoju.bus.extra.captcha.MathGifCaptcha;
import org.aoju.bus.extra.captcha.SpecCaptcha;

public class CaptchaUtils {
    public static String out(OutputStream outputStream) {
        return CaptchaUtils.out(5, outputStream);
    }

    public static String out(int len, OutputStream outputStream) {
        return CaptchaUtils.out(130, 48, len, outputStream);
    }

    public static String out(int len, Font font, OutputStream outputStream) {
        return CaptchaUtils.out(130, 48, len, font, outputStream);
    }

    public static String out(int width, int height, int len, OutputStream outputStream) {
        return CaptchaUtils.out(width, height, len, null, outputStream);
    }

    public static String out(int width, int height, int len, Font font, OutputStream outputStream) {
        int cType = new Random().nextInt(6);
        return CaptchaUtils.outCaptcha(width, height, len, font, cType, outputStream);
    }

    public static String outPng(OutputStream outputStream) {
        return CaptchaUtils.outPng(5, outputStream);
    }

    public static String outPng(int len, OutputStream outputStream) {
        return CaptchaUtils.outPng(130, 48, len, outputStream);
    }

    public static String outPng(int len, Font font, OutputStream outputStream) {
        return CaptchaUtils.outPng(130, 48, len, font, outputStream);
    }

    public static String outPng(int width, int height, int len, OutputStream outputStream) {
        return CaptchaUtils.outPng(width, height, len, null, outputStream);
    }

    public static String outPng(int width, int height, int len, Font font, OutputStream outputStream) {
        int cType = new Random().nextInt(6);
        return CaptchaUtils.outCaptcha(width, height, len, font, cType, outputStream);
    }

    private static String outCaptcha(int width, int height, int len, Font font, int cType, OutputStream outputStream) {
        AbstractCaptcha captcha = null;
        if (cType == 0) {
            captcha = new SpecCaptcha(width, height, len);
        } else if (cType == 1) {
            captcha = new GifCaptcha(width, height, len);
        } else if (cType == 2) {
            captcha = new ChineseCaptcha(width, height, len);
        } else if (cType == 3) {
            captcha = new ChineseGifCaptcha(width, height, len);
        } else if (cType == 4) {
            captcha = new MathCaptcha(width, height, 4);
        } else if (cType == 5) {
            captcha = new MathGifCaptcha(width, height, 4);
        }
        if (font != null) {
            captcha.setFont(font);
        }
        captcha.out(outputStream);
        return captcha.text().toLowerCase();
    }
}

