/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.extra.captcha.provider;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.aoju.bus.core.image.Graphics;
import org.aoju.bus.core.utils.ImageUtils;
import org.aoju.bus.core.utils.ObjectUtils;
import org.aoju.bus.core.utils.RandomUtils;
import org.aoju.bus.extra.captcha.provider.AbstractProvider;

public class CircleProvider
extends AbstractProvider {
    public CircleProvider(int width, int height) {
        this(width, height, 5);
    }

    public CircleProvider(int width, int height, int codeCount) {
        this(width, height, codeCount, 15);
    }

    public CircleProvider(int width, int height, int codeCount, int interfereCount) {
        super(width, height, codeCount, interfereCount);
    }

    @Override
    public Image createImage(String code) {
        BufferedImage image = new BufferedImage(this.width, this.height, 1);
        Graphics2D g = ImageUtils.createGraphics((BufferedImage)image, (Color)((Color)ObjectUtils.defaultIfNull((Object)this.background, (Object)Color.WHITE)));
        this.drawInterfere(g);
        this.drawString(g, code);
        return image;
    }

    private void drawString(Graphics2D g, String code) {
        if (null != this.textAlpha) {
            g.setComposite(this.textAlpha);
        }
        Graphics.drawStringColourful((java.awt.Graphics)g, (String)code, (Font)this.font, (int)this.width, (int)this.height);
    }

    private void drawInterfere(Graphics2D g) {
        ThreadLocalRandom random = RandomUtils.getRandom();
        for (int i = 0; i < this.interfereCount; ++i) {
            g.setColor(ImageUtils.randomColor((Random)random));
            g.drawOval(random.nextInt(this.width), random.nextInt(this.height), random.nextInt(this.height >> 1), random.nextInt(this.height >> 1));
        }
    }
}

