/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.extra.mail;

import java.io.File;
import java.util.Collection;
import java.util.List;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.extra.mail.GlobalMailAccount;
import org.aoju.bus.extra.mail.Mail;
import org.aoju.bus.extra.mail.MailAccount;

public class MailKit {
    public static void sendText(String to, String subject, String content, File ... files) {
        MailKit.send(to, subject, content, false, files);
    }

    public static void sendHtml(String to, String subject, String content, File ... files) {
        MailKit.send(to, subject, content, true, files);
    }

    public static void send(String to, String subject, String content, boolean isHtml, File ... files) {
        MailKit.send(MailKit.splitAddress(to), subject, content, isHtml, files);
    }

    public static void send(String to, String cc, String bcc, String subject, String content, boolean isHtml, File ... files) {
        MailKit.send(MailKit.splitAddress(to), MailKit.splitAddress(cc), MailKit.splitAddress(bcc), subject, content, isHtml, files);
    }

    public static void sendText(Collection<String> tos, String subject, String content, File ... files) {
        MailKit.send(tos, subject, content, false, files);
    }

    public static void sendHtml(Collection<String> tos, String subject, String content, File ... files) {
        MailKit.send(tos, subject, content, true, files);
    }

    public static void send(Collection<String> tos, String subject, String content, boolean isHtml, File ... files) {
        MailKit.send(GlobalMailAccount.INSTANCE.getAccount(), tos, subject, content, isHtml, files);
    }

    public static void send(Collection<String> tos, Collection<String> ccs, Collection<String> bccs, String subject, String content, boolean isHtml, File ... files) {
        MailKit.send(GlobalMailAccount.INSTANCE.getAccount(), tos, ccs, bccs, subject, content, isHtml, files);
    }

    public static void send(MailAccount mailAccount, String to, String subject, String content, boolean isHtml, File ... files) {
        MailKit.send(mailAccount, MailKit.splitAddress(to), subject, content, isHtml, files);
    }

    public static void send(MailAccount mailAccount, Collection<String> tos, String subject, String content, boolean isHtml, File ... files) {
        Mail.create(mailAccount).setTos(tos.toArray(new String[tos.size()])).setTitle(subject).setContent(content).setHtml(isHtml).setFiles(files).send();
    }

    public static void send(MailAccount mailAccount, Collection<String> tos, Collection<String> ccs, Collection<String> bccs, String subject, String content, boolean isHtml, File ... files) {
        Mail mail = Mail.create(mailAccount);
        if (CollKit.isNotEmpty(ccs)) {
            mail.setCcs(ccs.toArray(new String[ccs.size()]));
        }
        if (CollKit.isNotEmpty(bccs)) {
            mail.setBccs(bccs.toArray(new String[bccs.size()]));
        }
        mail.setTos(tos.toArray(new String[tos.size()]));
        mail.setTitle(subject);
        mail.setContent(content);
        mail.setHtml(isHtml);
        mail.setFiles(files);
        mail.send();
    }

    private static List<String> splitAddress(String addresses) {
        if (StringKit.isBlank((CharSequence)addresses)) {
            return null;
        }
        List result = StringKit.contains((CharSequence)addresses, (char)',') ? StringKit.splitTrim((CharSequence)addresses, (char)',') : (StringKit.contains((CharSequence)addresses, (char)';') ? StringKit.splitTrim((CharSequence)addresses, (char)';') : CollKit.newArrayList((Object[])new String[]{addresses}));
        return result;
    }
}

