/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.extra.ssh;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.aoju.bus.core.lang.Filter;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.extra.ftp.AbstractFtp;
import org.aoju.bus.extra.ftp.FtpConfig;
import org.aoju.bus.extra.ssh.SshKit;

public class Sftp
extends AbstractFtp {
    private Session session;
    private ChannelSftp channel;

    public Sftp(String sshHost, int sshPort, String sshUser, String sshPass) {
        this(sshHost, sshPort, sshUser, sshPass, DEFAULT_CHARSET);
    }

    public Sftp(String sshHost, int sshPort, String sshUser, String sshPass, Charset charset) {
        this(new FtpConfig(sshHost, sshPort, sshUser, sshPass, charset));
    }

    public Sftp(FtpConfig config) {
        super(config);
        this.init(config);
    }

    public Sftp(Session session) {
        this(session, DEFAULT_CHARSET);
    }

    public Sftp(Session session, Charset charset) {
        super(FtpConfig.create().setCharset(charset));
        this.init(session, charset);
    }

    public Sftp(ChannelSftp channel, Charset charset) {
        super(FtpConfig.create().setCharset(charset));
        this.init(channel, charset);
    }

    public void init(String sshHost, int sshPort, String sshUser, String sshPass, Charset charset) {
        this.init(SshKit.getSession(sshHost, sshPort, sshUser, sshPass), charset);
    }

    public void init() {
        this.init(this.ftpConfig);
    }

    public void init(FtpConfig config) {
        this.init(config.getHost(), config.getPort(), config.getUser(), config.getPassword(), config.getCharset());
    }

    public void init(Session session, Charset charset) {
        this.session = session;
        this.init(SshKit.openSftp(session, (int)this.ftpConfig.getConnectionTimeout()), charset);
    }

    public void init(ChannelSftp channel, Charset charset) {
        this.ftpConfig.setCharset(charset);
        try {
            channel.setFilenameEncoding(charset.toString());
        }
        catch (SftpException e) {
            throw new InstrumentException((Throwable)e);
        }
        this.channel = channel;
    }

    @Override
    public Sftp reconnectIfTimeout() {
        if (!this.cd("/") && StringKit.isNotBlank((CharSequence)this.ftpConfig.getHost())) {
            this.init(this.ftpConfig);
        }
        return this;
    }

    public ChannelSftp getClient() {
        return this.channel;
    }

    @Override
    public String pwd() {
        try {
            return this.channel.pwd();
        }
        catch (SftpException e) {
            throw new InstrumentException((Throwable)e);
        }
    }

    public String home() {
        try {
            return this.channel.getHome();
        }
        catch (SftpException e) {
            throw new InstrumentException((Throwable)e);
        }
    }

    @Override
    public List<String> ls(String path) {
        return this.ls(path, null);
    }

    public List<String> lsDirs(String path) {
        return this.ls(path, (Filter<ChannelSftp.LsEntry>)((Filter)t -> t.getAttrs().isDir()));
    }

    public List<String> lsFiles(String path) {
        return this.ls(path, (Filter<ChannelSftp.LsEntry>)((Filter)t -> false == t.getAttrs().isDir()));
    }

    public List<String> ls(String path, Filter<ChannelSftp.LsEntry> filter) {
        ArrayList<String> fileNames;
        block2: {
            fileNames = new ArrayList<String>();
            try {
                this.channel.ls(path, entry -> {
                    String fileName = entry.getFilename();
                    if (!(StringKit.equals((CharSequence)".", (CharSequence)fileName) || StringKit.equals((CharSequence)"..", (CharSequence)fileName) || null != filter && !filter.accept((Object)entry))) {
                        fileNames.add(entry.getFilename());
                    }
                    return 0;
                });
            }
            catch (SftpException e) {
                if (StringKit.startWithIgnoreCase((CharSequence)e.getMessage(), (CharSequence)"No such file")) break block2;
                throw new InstrumentException((Throwable)e);
            }
        }
        return fileNames;
    }

    @Override
    public boolean mkdir(String dir) {
        try {
            this.channel.mkdir(dir);
            return true;
        }
        catch (SftpException e) {
            throw new InstrumentException((Throwable)e);
        }
    }

    @Override
    public boolean cd(String directory) {
        if (StringKit.isBlank((CharSequence)directory)) {
            return true;
        }
        try {
            this.channel.cd(directory.replaceAll("\\\\", "/"));
            return true;
        }
        catch (SftpException e) {
            return false;
        }
    }

    @Override
    public boolean delFile(String filePath) {
        try {
            this.channel.rm(filePath);
        }
        catch (SftpException e) {
            throw new InstrumentException((Throwable)e);
        }
        return true;
    }

    @Override
    public boolean delDir(String dirPath) {
        Vector list;
        if (!this.cd(dirPath)) {
            return false;
        }
        try {
            list = this.channel.ls(this.channel.pwd());
        }
        catch (SftpException e) {
            throw new InstrumentException((Throwable)e);
        }
        for (ChannelSftp.LsEntry entry : list) {
            String fileName = entry.getFilename();
            if (StringKit.equals((CharSequence)fileName, (CharSequence)".") || StringKit.equals((CharSequence)fileName, (CharSequence)"..")) continue;
            if (entry.getAttrs().isDir()) {
                this.delDir(fileName);
                continue;
            }
            this.delFile(fileName);
        }
        if (!this.cd("..")) {
            return false;
        }
        try {
            this.channel.rmdir(dirPath);
            return true;
        }
        catch (SftpException e) {
            throw new InstrumentException((Throwable)e);
        }
    }

    @Override
    public boolean upload(String destPath, File file) {
        this.put(FileKit.getAbsolutePath((File)file), destPath);
        return true;
    }

    public Sftp put(String srcFilePath, String destPath) {
        return this.put(srcFilePath, destPath, Mode.OVERWRITE);
    }

    public Sftp put(String srcFilePath, String destPath, Mode mode) {
        return this.put(srcFilePath, destPath, null, mode);
    }

    public Sftp put(String srcFilePath, String destPath, SftpProgressMonitor monitor, Mode mode) {
        try {
            this.channel.put(srcFilePath, destPath, monitor, mode.ordinal());
        }
        catch (SftpException e) {
            throw new InstrumentException((Throwable)e);
        }
        return this;
    }

    @Override
    public void download(String src, File destFile) {
        this.get(src, FileKit.getAbsolutePath((File)destFile));
    }

    @Override
    public void download(String sourcePath, String destPath) {
        try {
            Vector fileAndFolderList = this.channel.ls(sourcePath);
            for (ChannelSftp.LsEntry item : fileAndFolderList) {
                String sourcePathPathFile = sourcePath + "/" + item.getFilename();
                String destinationPathFile = destPath + "/" + item.getFilename();
                if (!item.getAttrs().isDir()) {
                    if (FileKit.exist((String)destinationPathFile) && (long)item.getAttrs().getMTime() <= FileKit.lastModifiedTime((String)destinationPathFile).getTime() / 1000L) continue;
                    this.channel.get(sourcePathPathFile, destinationPathFile);
                    continue;
                }
                if (".".equals(item.getFilename()) || "..".equals(item.getFilename())) continue;
                FileKit.mkdir((String)destinationPathFile);
                this.download(sourcePathPathFile, destinationPathFile);
            }
        }
        catch (SftpException e) {
            e.printStackTrace();
        }
    }

    public Sftp get(String src, String dest) {
        try {
            this.channel.get(src, dest);
        }
        catch (SftpException e) {
            throw new InstrumentException((Throwable)e);
        }
        return this;
    }

    @Override
    public void close() {
        SshKit.close((Channel)this.channel);
        SshKit.close(this.session);
    }

    public static enum Mode {
        OVERWRITE,
        RESUME,
        APPEND;

    }
}

