/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.extra.json;

import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.aoju.bus.core.instance.Instances;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.extra.json.JsonProvider;
import org.aoju.bus.logger.Logger;

public class JsonFactory {
    public static JsonProvider get() {
        JsonFactory cfr_ignored_0 = (JsonFactory)Instances.singletion(JsonFactory.class);
        return JsonFactory.create();
    }

    public static JsonProvider create() {
        JsonProvider engine = JsonFactory.doCreate(JsonProvider.class);
        Logger.debug((String)"Use [{}] provider as default.", (Object[])new Object[]{StringKit.removeSuffix((CharSequence)engine.getClass().getSimpleName(), (CharSequence)"Provider")});
        return engine;
    }

    public static <T> T doCreate(Class<T> clazz) {
        Iterator<T> iterator = ServiceLoader.load(clazz).iterator();
        if (iterator.hasNext()) {
            try {
                return iterator.next();
            }
            catch (ServiceConfigurationError e) {
                throw new InstrumentException("No json jar found ! Please add one of it to your project !");
            }
        }
        return null;
    }
}

