/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.extra.json.provider;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.aoju.bus.extra.json.provider.AbstractJsonProvider;

public class FastJsonProvider
extends AbstractJsonProvider {
    private static final SerializerFeature[] FEATURES = new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullListAsEmpty, SerializerFeature.WriteNullNumberAsZero, SerializerFeature.WriteNullBooleanAsFalse, SerializerFeature.WriteNullStringAsEmpty};

    @Override
    public String toJsonString(Object object) {
        return JSON.toJSONString((Object)object, (SerializerFeature[])FEATURES);
    }

    @Override
    public String toJsonString(Object object, String format) {
        return JSON.toJSONStringWithDateFormat((Object)object, (String)format, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat});
    }

    @Override
    public <T> T toPojo(String json, Class<T> clazz) {
        return (T)JSON.parseObject((String)json, clazz);
    }

    @Override
    public <T> T toPojo(Map map, Class<T> clazz) {
        return (T)JSON.parseObject((String)JSON.toJSONString((Object)map), clazz);
    }

    @Override
    public List toList(String json) {
        return (List)JSON.parseObject((String)json, LinkedList.class);
    }

    @Override
    public <T> List<T> toList(String json, Class<T> clazz) {
        return JSON.parseArray((String)json, clazz);
    }

    @Override
    public <T> List<T> toList(String json, Type type) {
        TypeReference typeReference = new TypeReference<T>(){

            public Type getType() {
                return this.type;
            }
        };
        return (List)JSON.parseObject((String)json, (Type)typeReference.getType(), (Feature[])new Feature[0]);
    }

    @Override
    public Map toMap(String json) {
        return (Map)JSON.parseObject((String)json, LinkedHashMap.class);
    }

    @Override
    public Map toMap(Object object) {
        return (Map)JSON.parseObject((String)JSON.toJSONString((Object)object), LinkedHashMap.class);
    }

    @Override
    public boolean isJson(String json) {
        try {
            JSON.parseObject((String)json);
        }
        catch (RuntimeException ex) {
            try {
                JSON.parseArray((String)json);
            }
            catch (RuntimeException ex1) {
                return false;
            }
        }
        return true;
    }
}

