/*********************************************************************************
 *                                                                               *
 * The MIT License (MIT)                                                         *
 *                                                                               *
 * Copyright (c) 2015-2020 aoju.org and other contributors.                      *
 *                                                                               *
 * Permission is hereby granted, free of charge, to any person obtaining a copy  *
 * of this software and associated documentation files (the "Software"), to deal *
 * in the Software without restriction, including without limitation the rights  *
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell     *
 * copies of the Software, and to permit persons to whom the Software is         *
 * furnished to do so, subject to the following conditions:                      *
 *                                                                               *
 * The above copyright notice and this permission notice shall be included in    *
 * all copies or substantial portions of the Software.                           *
 *                                                                               *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR    *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,      *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE   *
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER        *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, *
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN     *
 * THE SOFTWARE.                                                                 *
 *                                                                               *
 ********************************************************************************/
package org.aoju.bus.extra.captcha;

import java.io.OutputStream;

/**
 * 验证码接口，提供验证码对象接口定义
 *
 * @author Kimi Liu
 * @version 6.1.5
 * @since JDK 1.8+
 */
public interface CaptchaProvider {

    /**
     * 创建验证码，实现类需同时生成随机验证码字符串和验证码图片
     */
    void create();

    /**
     * 获取验证码的文字内容
     *
     * @return 验证码文字内容
     */
    String get();

    /**
     * 验证验证码是否正确，建议忽略大小写
     *
     * @param inputCode 用户输入的验证码
     * @return 是否与生成的一直
     */
    boolean verify(String inputCode);

    /**
     * 将验证码写出到目标流中
     *
     * @param out 目标流
     */
    void write(OutputStream out);

}
