/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.extra.effect;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.aoju.bus.core.annotation.SPI;
import org.aoju.bus.extra.effect.EffectProvider;

public enum EffectFactory {
    CF;

    Map<String, EffectProvider> compressMap = new HashMap<String, EffectProvider>();

    private EffectFactory() {
        ServiceLoader<EffectProvider> compresses = ServiceLoader.load(EffectProvider.class);
        for (EffectProvider effectProvider : compresses) {
            SPI spi = effectProvider.getClass().getAnnotation(SPI.class);
            if (spi == null) continue;
            String name = spi.value();
            if (this.compressMap.containsKey(name)) {
                throw new RuntimeException("The @SPI value(" + name + ") repeat, for class(" + effectProvider.getClass() + ") and class(" + this.compressMap.get(name).getClass() + ").");
            }
            this.compressMap.put(name, effectProvider);
        }
    }

    public EffectProvider get(String name) {
        return this.compressMap.get(name);
    }
}

