/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.extra.ssh;

import com.jcraft.jsch.Session;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.aoju.bus.core.lang.Func;
import org.aoju.bus.core.lang.SimpleCache;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.extra.ssh.SshKit;

public enum JschSessionPool {
    INSTANCE;

    private final SimpleCache<String, Session> cache = new SimpleCache(new HashMap());

    public Session get(String key) {
        return (Session)this.cache.get((Object)key);
    }

    public Session getSession(String sshHost, int sshPort, String sshUser, String sshPass) {
        String key = StringKit.format((String)"{}@{}:{}", (Object[])new Object[]{sshUser, sshHost, sshPort});
        return (Session)this.cache.get((Object)key, (Func.Func0 & Serializable)() -> SshKit.openSession(sshHost, sshPort, sshUser, sshPass));
    }

    public Session getSession(String sshHost, int sshPort, String sshUser, String prvkey, byte[] passphrase) {
        String key = StringKit.format((String)"{}@{}:{}", (Object[])new Object[]{sshUser, sshHost, sshPort});
        return (Session)this.cache.get((Object)key, (Func.Func0 & Serializable)() -> SshKit.openSession(sshHost, sshPort, sshUser, prvkey, passphrase));
    }

    public void put(String key, Session session) {
        this.cache.put((Object)key, (Object)session);
    }

    public void close(String key) {
        Session session = this.get(key);
        if (null != session && session.isConnected()) {
            session.disconnect();
        }
        this.cache.remove((Object)key);
    }

    public void remove(Session session) {
        if (null != session) {
            Iterator iterator = this.cache.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                if (!session.equals(entry.getValue())) continue;
                iterator.remove();
                break;
            }
        }
    }

    public void closeAll() {
        for (Map.Entry entry : this.cache) {
            Session session = (Session)entry.getValue();
            if (null == session || !session.isConnected()) continue;
            session.disconnect();
        }
        this.cache.clear();
    }
}

