/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.extra.json.provider;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.extra.json.provider.AbstractJsonProvider;

public class JacksonProvider
extends AbstractJsonProvider {
    public static ObjectMapper objectMapper;

    public JacksonProvider() {
        objectMapper = new ObjectMapper().findAndRegisterModules().disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
    }

    @Override
    public String toJsonString(Object object) {
        try {
            return objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toJsonString(Object object, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        try {
            return objectMapper.writer((DateFormat)sdf).writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> T toPojo(String json, Class<T> valueType) {
        try {
            return (T)objectMapper.readValue(json, valueType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> T toPojo(Map fromMap, Class<T> clazz) {
        return (T)objectMapper.convertValue((Object)fromMap, clazz);
    }

    @Override
    public <T> List<T> toList(String json) {
        try {
            return (List)objectMapper.readValue(json, LinkedList.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> List<T> toList(String json, Class<T> clazz) {
        try {
            return (List)objectMapper.readValue(json, clazz);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> List<T> toList(String json, final Type type) {
        TypeReference typeReference = new TypeReference<List<T>>(){

            public Type getType() {
                return type;
            }
        };
        try {
            return (List)objectMapper.readValue(json, typeReference);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <K, V> Map<K, V> toMap(String json) {
        try {
            return (Map)objectMapper.readValue(json, Map.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <K, V> Map<K, V> toMap(Object object) {
        return (Map)objectMapper.convertValue(object, Map.class);
    }

    @Override
    public <T> T getValue(String json, String field) {
        try {
            return (T)objectMapper.readTree(json).get(field);
        }
        catch (JsonProcessingException e) {
            throw new InstrumentException((Throwable)e);
        }
    }

    @Override
    public boolean isJson(String json) {
        try {
            objectMapper.readTree(json);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }
}

