/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.extra.ssh;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.NetKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.extra.ssh.ChannelType;
import org.aoju.bus.extra.ssh.Connector;
import org.aoju.bus.extra.ssh.JSchSessionPool;
import org.aoju.bus.extra.ssh.Sftp;

public class JSchKit {
    public static final String SSH_NONE = "none";
    private static final AtomicInteger port = new AtomicInteger(10000);

    public static int generateLocalPort() {
        int validPort = port.get();
        while (!NetKit.isUsableLocalPort((int)validPort)) {
            validPort = port.incrementAndGet();
        }
        return validPort;
    }

    public static Session getSession(String sshHost, int sshPort, String sshUser, String sshPass) {
        return JSchSessionPool.INSTANCE.getSession(sshHost, sshPort, sshUser, sshPass);
    }

    public static Session getSession(String sshHost, int sshPort, String sshUser, String privateKeyPath, byte[] passphrase) {
        return JSchSessionPool.INSTANCE.getSession(sshHost, sshPort, sshUser, privateKeyPath, passphrase);
    }

    public static Session openSession(String sshHost, int sshPort, String sshUser, String sshPass) {
        return JSchKit.openSession(sshHost, sshPort, sshUser, sshPass, 0);
    }

    public static Session openSession(String sshHost, int sshPort, String sshUser, String sshPass, int timeout) {
        Session session = JSchKit.createSession(sshHost, sshPort, sshUser, sshPass);
        try {
            session.connect(timeout);
        }
        catch (JSchException e) {
            throw new InstrumentException((Throwable)e);
        }
        return session;
    }

    public static Session openSession(String sshHost, int sshPort, String sshUser, String privateKeyPath, byte[] passphrase) {
        Session session = JSchKit.createSession(sshHost, sshPort, sshUser, privateKeyPath, passphrase);
        try {
            session.connect();
        }
        catch (JSchException e) {
            throw new InstrumentException((Throwable)e);
        }
        return session;
    }

    public static Session createSession(String sshHost, int sshPort, String sshUser, String sshPass) {
        JSch jsch = new JSch();
        Session session = JSchKit.createSession(jsch, sshHost, sshPort, sshUser);
        if (StringKit.isNotEmpty((CharSequence)sshPass)) {
            session.setPassword(sshPass);
        }
        return session;
    }

    public static Session createSession(String sshHost, int sshPort, String sshUser, String privateKeyPath, byte[] passphrase) {
        Assert.notEmpty((CharSequence)privateKeyPath, (String)"PrivateKey Path must be not empty!", (Object[])new Object[0]);
        JSch jsch = new JSch();
        try {
            jsch.addIdentity(privateKeyPath, passphrase);
        }
        catch (JSchException e) {
            throw new InstrumentException((Throwable)e);
        }
        return JSchKit.createSession(jsch, sshHost, sshPort, sshUser);
    }

    public static Session createSession(JSch jsch, String sshHost, int sshPort, String sshUser) {
        Session session;
        Assert.notEmpty((CharSequence)sshHost, (String)"SSH Host must be not empty!", (Object[])new Object[0]);
        Assert.isTrue((sshPort > 0 ? 1 : 0) != 0, (String)"SSH port must be > 0", (Object[])new Object[0]);
        if (StringKit.isEmpty((CharSequence)sshUser)) {
            sshUser = "root";
        }
        if (null == jsch) {
            jsch = new JSch();
        }
        try {
            session = jsch.getSession(sshUser, sshHost, sshPort);
        }
        catch (JSchException e) {
            throw new InstrumentException((Throwable)e);
        }
        session.setConfig("StrictHostKeyChecking", "no");
        return session;
    }

    public static boolean bindPort(Session session, String remoteHost, int remotePort, int localPort) throws InstrumentException {
        return JSchKit.bindPort(session, remoteHost, remotePort, "127.0.0.1", localPort);
    }

    public static boolean bindPort(Session session, String remoteHost, int remotePort, String localHost, int localPort) throws InstrumentException {
        if (session != null && session.isConnected()) {
            try {
                session.setPortForwardingL(localHost, localPort, remoteHost, remotePort);
            }
            catch (JSchException e) {
                throw new InstrumentException("From [{}:{}] mapping to [{}:{}] error \uff01", new Object[]{remoteHost, remotePort, localHost, localPort});
            }
            return true;
        }
        return false;
    }

    public static boolean bindPort(Session session, int bindPort, String host, int port) throws InstrumentException {
        if (null != session && session.isConnected()) {
            try {
                session.setPortForwardingR(bindPort, host, port);
            }
            catch (JSchException e) {
                throw new InstrumentException("From [{}] mapping to [{}] error\uff01", new Object[]{bindPort, port});
            }
            return true;
        }
        return false;
    }

    public static boolean unBindPort(Session session, int localPort) {
        try {
            session.delPortForwardingL(localPort);
            return true;
        }
        catch (JSchException e) {
            throw new InstrumentException((Throwable)e);
        }
    }

    public static int openAndBindPortToLocal(Connector sshConn, String remoteHost, int remotePort) throws InstrumentException {
        Session session = JSchKit.openSession(sshConn.getHost(), sshConn.getPort(), sshConn.getUser(), sshConn.getPassword());
        if (null == session) {
            throw new InstrumentException("Error to create SSH Session\uff01");
        }
        int localPort = JSchKit.generateLocalPort();
        JSchKit.bindPort(session, remoteHost, remotePort, localPort);
        return localPort;
    }

    public static ChannelSftp openSftp(Session session) {
        return JSchKit.openSftp(session, 0);
    }

    public static ChannelSftp openSftp(Session session, int timeout) {
        return (ChannelSftp)JSchKit.openChannel(session, ChannelType.SFTP, timeout);
    }

    public static ChannelShell openShell(Session session) {
        return (ChannelShell)JSchKit.openChannel(session, ChannelType.SHELL);
    }

    public static Channel openChannel(Session session, ChannelType channelType) {
        Channel channel = JSchKit.createChannel(session, channelType);
        try {
            channel.connect();
        }
        catch (JSchException e) {
            throw new InstrumentException((Throwable)e);
        }
        return channel;
    }

    public static Channel openChannel(Session session, ChannelType channelType, int timeout) {
        Channel channel = JSchKit.createChannel(session, channelType);
        try {
            channel.connect(Math.max(timeout, 0));
        }
        catch (JSchException e) {
            throw new InstrumentException((Throwable)e);
        }
        return channel;
    }

    public static Sftp createSftp(String sshHost, int sshPort, String sshUser, String sshPass) {
        return new Sftp(sshHost, sshPort, sshUser, sshPass);
    }

    public static Sftp createSftp(Session session) {
        return new Sftp(session);
    }

    public static Channel createChannel(Session session, ChannelType channelType) {
        Channel channel;
        try {
            if (!session.isConnected()) {
                session.connect();
            }
            channel = session.openChannel(channelType.getValue());
        }
        catch (JSchException e) {
            throw new InstrumentException((Throwable)e);
        }
        return channel;
    }

    public static String exec(Session session, String cmd, java.nio.charset.Charset charset) {
        return JSchKit.exec(session, cmd, charset, System.err);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String exec(Session session, String cmd, java.nio.charset.Charset charset, OutputStream errStream) {
        String string;
        if (null == charset) {
            charset = Charset.UTF_8;
        }
        ChannelExec channel = (ChannelExec)JSchKit.openChannel(session, ChannelType.EXEC);
        channel.setCommand(StringKit.bytes((CharSequence)cmd, (java.nio.charset.Charset)charset));
        channel.setInputStream(null);
        channel.setErrStream(errStream);
        InputStream in = null;
        try {
            channel.start();
            in = channel.getInputStream();
            string = IoKit.read((InputStream)in, (java.nio.charset.Charset)charset);
        }
        catch (IOException e) {
            try {
                throw new InstrumentException((Throwable)e);
                catch (JSchException e2) {
                    throw new InstrumentException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                IoKit.close(in);
                JSchKit.close((Channel)channel);
                throw throwable;
            }
        }
        IoKit.close((Closeable)in);
        JSchKit.close((Channel)channel);
        return string;
    }

    public static String execByShell(Session session, String cmd, java.nio.charset.Charset charset) {
        ChannelShell shell = JSchKit.openShell(session);
        shell.setPty(true);
        OutputStream out = null;
        InputStream in = null;
        try {
            out = shell.getOutputStream();
            in = shell.getInputStream();
            out.write(StringKit.bytes((CharSequence)cmd, (java.nio.charset.Charset)charset));
            out.flush();
            String string = IoKit.read((InputStream)in, (java.nio.charset.Charset)charset);
            return string;
        }
        catch (IOException e) {
            throw new InstrumentException((Throwable)e);
        }
        finally {
            IoKit.close((Closeable)out);
            IoKit.close((Closeable)in);
            JSchKit.close((Channel)shell);
        }
    }

    public static void close(Session session) {
        if (null != session && session.isConnected()) {
            session.disconnect();
        }
        JSchSessionPool.INSTANCE.remove(session);
    }

    public static void close(Channel channel) {
        if (null != channel && channel.isConnected()) {
            channel.disconnect();
        }
    }

    public static void close(String key) {
        JSchSessionPool.INSTANCE.close(key);
    }

    public static void closeAll() {
        JSchSessionPool.INSTANCE.closeAll();
    }
}

