/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.extra.ftp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.lang.Filter;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.extra.ftp.AbstractFtp;
import org.aoju.bus.extra.ftp.FtpConfig;
import org.aoju.bus.extra.ftp.FtpMode;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;

public class Ftp
extends AbstractFtp {
    public static final int DEFAULT_PORT = 21;
    private FTPClient client;
    private FtpMode mode;
    private boolean backToPwd;

    public Ftp(String host) {
        this(host, 21);
    }

    public Ftp(String host, int port) {
        this(host, port, "anonymous", "");
    }

    public Ftp(String host, int port, String user, String password) {
        this(host, port, user, password, Charset.UTF_8);
    }

    public Ftp(String host, int port, String user, String password, java.nio.charset.Charset charset) {
        this(host, port, user, password, charset, null, null);
    }

    public Ftp(String host, int port, String user, String password, java.nio.charset.Charset charset, String serverLanguageCode, String systemKey) {
        this(host, port, user, password, charset, serverLanguageCode, systemKey, null);
    }

    public Ftp(String host, int port, String user, String password, java.nio.charset.Charset charset, String serverLanguageCode, String systemKey, FtpMode mode) {
        this(new FtpConfig(host, port, user, password, charset, serverLanguageCode, systemKey), mode);
    }

    public Ftp(FtpConfig config, FtpMode mode) {
        super(config);
        this.mode = mode;
        this.init();
    }

    public Ftp(FTPClient client) {
        super(FtpConfig.create());
        this.client = client;
    }

    public Ftp init() {
        return this.init(this.ftpConfig, this.mode);
    }

    public Ftp init(String host, int port, String user, String password) {
        return this.init(host, port, user, password, null);
    }

    public Ftp init(String host, int port, String user, String password, FtpMode mode) {
        return this.init(new FtpConfig(host, port, user, password, this.ftpConfig.getCharset(), null, null), mode);
    }

    public Ftp init(FtpConfig config, FtpMode mode) {
        FTPClient client = new FTPClient();
        java.nio.charset.Charset charset = config.getCharset();
        if (null != charset) {
            client.setControlEncoding(charset.toString());
        }
        client.setConnectTimeout((int)config.getConnectionTimeout());
        String systemKey = config.getSystemKey();
        if (StringKit.isNotBlank((CharSequence)systemKey)) {
            FTPClientConfig conf = new FTPClientConfig(systemKey);
            String serverLanguageCode = config.getServerLanguageCode();
            if (StringKit.isNotBlank((CharSequence)serverLanguageCode)) {
                conf.setServerLanguageCode(config.getServerLanguageCode());
            }
            client.configure(conf);
        }
        try {
            client.connect(config.getHost(), config.getPort());
            client.setSoTimeout((int)config.getSoTimeout());
            client.login(config.getUser(), config.getPassword());
        }
        catch (IOException e) {
            throw new InstrumentException((Throwable)e);
        }
        int replyCode = client.getReplyCode();
        if (!FTPReply.isPositiveCompletion((int)replyCode)) {
            try {
                client.disconnect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new InstrumentException("Login failed for user [{}], reply code is: [{}]", new Object[]{config.getUser(), replyCode});
        }
        this.client = client;
        if (null != mode) {
            this.setMode(mode);
        }
        return this;
    }

    public Ftp setMode(FtpMode mode) {
        this.mode = mode;
        switch (mode) {
            case Active: {
                this.client.enterLocalActiveMode();
                break;
            }
            case Passive: {
                this.client.enterLocalPassiveMode();
            }
        }
        return this;
    }

    public boolean isBackToPwd() {
        return this.backToPwd;
    }

    public Ftp setBackToPwd(boolean backToPwd) {
        this.backToPwd = backToPwd;
        return this;
    }

    @Override
    public Ftp reconnectIfTimeout() {
        String pwd = null;
        try {
            pwd = this.pwd();
        }
        catch (InstrumentException instrumentException) {
            // empty catch block
        }
        if (null == pwd) {
            return this.init();
        }
        return this;
    }

    @Override
    public synchronized boolean cd(String directory) {
        if (StringKit.isBlank((CharSequence)directory)) {
            return true;
        }
        try {
            return this.client.changeWorkingDirectory(directory);
        }
        catch (IOException e) {
            throw new InstrumentException((Throwable)e);
        }
    }

    @Override
    public String pwd() {
        try {
            return this.client.printWorkingDirectory();
        }
        catch (IOException e) {
            throw new InstrumentException((Throwable)e);
        }
    }

    @Override
    public List<String> ls(String path) {
        return ArrayKit.map((Object[])this.lsFiles(path), FTPFile::getName);
    }

    public List<FTPFile> lsFiles(String path, Filter<FTPFile> filter) {
        Object[] ftpFiles = this.lsFiles(path);
        if (ArrayKit.isEmpty((Object[])ftpFiles)) {
            return new ArrayList<FTPFile>();
        }
        ArrayList<FTPFile> result = new ArrayList<FTPFile>(ftpFiles.length - 2 <= 0 ? ftpFiles.length : ftpFiles.length - 2);
        for (Object ftpFile : ftpFiles) {
            String fileName = ftpFile.getName();
            if (StringKit.equals((CharSequence)".", (CharSequence)fileName) || StringKit.equals((CharSequence)"..", (CharSequence)fileName) || null != filter && !filter.accept(ftpFile)) continue;
            result.add((FTPFile)ftpFile);
        }
        return result;
    }

    public FTPFile[] lsFiles(String path) throws InstrumentException {
        FTPFile[] ftpFiles;
        String pwd = null;
        if (StringKit.isNotBlank((CharSequence)path)) {
            pwd = this.pwd();
            if (!this.isDir(path)) {
                throw new InstrumentException("Change dir to [{}] error, maybe path not exist!", path);
            }
        }
        try {
            ftpFiles = this.client.listFiles();
        }
        catch (IOException e) {
            throw new InstrumentException((Throwable)e);
        }
        finally {
            this.cd(pwd);
        }
        return ftpFiles;
    }

    @Override
    public boolean mkdir(String dir) {
        try {
            return this.client.makeDirectory(dir);
        }
        catch (IOException e) {
            throw new InstrumentException((Throwable)e);
        }
    }

    public boolean existFile(String path) {
        Object[] ftpFileArr;
        try {
            ftpFileArr = this.client.listFiles(path);
        }
        catch (IOException e) {
            throw new InstrumentException((Throwable)e);
        }
        return ArrayKit.isNotEmpty((Object[])ftpFileArr);
    }

    public int stat(String path) {
        try {
            return this.client.stat(path);
        }
        catch (IOException e) {
            throw new InstrumentException((Throwable)e);
        }
    }

    @Override
    public boolean delFile(String path) {
        boolean isSuccess;
        String pwd = this.pwd();
        String fileName = FileKit.getName((String)path);
        String dir = StringKit.removeSuffix((CharSequence)path, (CharSequence)fileName);
        if (!this.cd(dir)) {
            throw new InstrumentException("Change dir to [{}] error, maybe dir not exist!");
        }
        try {
            isSuccess = this.client.deleteFile(fileName);
        }
        catch (IOException e) {
            throw new InstrumentException((Throwable)e);
        }
        finally {
            this.cd(pwd);
        }
        return isSuccess;
    }

    @Override
    public boolean delDir(String dirPath) {
        FTPFile[] dirs;
        try {
            dirs = this.client.listFiles(dirPath);
        }
        catch (IOException e) {
            throw new InstrumentException((Throwable)e);
        }
        for (FTPFile ftpFile : dirs) {
            String name = ftpFile.getName();
            String childPath = StringKit.format((CharSequence)"{}/{}", (Object[])new Object[]{dirPath, name});
            if (ftpFile.isDirectory()) {
                if (ObjectKit.equal((Object)name, (Object)".") || ObjectKit.equal((Object)name, (Object)"..")) continue;
                this.delDir(childPath);
                continue;
            }
            this.delFile(childPath);
        }
        try {
            return this.client.removeDirectory(dirPath);
        }
        catch (IOException e) {
            throw new InstrumentException((Throwable)e);
        }
    }

    @Override
    public boolean upload(String dest, File file) {
        Assert.notNull((Object)file, (String)"file to upload is null !", (Object[])new Object[0]);
        return this.upload(dest, file.getName(), file);
    }

    public boolean upload(String dest, String fileName, File file) {
        boolean bl;
        block8: {
            BufferedInputStream in = FileKit.getInputStream((File)file);
            try {
                bl = this.upload(dest, fileName, in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new InstrumentException((Throwable)e);
                }
            }
            ((InputStream)in).close();
        }
        return bl;
    }

    public boolean upload(String dest, String fileName, InputStream fileStream) {
        try {
            this.client.setFileType(2);
        }
        catch (IOException e) {
            throw new InstrumentException((Throwable)e);
        }
        String pwd = null;
        if (this.backToPwd) {
            pwd = this.pwd();
        }
        if (StringKit.isNotBlank((CharSequence)dest)) {
            this.mkDirs(dest);
            if (!this.cd(dest)) {
                throw new InstrumentException("Change dir to [{}] error, maybe dir not exist!");
            }
        }
        try {
            boolean bl = this.client.storeFile(fileName, fileStream);
            return bl;
        }
        catch (IOException e) {
            throw new InstrumentException((Throwable)e);
        }
        finally {
            if (this.backToPwd) {
                this.cd(pwd);
            }
        }
    }

    @Override
    public void download(String path, File outFile) {
        String fileName = FileKit.getName((String)path);
        String dir = StringKit.removeSuffix((CharSequence)path, (CharSequence)fileName);
        this.download(dir, fileName, outFile);
    }

    public void download(String path, String fileName, File outFile) {
        if (outFile.isDirectory()) {
            outFile = new File(outFile, fileName);
        }
        if (!outFile.exists()) {
            FileKit.touch((File)outFile);
        }
        try (BufferedOutputStream out = FileKit.getOutputStream((File)outFile);){
            this.download(path, fileName, out);
        }
        catch (IOException e) {
            throw new InstrumentException((Throwable)e);
        }
    }

    public void download(String path, String fileName, OutputStream out) {
        this.download(path, fileName, out, null);
    }

    public void download(String path, String fileName, OutputStream out, java.nio.charset.Charset charset) {
        String pwd = null;
        if (this.backToPwd) {
            pwd = this.pwd();
        }
        if (!this.cd(path)) {
            throw new InstrumentException("Change dir to [{}] error, maybe dir not exist!");
        }
        if (null != charset) {
            fileName = new String(fileName.getBytes(charset), StandardCharsets.ISO_8859_1);
        }
        try {
            this.client.setFileType(2);
            this.client.retrieveFile(fileName, out);
        }
        catch (IOException e) {
            throw new InstrumentException((Throwable)e);
        }
        finally {
            if (this.backToPwd) {
                this.cd(pwd);
            }
        }
    }

    @Override
    public void download(String sourcePath, String desPath) {
        FTPFile[] lsFiles;
        for (FTPFile ftpFile : lsFiles = this.lsFiles(sourcePath)) {
            String sourcePathPathFile = sourcePath + "/" + ftpFile.getName();
            String destinationPathFile = desPath + "/" + ftpFile.getName();
            if (!ftpFile.isDirectory()) {
                if (FileKit.exists((String)destinationPathFile) && ftpFile.getTimestamp().getTimeInMillis() <= FileKit.lastModifiedTime((String)destinationPathFile).getTime()) continue;
                this.download(sourcePathPathFile, FileKit.file((String)destinationPathFile));
                continue;
            }
            if (".".equals(ftpFile.getName()) || "..".equals(ftpFile.getName())) continue;
            FileKit.mkdir((String)destinationPathFile);
            this.download(sourcePathPathFile, destinationPathFile);
        }
    }

    public FTPClient getClient() {
        return this.client;
    }

    @Override
    public void close() throws IOException {
        if (null != this.client) {
            this.client.logout();
            if (this.client.isConnected()) {
                this.client.disconnect();
            }
            this.client = null;
        }
    }
}

