/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.extra.qrcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.GlobalHistogramBinarizer;
import com.google.zxing.common.HybridBinarizer;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.aoju.bus.core.exception.InstrumentException;
import org.aoju.bus.core.image.Images;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.toolkit.ImageKit;
import org.aoju.bus.extra.qrcode.LuminanceSource;
import org.aoju.bus.extra.qrcode.QrConfig;

public class QrCodeKit {
    public static String generate(String content, QrConfig qrConfig, String imageType, String logoBase64) {
        byte[] decode;
        try {
            decode = Base64.getDecoder().decode(logoBase64);
        }
        catch (Exception e) {
            throw new InstrumentException((Throwable)e);
        }
        return QrCodeKit.generate(content, qrConfig, imageType, decode);
    }

    public static String generate(String content, QrConfig qrConfig, String imageType, byte[] logo) {
        BufferedImage img;
        try {
            img = ImageIO.read(new ByteArrayInputStream(logo));
        }
        catch (IOException e) {
            throw new InstrumentException((Throwable)e);
        }
        qrConfig.setImg(img);
        return QrCodeKit.generate(content, qrConfig, imageType);
    }

    public static String generate(String content, QrConfig qrConfig, String imageType) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        QrCodeKit.generate(content, qrConfig, imageType, bos);
        byte[] encode = Base64.getEncoder().encode(bos.toByteArray());
        return MessageFormat.format("data:image/{0};base64,{1}", imageType, new String(encode));
    }

    public static byte[] generatePng(String content, int width, int height) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        QrCodeKit.generate(content, width, height, "png", out);
        return out.toByteArray();
    }

    public static byte[] generatePng(String content, QrConfig config) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        QrCodeKit.generate(content, config, "png", out);
        return out.toByteArray();
    }

    public static File generate(String content, int width, int height, File targetFile) {
        BufferedImage image = QrCodeKit.generate(content, width, height);
        ImageKit.write((Image)image, (File)targetFile);
        return targetFile;
    }

    public static File generate(String content, QrConfig config, File targetFile) {
        BufferedImage image = QrCodeKit.generate(content, config);
        ImageKit.write((Image)image, (File)targetFile);
        return targetFile;
    }

    public static void generate(String content, int width, int height, String imageType, OutputStream out) {
        BufferedImage image = QrCodeKit.generate(content, width, height);
        ImageKit.write((Image)image, (String)imageType, (OutputStream)out);
    }

    public static void generate(String content, QrConfig config, String imageType, OutputStream out) {
        BufferedImage image = QrCodeKit.generate(content, config);
        ImageKit.write((Image)image, (String)imageType, (OutputStream)out);
    }

    public static BufferedImage generate(String content, int width, int height) {
        return QrCodeKit.generate(content, new QrConfig(width, height));
    }

    public static BufferedImage generate(String content, BarcodeFormat format, int width, int height) {
        return QrCodeKit.generate(content, format, new QrConfig(width, height));
    }

    public static BufferedImage generate(String content, QrConfig config) {
        return QrCodeKit.generate(content, BarcodeFormat.QR_CODE, config);
    }

    public static BufferedImage generate(String content, BarcodeFormat format, QrConfig config) {
        BitMatrix bitMatrix = QrCodeKit.encode(content, format, config);
        BufferedImage image = QrCodeKit.toImage(bitMatrix, config.foreColor, config.backColor);
        Image logoImage = config.img;
        if (null != logoImage && BarcodeFormat.QR_CODE == format) {
            int height;
            int width;
            int qrHeight;
            int qrWidth = image.getWidth();
            if (qrWidth < (qrHeight = image.getHeight())) {
                width = qrWidth / config.ratio;
                height = logoImage.getHeight(null) * width / logoImage.getWidth(null);
            } else {
                height = qrHeight / config.ratio;
                width = logoImage.getWidth(null) * height / logoImage.getHeight(null);
            }
            Images.from((Image)image).pressImage(Images.from((Image)logoImage).round(0.3).getImg(), new Rectangle(width, height), 1.0f);
        }
        return image;
    }

    public static BitMatrix encode(String content, int width, int height) {
        return QrCodeKit.encode(content, BarcodeFormat.QR_CODE, width, height);
    }

    public static BitMatrix encode(String content, QrConfig config) {
        return QrCodeKit.encode(content, BarcodeFormat.QR_CODE, config);
    }

    public static BitMatrix encode(String content, BarcodeFormat format, int width, int height) {
        return QrCodeKit.encode(content, format, new QrConfig(width, height));
    }

    public static BitMatrix encode(String content, BarcodeFormat format, QrConfig config) {
        BitMatrix bitMatrix;
        MultiFormatWriter multiFormatWriter = new MultiFormatWriter();
        if (null == config) {
            config = new QrConfig();
        }
        try {
            bitMatrix = multiFormatWriter.encode(content, format, config.width, config.height, config.toHints(format));
        }
        catch (WriterException e) {
            throw new InstrumentException((Throwable)e);
        }
        return bitMatrix;
    }

    public static String decode(InputStream qrCodeInputstream) {
        return QrCodeKit.decode(ImageKit.read((InputStream)qrCodeInputstream));
    }

    public static String decode(File qrCodeFile) {
        return QrCodeKit.decode(ImageKit.read((File)qrCodeFile));
    }

    public static String decode(Image image) {
        return QrCodeKit.decode(image, true, false);
    }

    public static String decode(Image image, boolean isTryHarder, boolean isPureBarcode) {
        return QrCodeKit.decode(image, QrCodeKit.buildHints(isTryHarder, isPureBarcode));
    }

    public static String decode(Image image, Map<DecodeHintType, Object> hints) {
        MultiFormatReader formatReader = new MultiFormatReader();
        formatReader.setHints(hints);
        LuminanceSource source = new LuminanceSource(ImageKit.toBufferedImage((Image)image));
        Result result = QrCodeKit._decode(formatReader, (Binarizer)new HybridBinarizer((com.google.zxing.LuminanceSource)source));
        if (null == result) {
            result = QrCodeKit._decode(formatReader, (Binarizer)new GlobalHistogramBinarizer((com.google.zxing.LuminanceSource)source));
        }
        return null != result ? result.getText() : null;
    }

    public static BufferedImage toImage(BitMatrix matrix, int foreColor, Integer backColor) {
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, null == backColor ? 2 : 1);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                if (matrix.get(x, y)) {
                    image.setRGB(x, y, foreColor);
                    continue;
                }
                if (null == backColor) continue;
                image.setRGB(x, y, backColor);
            }
        }
        return image;
    }

    private static Map<DecodeHintType, Object> buildHints(boolean isTryHarder, boolean isPureBarcode) {
        HashMap<DecodeHintType, Object> hints = new HashMap<DecodeHintType, Object>();
        hints.put(DecodeHintType.CHARACTER_SET, Charset.UTF_8);
        if (isTryHarder) {
            hints.put(DecodeHintType.TRY_HARDER, true);
        }
        if (isPureBarcode) {
            hints.put(DecodeHintType.PURE_BARCODE, true);
        }
        return hints;
    }

    private static Result _decode(MultiFormatReader formatReader, Binarizer binarizer) {
        try {
            return formatReader.decodeWithState(new BinaryBitmap(binarizer));
        }
        catch (NotFoundException e) {
            return null;
        }
    }
}

