/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.extra.qrcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.datamatrix.encoder.SymbolShapeHint;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.Color;
import java.awt.Image;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.ImageKit;

public class QrConfig {
    private static final int BLACK = -16777216;
    private static final int WHITE = -1;
    public int width;
    public int height;
    public int foreColor = -16777216;
    public Integer backColor = -1;
    public Integer margin = 2;
    public ErrorCorrectionLevel errorCorrection = ErrorCorrectionLevel.M;
    public java.nio.charset.Charset charset = Charset.UTF_8;
    public Image img;
    public int ratio = 6;
    protected Integer qrVersion;
    protected SymbolShapeHint shapeHint = SymbolShapeHint.FORCE_NONE;

    public QrConfig() {
        this(300, 300);
    }

    public QrConfig(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public static QrConfig create() {
        return new QrConfig();
    }

    public int getWidth() {
        return this.width;
    }

    public QrConfig setWidth(int width) {
        this.width = width;
        return this;
    }

    public int getHeight() {
        return this.height;
    }

    public QrConfig setHeight(int height) {
        this.height = height;
        return this;
    }

    public int getForeColor() {
        return this.foreColor;
    }

    public QrConfig setForeColor(Color foreColor) {
        if (null != foreColor) {
            this.foreColor = foreColor.getRGB();
        }
        return this;
    }

    public int getBackColor() {
        return this.backColor;
    }

    public QrConfig setBackColor(Color backColor) {
        this.backColor = null == backColor ? null : Integer.valueOf(backColor.getRGB());
        return this;
    }

    public Integer getMargin() {
        return this.margin;
    }

    public QrConfig setMargin(Integer margin) {
        this.margin = margin;
        return this;
    }

    public ErrorCorrectionLevel getErrorCorrection() {
        return this.errorCorrection;
    }

    public QrConfig setErrorCorrection(ErrorCorrectionLevel errorCorrection) {
        this.errorCorrection = errorCorrection;
        return this;
    }

    public java.nio.charset.Charset getCharset() {
        return this.charset;
    }

    public QrConfig setCharset(java.nio.charset.Charset charset) {
        this.charset = charset;
        return this;
    }

    public Image getImg() {
        return this.img;
    }

    public QrConfig setImg(String imgPath) {
        return this.setImg(FileKit.file((String)imgPath));
    }

    public QrConfig setImg(File imgFile) {
        return this.setImg(ImageKit.read((File)imgFile));
    }

    public QrConfig setImg(Image img) {
        this.img = img;
        return this;
    }

    public int getRatio() {
        return this.ratio;
    }

    public QrConfig setRatio(int ratio) {
        this.ratio = ratio;
        return this;
    }

    public QrConfig setShapeHint(SymbolShapeHint shapeHint) {
        this.shapeHint = shapeHint;
        return this;
    }

    public Integer getQrVersion() {
        return this.qrVersion;
    }

    public QrConfig setQrVersion(Integer qrVersion) {
        this.qrVersion = qrVersion;
        return this;
    }

    public Map<EncodeHintType, Object> toHints() {
        return this.toHints(BarcodeFormat.QR_CODE);
    }

    public HashMap<EncodeHintType, Object> toHints(BarcodeFormat format) {
        HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
        if (null != this.charset) {
            hints.put(EncodeHintType.CHARACTER_SET, this.charset.toString().toLowerCase());
        }
        if (null != this.errorCorrection) {
            Integer value = BarcodeFormat.AZTEC == format || BarcodeFormat.PDF_417 == format ? Integer.valueOf(this.errorCorrection.getBits()) : this.errorCorrection;
            hints.put(EncodeHintType.ERROR_CORRECTION, value);
            hints.put(EncodeHintType.DATA_MATRIX_SHAPE, this.shapeHint);
        }
        if (null != this.margin) {
            hints.put(EncodeHintType.MARGIN, this.margin);
        }
        if (null != this.qrVersion) {
            hints.put(EncodeHintType.QR_VERSION, this.qrVersion);
        }
        return hints;
    }
}

