/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.extra.servlet;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aoju.bus.core.beans.copier.CopyOptions;
import org.aoju.bus.core.beans.copier.ValueProvider;
import org.aoju.bus.core.collection.ArrayIterator;
import org.aoju.bus.core.exception.InstrumentException;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.map.CaseInsensitiveMap;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.BeanKit;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.IterKit;
import org.aoju.bus.core.toolkit.MapKit;
import org.aoju.bus.core.toolkit.NetKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.ReflectKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.core.toolkit.UriKit;

public class ServletKit {
    public static Map<String, String[]> getParams(ServletRequest request) {
        Map map = request.getParameterMap();
        return Collections.unmodifiableMap(map);
    }

    public static Map<String, String> getParamMap(ServletRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        for (Map.Entry<String, String[]> entry : ServletKit.getParams(request).entrySet()) {
            params.put(entry.getKey(), ArrayKit.join((Object[])entry.getValue(), (CharSequence)","));
        }
        return params;
    }

    public static String getBody(ServletRequest request) {
        String string;
        block8: {
            BufferedReader reader = request.getReader();
            try {
                string = IoKit.read((Reader)reader);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new InstrumentException((Throwable)e);
                }
            }
            reader.close();
        }
        return string;
    }

    public static byte[] getBodyBytes(ServletRequest request) {
        try {
            return IoKit.readBytes((InputStream)request.getInputStream());
        }
        catch (IOException e) {
            throw new InstrumentException((Throwable)e);
        }
    }

    public static <T> T fillBean(final ServletRequest request, T bean, CopyOptions copyOptions) {
        final String beanName = StringKit.lowerFirst((CharSequence)bean.getClass().getSimpleName());
        return (T)BeanKit.fillBean(bean, (ValueProvider)new ValueProvider<String>(){

            public Object value(String key, Type valueType) {
                Object[] values = request.getParameterValues(key);
                if (ArrayKit.isEmpty((Object[])values) && ArrayKit.isEmpty((Object[])(values = request.getParameterValues(beanName + "." + key)))) {
                    return null;
                }
                if (1 == values.length) {
                    return values[0];
                }
                return values;
            }

            public boolean containsKey(String key) {
                return null != request.getParameter(key) || null != request.getParameter(beanName + "." + key);
            }
        }, (CopyOptions)copyOptions);
    }

    public static <T> T fillBean(ServletRequest request, T bean, boolean isIgnoreError) {
        return ServletKit.fillBean(request, bean, CopyOptions.create().setIgnoreError(isIgnoreError));
    }

    public static <T> T toBean(ServletRequest request, Class<T> beanClass, boolean isIgnoreError) {
        return (T)ServletKit.fillBean(request, ReflectKit.newInstanceIfPossible(beanClass), isIgnoreError);
    }

    public static String getClientIP(HttpServletRequest request, String ... headerNames) {
        String[] headers = new String[]{"X-Forwarded-For", "X-Real-IP", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR"};
        if (ArrayKit.isNotEmpty((Object[])headerNames)) {
            headers = (String[])ArrayKit.addAll((Object[][])new String[][]{headers, headerNames});
        }
        return ServletKit.getClientIPByHeader(request, headers);
    }

    public static String getClientIPByHeader(HttpServletRequest request, String ... headerNames) {
        String ip;
        for (String header : headerNames) {
            ip = request.getHeader(header);
            if (NetKit.isUnknown((String)ip)) continue;
            return NetKit.getMultistageReverseProxyIp((String)ip);
        }
        ip = request.getRemoteAddr();
        return NetKit.getMultistageReverseProxyIp((String)ip);
    }

    public static Map<String, String> getHeader(HttpServletRequest request) {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            headerMap.put(name, request.getHeader(name));
        }
        return headerMap;
    }

    public static String getHeader(HttpServletRequest request, String nameIgnoreCase) {
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (null == name || !name.equalsIgnoreCase(nameIgnoreCase)) continue;
            return request.getHeader(name);
        }
        return null;
    }

    public static String getHeader(HttpServletRequest request, String name, String charsetName) {
        return ServletKit.getHeader(request, name, Charset.charset((String)charsetName));
    }

    public static String getHeader(HttpServletRequest request, String name, java.nio.charset.Charset charset) {
        String header = request.getHeader(name);
        if (null != header) {
            return Charset.convert((String)header, (java.nio.charset.Charset)Charset.ISO_8859_1, (java.nio.charset.Charset)charset);
        }
        return null;
    }

    public static void setHeader(HttpServletResponse response, String name, Object value) {
        if (value instanceof String) {
            response.setHeader(name, (String)value);
        } else if (Date.class.isAssignableFrom(value.getClass())) {
            response.setDateHeader(name, ((Date)value).getTime());
        } else if (value instanceof Integer || "int".equals(value.getClass().getSimpleName().toLowerCase())) {
            response.setIntHeader(name, ((Integer)value).intValue());
        } else {
            response.setHeader(name, value.toString());
        }
    }

    public static boolean isIE(HttpServletRequest request) {
        String userAgent = ServletKit.getHeader(request, "User-Agent");
        if (StringKit.isNotBlank((CharSequence)userAgent)) {
            return (userAgent = userAgent.toUpperCase()).contains("MSIE") || userAgent.contains("TRIDENT");
        }
        return false;
    }

    public static boolean isGetMethod(HttpServletRequest request) {
        return "GET".equalsIgnoreCase(request.getMethod());
    }

    public static boolean isPostMethod(HttpServletRequest request) {
        return "POST".equalsIgnoreCase(request.getMethod());
    }

    public static boolean isMultipart(HttpServletRequest request) {
        if (!ServletKit.isPostMethod(request)) {
            return false;
        }
        String contentType = request.getContentType();
        if (StringKit.isBlank((CharSequence)contentType)) {
            return false;
        }
        return contentType.toLowerCase().startsWith("multipart/");
    }

    public static Map<String, Cookie> getCookie(HttpServletRequest httpServletRequest) {
        Object[] cookies = httpServletRequest.getCookies();
        if (ArrayKit.isEmpty((Object[])cookies)) {
            return MapKit.empty();
        }
        return IterKit.toMap((Iterator)new ArrayIterator((Object[])httpServletRequest.getCookies()), (Map)new CaseInsensitiveMap(), Cookie::getName);
    }

    public static Cookie getCookie(HttpServletRequest httpServletRequest, String name) {
        return ServletKit.getCookie(httpServletRequest).get(name);
    }

    public static void addCookie(HttpServletResponse response, Cookie cookie) {
        response.addCookie(cookie);
    }

    public static void addCookie(HttpServletResponse response, String name, String value) {
        response.addCookie(new Cookie(name, value));
    }

    public static void addCookie(HttpServletResponse response, String name, String value, int maxAgeInSeconds, String path, String domain) {
        Cookie cookie = new Cookie(name, value);
        if (null != domain) {
            cookie.setDomain(domain);
        }
        cookie.setMaxAge(maxAgeInSeconds);
        cookie.setPath(path);
        ServletKit.addCookie(response, cookie);
    }

    public static void addCookie(HttpServletResponse response, String name, String value, int maxAgeInSeconds) {
        ServletKit.addCookie(response, name, value, maxAgeInSeconds, "/", null);
    }

    public static PrintWriter getWriter(HttpServletResponse response) throws InstrumentException {
        try {
            return response.getWriter();
        }
        catch (IOException e) {
            throw new InstrumentException((Throwable)e);
        }
    }

    public static void write(HttpServletResponse response, String text, String contentType) {
        response.setContentType(contentType);
        PrintWriter writer = null;
        try {
            writer = response.getWriter();
            ((Writer)writer).write(text);
            ((Writer)writer).flush();
        }
        catch (IOException e) {
            throw new InstrumentException((Throwable)e);
        }
        finally {
            IoKit.close((Closeable)writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(HttpServletResponse response, File file) {
        String fileName = file.getName();
        String contentType = (String)ObjectKit.defaultIfNull((Object)FileKit.getMediaType((String)fileName), (Object)"application/octet-stream");
        BufferedInputStream in = null;
        try {
            in = FileKit.getInputStream((File)file);
            ServletKit.write(response, in, contentType, fileName);
        }
        finally {
            IoKit.close((Closeable)in);
        }
    }

    public static void write(HttpServletResponse response, InputStream in, String contentType, String fileName) {
        String charset = (String)ObjectKit.defaultIfNull((Object)response.getCharacterEncoding(), (Object)"UTF-8");
        response.setHeader("Content-Disposition", StringKit.format((CharSequence)"attachment;filename\"{}\"", (Object[])new Object[]{UriKit.encode((String)fileName, (String)charset)}));
        response.setContentType(contentType);
        ServletKit.write(response, in);
    }

    public static void write(HttpServletResponse response, InputStream in, String contentType) {
        response.setContentType(contentType);
        ServletKit.write(response, in);
    }

    public static void write(HttpServletResponse response, InputStream in) {
        ServletKit.write(response, in, 8192);
    }

    public static void write(HttpServletResponse response, InputStream in, int bufferSize) {
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
            IoKit.copy((InputStream)in, (OutputStream)out, (int)bufferSize);
        }
        catch (IOException e) {
            throw new InstrumentException((Throwable)e);
        }
        finally {
            IoKit.close((Closeable)out);
            IoKit.close((Closeable)in);
        }
    }
}

