/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.extra.ftp;

import java.io.Closeable;
import java.io.File;
import java.util.List;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.toolkit.CharsKit;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.extra.ftp.FtpConfig;

public abstract class AbstractFtp
implements Closeable {
    public static final java.nio.charset.Charset DEFAULT_CHARSET = Charset.UTF_8;
    protected FtpConfig ftpConfig;

    protected AbstractFtp(FtpConfig config) {
        this.ftpConfig = config;
    }

    private static boolean containsIgnoreCase(List<String> names, String nameToFind) {
        if (CollKit.isEmpty(names)) {
            return false;
        }
        if (StringKit.isEmpty((CharSequence)nameToFind)) {
            return false;
        }
        for (String name : names) {
            if (!nameToFind.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public abstract AbstractFtp reconnectIfTimeout();

    public abstract boolean cd(String var1);

    public boolean toParent() {
        return this.cd("..");
    }

    public abstract String pwd();

    public abstract boolean mkdir(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDir(String dir) {
        String workDir = this.pwd();
        try {
            boolean bl = this.cd(dir);
            return bl;
        }
        finally {
            this.cd(workDir);
        }
    }

    public boolean exist(String path) {
        List<String> names;
        if (StringKit.isBlank((CharSequence)path)) {
            return false;
        }
        if (this.isDir(path)) {
            return true;
        }
        if (CharsKit.isFileSeparator((char)path.charAt(path.length() - 1))) {
            return false;
        }
        String fileName = FileKit.getName((String)path);
        if (".".equals(fileName) || "..".equals(fileName)) {
            return false;
        }
        String dir = StringKit.emptyToDefault((CharSequence)StringKit.removeSuffix((CharSequence)path, (CharSequence)fileName), (String)".");
        try {
            names = this.ls(dir);
        }
        catch (InternalException ignore) {
            return false;
        }
        return AbstractFtp.containsIgnoreCase(names, fileName);
    }

    public abstract List<String> ls(String var1);

    public abstract boolean delFile(String var1);

    public abstract boolean delDir(String var1);

    public void mkDirs(String dir) {
        String[] dirs = StringKit.trim((CharSequence)dir).split("[\\\\/]+");
        String now = this.pwd();
        if (dirs.length > 0 && StringKit.isEmpty((CharSequence)dirs[0])) {
            this.cd("/");
        }
        for (String s : dirs) {
            if (!StringKit.isNotEmpty((CharSequence)s)) continue;
            boolean exist = true;
            try {
                if (!this.cd(s)) {
                    exist = false;
                }
            }
            catch (InternalException e) {
                exist = false;
            }
            if (exist) continue;
            this.mkdir(s);
            this.cd(s);
        }
        this.cd(now);
    }

    public abstract boolean upload(String var1, File var2);

    public abstract void download(String var1, File var2);

    public abstract void download(String var1, String var2);

    public void download(String path, File outFile, String tempFileSuffix) {
        tempFileSuffix = StringKit.isBlank((CharSequence)tempFileSuffix) ? ".temp" : StringKit.addPrefixIfNot((CharSequence)tempFileSuffix, (CharSequence)".");
        String fileName = outFile.isDirectory() ? FileKit.getName((String)path) : outFile.getName();
        String tempFileName = fileName + tempFileSuffix;
        outFile = new File(outFile.isDirectory() ? outFile : outFile.getParentFile(), tempFileName);
        try {
            this.download(path, outFile);
            FileKit.rename((File)outFile, (String)fileName, (boolean)true);
        }
        catch (Throwable e) {
            FileKit.delete((File)outFile);
            throw new InternalException(e);
        }
    }
}

