/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.extra.captcha.provider;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.aoju.bus.core.image.GifEncoder;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.RandomKit;
import org.aoju.bus.extra.captcha.provider.AbstractProvider;

public class GifProvider
extends AbstractProvider {
    private int quality = 10;
    private int repeat = 0;
    private int minColor = 0;
    private int maxColor = 255;

    public GifProvider(int width, int height) {
        this(width, height, 5);
    }

    public GifProvider(int width, int height, int codeCount) {
        super(width, height, codeCount, 10);
    }

    public GifProvider setQuality(int quality) {
        if (quality < 1) {
            quality = 1;
        }
        this.quality = quality;
        return this;
    }

    public GifProvider setRepeat(int repeat) {
        if (repeat >= 0) {
            this.repeat = repeat;
        }
        return this;
    }

    public GifProvider setMaxColor(int maxColor) {
        this.maxColor = maxColor;
        return this;
    }

    public GifProvider setMinColor(int minColor) {
        this.minColor = minColor;
        return this;
    }

    @Override
    public void create() {
        this.generateCode();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GifEncoder gifEncoder = new GifEncoder();
        gifEncoder.start((OutputStream)out);
        gifEncoder.setQuality(this.quality);
        int delay = 100;
        gifEncoder.setDelay(delay);
        gifEncoder.setRepeat(this.repeat);
        char[] chars = this.code.toCharArray();
        Color[] fontColor = new Color[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            fontColor[i] = this.getRandomColor(this.minColor, this.maxColor);
            BufferedImage frame = this.graphicsImage(chars, fontColor, chars, i);
            gifEncoder.addFrame(frame);
            frame.flush();
        }
        gifEncoder.finish();
        this.imageBytes = out.toByteArray();
    }

    @Override
    protected Image createImage(String code) {
        return null;
    }

    private BufferedImage graphicsImage(char[] chars, Color[] fontColor, char[] words, int flag) {
        BufferedImage image = new BufferedImage(this.width, this.height, 1);
        Graphics2D g2d = image.createGraphics();
        g2d.setColor((Color)ObjectKit.defaultIfNull((Object)this.background, (Object)Color.WHITE));
        g2d.fillRect(0, 0, this.width, this.height);
        float y = (this.height >> 1) + (this.font.getSize() >> 1);
        float m = 1.0f * (float)(this.width - chars.length * this.font.getSize()) / (float)chars.length;
        float x = Math.max(m / 2.0f, 2.0f);
        g2d.setFont(this.font);
        if (null != this.textAlpha) {
            g2d.setComposite(this.textAlpha);
        }
        for (int i = 0; i < chars.length; ++i) {
            AlphaComposite ac = AlphaComposite.getInstance(3, this.getAlpha(chars.length, flag, i));
            g2d.setComposite(ac);
            g2d.setColor(fontColor[i]);
            g2d.drawOval(RandomKit.randomInt((int)this.width), RandomKit.randomInt((int)this.height), RandomKit.randomInt((int)5, (int)30), 5 + RandomKit.randomInt((int)5, (int)30));
            g2d.drawString("" + words[i], x + ((float)this.font.getSize() + m) * (float)i, y);
        }
        g2d.dispose();
        return image;
    }

    private float getAlpha(int v, int i, int j) {
        int num = i + j;
        float r = 1.0f / (float)v;
        float s = (float)(v + 1) * r;
        return num > v ? (float)num * r - s : (float)num * r;
    }

    private Color getRandomColor(int min, int max) {
        if (min > 255) {
            min = 255;
        }
        if (max > 255) {
            max = 255;
        }
        if (min < 0) {
            min = 0;
        }
        if (max < 0) {
            max = 0;
        }
        if (min > max) {
            min = 0;
            max = 255;
        }
        return new Color(RandomKit.randomInt((int)min, (int)max), RandomKit.randomInt((int)min, (int)max), RandomKit.randomInt((int)min, (int)max));
    }
}

