/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.extra.ftp;

import java.io.File;
import java.util.ArrayList;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.toolkit.NetKit;
import org.apache.ftpserver.ConnectionConfig;
import org.apache.ftpserver.FtpServerFactory;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.Ftplet;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.ftplet.UserManager;
import org.apache.ftpserver.listener.ListenerFactory;
import org.apache.ftpserver.ssl.SslConfiguration;
import org.apache.ftpserver.ssl.SslConfigurationFactory;
import org.apache.ftpserver.usermanager.PropertiesUserManagerFactory;
import org.apache.ftpserver.usermanager.impl.BaseUser;
import org.apache.ftpserver.usermanager.impl.WritePermission;

public class FtpServer {
    FtpServerFactory serverFactory = new FtpServerFactory();
    ListenerFactory listenerFactory = new ListenerFactory();

    public static FtpServer create() {
        return new FtpServer();
    }

    public FtpServerFactory getServerFactory() {
        return this.serverFactory;
    }

    public FtpServer setConnectionConfig(ConnectionConfig connectionConfig) {
        this.serverFactory.setConnectionConfig(connectionConfig);
        return this;
    }

    public ListenerFactory getListenerFactory() {
        return this.listenerFactory;
    }

    public FtpServer setPort(int port) {
        Assert.isTrue((boolean)NetKit.isValidPort((int)port), (String)"Invalid port!", (Object[])new Object[0]);
        this.listenerFactory.setPort(port);
        return this;
    }

    public UserManager getUserManager() {
        return this.serverFactory.getUserManager();
    }

    public FtpServer setUserManager(UserManager userManager) {
        this.serverFactory.setUserManager(userManager);
        return this;
    }

    public FtpServer addUser(User user) {
        try {
            this.getUserManager().save(user);
        }
        catch (FtpException e) {
            throw new InternalException((Throwable)e);
        }
        return this;
    }

    public FtpServer addAnonymous(String homePath) {
        BaseUser user = new BaseUser();
        user.setName("anonymous");
        user.setHomeDirectory(homePath);
        ArrayList<WritePermission> authorities = new ArrayList<WritePermission>();
        authorities.add(new WritePermission());
        user.setAuthorities(authorities);
        return this.addUser((User)user);
    }

    public FtpServer delUser(String userName) {
        try {
            this.getUserManager().delete(userName);
        }
        catch (FtpException e) {
            throw new InternalException((Throwable)e);
        }
        return this;
    }

    public FtpServer setSsl(SslConfiguration ssl) {
        this.listenerFactory.setSslConfiguration(ssl);
        this.listenerFactory.setImplicitSsl(true);
        return this;
    }

    public FtpServer setSsl(File keystoreFile, String password) {
        SslConfigurationFactory sslFactory = new SslConfigurationFactory();
        sslFactory.setKeystoreFile(keystoreFile);
        sslFactory.setKeystorePassword(password);
        return this.setSsl(sslFactory.createSslConfiguration());
    }

    public FtpServer setUsersConfig(File propertiesFile) {
        PropertiesUserManagerFactory userManagerFactory = new PropertiesUserManagerFactory();
        userManagerFactory.setFile(propertiesFile);
        return this.setUserManager(userManagerFactory.createUserManager());
    }

    public FtpServer addFtplet(String name, Ftplet ftplet) {
        this.serverFactory.getFtplets().put(name, ftplet);
        return this;
    }

    public void start() {
        this.serverFactory.addListener("default", this.listenerFactory.createListener());
        try {
            this.serverFactory.createServer().start();
        }
        catch (FtpException e) {
            throw new InternalException((Throwable)e);
        }
    }
}

