/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.extra.ssh;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.sftp.RemoteResourceInfo;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import net.schmizz.sshj.xfer.FileSystemFile;
import net.schmizz.sshj.xfer.LocalDestFile;
import net.schmizz.sshj.xfer.LocalSourceFile;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.extra.ftp.AbstractFtp;
import org.aoju.bus.extra.ftp.FtpConfig;

public class SshjSftp
extends AbstractFtp {
    private SSHClient ssh;
    private SFTPClient sftp;

    public SshjSftp(String sshHost) {
        this(new FtpConfig(sshHost, 22, null, null, Charset.UTF_8));
    }

    public SshjSftp(String sshHost, String sshUser, String sshPass) {
        this(new FtpConfig(sshHost, 22, sshUser, sshPass, Charset.UTF_8));
    }

    public SshjSftp(String sshHost, int sshPort, String sshUser, String sshPass) {
        this(new FtpConfig(sshHost, sshPort, sshUser, sshPass, Charset.UTF_8));
    }

    public SshjSftp(String sshHost, int sshPort, String sshUser, String sshPass, java.nio.charset.Charset charset) {
        this(new FtpConfig(sshHost, sshPort, sshUser, sshPass, charset));
    }

    protected SshjSftp(FtpConfig config) {
        super(config);
        this.init();
    }

    public void init() {
        this.ssh = new SSHClient();
        this.ssh.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
        try {
            this.ssh.connect(this.ftpConfig.getHost(), this.ftpConfig.getPort());
            this.ssh.authPassword(this.ftpConfig.getUser(), this.ftpConfig.getPassword());
            this.ssh.setRemoteCharset(this.ftpConfig.getCharset());
            this.sftp = this.ssh.newSFTPClient();
        }
        catch (IOException e) {
            throw new InternalException("sftp \u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public AbstractFtp reconnectIfTimeout() {
        if (StringKit.isBlank((CharSequence)this.ftpConfig.getHost())) {
            throw new InternalException("Host is blank!");
        }
        try {
            this.cd("/");
        }
        catch (InternalException e) {
            this.close();
            this.init();
        }
        return this;
    }

    @Override
    public boolean cd(String directory) {
        String exec = String.format("cd %s", directory);
        this.command(exec);
        String pwd = this.pwd();
        return pwd.equals(directory);
    }

    @Override
    public String pwd() {
        return this.command("pwd");
    }

    @Override
    public boolean mkdir(String dir) {
        try {
            this.sftp.mkdir(dir);
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
        return this.containsFile(dir);
    }

    @Override
    public List<String> ls(String path) {
        List infoList;
        try {
            infoList = this.sftp.ls(path);
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
        if (CollKit.isNotEmpty((Collection)infoList)) {
            return CollKit.map((Iterable)infoList, RemoteResourceInfo::getName, (boolean)true);
        }
        return null;
    }

    @Override
    public boolean delFile(String path) {
        try {
            this.sftp.rm(path);
            return !this.containsFile(path);
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
    }

    @Override
    public boolean delDir(String dirPath) {
        try {
            this.sftp.rmdir(dirPath);
            return !this.containsFile(dirPath);
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
    }

    @Override
    public boolean upload(String destPath, File file) {
        try {
            this.sftp.put((LocalSourceFile)new FileSystemFile(file), destPath);
            return this.containsFile(destPath);
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
    }

    @Override
    public void download(String path, File dest) {
        try {
            this.sftp.get(path, (LocalDestFile)new FileSystemFile(dest));
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
    }

    @Override
    public void download(String source, String dest) {
        List<String> files = this.ls(source);
        if (files != null && !files.isEmpty()) {
            files.forEach(path -> this.download(source + "/" + path, FileKit.file((String)dest)));
        }
    }

    @Override
    public void close() {
        try {
            this.sftp.close();
            this.ssh.disconnect();
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
    }

    public boolean containsFile(String fileDir) {
        try {
            this.sftp.lstat(fileDir);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public String command(String exec) {
        Session session = null;
        try {
            session = this.ssh.startSession();
            Session.Command command = session.exec(exec);
            InputStream inputStream = command.getInputStream();
            String string = IoKit.read((InputStream)inputStream, (java.nio.charset.Charset)DEFAULT_CHARSET);
            return string;
        }
        catch (Exception e) {
            throw new InternalException((Throwable)e);
        }
        finally {
            IoKit.close((Closeable)session);
        }
    }
}

