/*********************************************************************************
 *                                                                               *
 * The MIT License (MIT)                                                         *
 *                                                                               *
 * Copyright (c) 2015-2021 aoju.org and other contributors.                      *
 *                                                                               *
 * Permission is hereby granted, free of charge, to any person obtaining a copy  *
 * of this software and associated documentation files (the "Software"), to deal *
 * in the Software without restriction, including without limitation the rights  *
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell     *
 * copies of the Software, and to permit persons to whom the Software is         *
 * furnished to do so, subject to the following conditions:                      *
 *                                                                               *
 * The above copyright notice and this permission notice shall be included in    *
 * all copies or substantial portions of the Software.                           *
 *                                                                               *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR    *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,      *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE   *
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER        *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, *
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN     *
 * THE SOFTWARE.                                                                 *
 *                                                                               *
 ********************************************************************************/
package org.aoju.bus.goalie;

import org.aoju.bus.logger.Logger;
import reactor.netty.DisposableServer;
import reactor.netty.http.server.HttpServer;

/**
 * 服务端
 *
 * @author Justubborn
 * @version 6.2.8
 * @since JDK 1.8+
 */
public class Athlete {

    private final HttpServer httpServer;
    String METHOD = "method";
    String VERSION = "v";
    String FORMAT = "format";
    String SIGN = "sign";
    String X_ACCESS_TOKEN = "X-Access-Token";
    String X_REMOTE_CHANNEL = "x_remote_channel";
    Integer MAX_INMEMORY_SIZE = 2 * 1024 * 1024;
    private DisposableServer disposableServer;

    public Athlete(HttpServer httpServer) {
        this.httpServer = httpServer;
    }

    private void init() {
        disposableServer = httpServer.bindNow();
        Logger.info("reactor server start on port:{} success", disposableServer.port());
    }

    private void destroy() {
        disposableServer.disposeNow();
        Logger.info("reactor server stop on port:{} success", disposableServer.port());
    }

}
