/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.goalie.handler;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.goalie.annotation.ApiVersion;
import org.aoju.bus.goalie.annotation.ClientVersion;
import org.aoju.bus.goalie.handler.ApiVersionRequestCondition;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.web.servlet.mvc.condition.RequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class ApiRequestMappingHandlerMapping
extends RequestMappingHandlerMapping {
    protected RequestMappingInfo getMappingForMethod(Method method, Class<?> handlerType) {
        RequestMappingInfo mappinginfo = super.getMappingForMethod(method, handlerType);
        if (null != mappinginfo) {
            RequestMappingInfo apiVersionMappingInfo = this.getApiVersionMappingInfo(method, handlerType);
            return null == apiVersionMappingInfo ? mappinginfo : apiVersionMappingInfo.combine(mappinginfo);
        }
        return mappinginfo;
    }

    protected RequestCondition<?> getCustomTypeCondition(Class<?> handlerType) {
        ClientVersion clientVersion = (ClientVersion)AnnotatedElementUtils.findMergedAnnotation(handlerType, ClientVersion.class);
        return this.createRequestCondtion(clientVersion);
    }

    protected RequestCondition<?> getCustomMethodCondition(Method method) {
        ClientVersion clientVersion = (ClientVersion)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, ClientVersion.class);
        return this.createRequestCondtion(clientVersion);
    }

    private RequestCondition<?> createRequestCondtion(ClientVersion clientVersion) {
        if (null == clientVersion) {
            return null;
        }
        if (null != clientVersion.value() && clientVersion.value().length > 0) {
            return new ApiVersionRequestCondition(clientVersion.value());
        }
        if (null != clientVersion.expression() && clientVersion.expression().length > 0) {
            return new ApiVersionRequestCondition(clientVersion.expression());
        }
        return null;
    }

    private RequestMappingInfo getApiVersionMappingInfo(Method method, Class<?> handlerType) {
        ApiVersion apiVersion = (ApiVersion)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, ApiVersion.class);
        if (null == apiVersion || StringKit.isBlank((CharSequence)apiVersion.value())) {
            apiVersion = (ApiVersion)AnnotatedElementUtils.findMergedAnnotation(handlerType, ApiVersion.class);
        }
        return null == apiVersion || StringKit.isBlank((CharSequence)apiVersion.value()) ? null : RequestMappingInfo.paths((String[])new String[]{apiVersion.value()}).build();
    }
}

