/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.galaxy.io;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.ByteUtils;
import org.aoju.bus.core.utils.IoUtils;
import org.aoju.bus.core.utils.StreamUtils;
import org.aoju.bus.image.Tag;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.galaxy.data.BulkData;
import org.aoju.bus.image.galaxy.data.ElementDictionary;
import org.aoju.bus.image.galaxy.data.Fragments;
import org.aoju.bus.image.galaxy.data.ItemPointer;
import org.aoju.bus.image.galaxy.data.Sequence;
import org.aoju.bus.image.galaxy.data.VR;
import org.aoju.bus.image.galaxy.io.BulkDataCreator;
import org.aoju.bus.image.galaxy.io.BulkDataDescriptor;
import org.aoju.bus.image.galaxy.io.ImageInputHandler;
import org.aoju.bus.logger.Logger;

public class ImageInputStream
extends FilterInputStream
implements ImageInputHandler,
BulkDataCreator {
    private static final String UNEXPECTED_NON_ZERO_ITEM_LENGTH = "Unexpected item value of {} #{} @ {}";
    private static final String UNEXPECTED_ATTRIBUTE = "Unexpected attribute {} #{} @ {}";
    private static final String MISSING_TRANSFER_SYNTAX = "Missing Transfer Syntax (0002,0010) - assume Explicit VR Little Endian";
    private static final String MISSING_FMI_LENGTH = "Missing or wrong File Meta Information Group Length (0002,0000)";
    private static final String NOT_A_DICOM_STREAM = "Not a DICOM Stream";
    private static final String IMPLICIT_VR_BIG_ENDIAN = "Implicit VR Big Endian encoded DICOM Stream";
    private static final String DEFLATED_WITH_ZLIB_HEADER = "Deflated DICOM Stream with ZLIB Header";
    private static final int ZLIB_HEADER = 30876;
    private static final int DEF_ALLOCATE_LIMIT = 0x4000000;
    private static final int BYTE_BUF_LENGTH = 8192;
    private final byte[] buffer = new byte[12];
    private final List<ItemPointer> itemPointers = new ArrayList<ItemPointer>(4);
    private byte[] byteBuf;
    private int allocateLimit = 0x4000000;
    private String uri;
    private String tsuid;
    private byte[] preamble;
    private Attributes fileMetaInformation;
    private boolean hasfmi;
    private boolean bigEndian;
    private boolean explicitVR;
    private IncludeBulkData includeBulkData = IncludeBulkData.YES;
    private long pos;
    private long fmiEndPos = -1L;
    private long tagPos;
    private long markPos;
    private int tag;
    private VR vr;
    private int encodedVR;
    private int length;
    private ImageInputHandler handler = this;
    private BulkDataCreator bulkDataCreator = this;
    private BulkDataDescriptor bulkDataDescriptor = BulkDataDescriptor.DEFAULT;
    private boolean excludeBulkData;
    private boolean includeBulkDataURI;
    private boolean catBlkFiles = true;
    private String blkFilePrefix = "blk";
    private String blkFileSuffix;
    private File blkDirectory;
    private ArrayList<File> blkFiles;
    private String blkURI;
    private FileOutputStream blkOut;
    private long blkOutPos;

    public ImageInputStream(InputStream in, String tsuid) throws IOException {
        super(in);
        this.switchTransferSyntax(tsuid);
    }

    public ImageInputStream(InputStream in) throws IOException {
        super(in.markSupported() ? in : new BufferedInputStream(in));
        this.guessTransferSyntax();
    }

    public ImageInputStream(File file) throws IOException {
        super(new BufferedInputStream(new FileInputStream(file)));
        try {
            this.guessTransferSyntax();
        }
        catch (IOException e) {
            IoUtils.close((Closeable)this.in);
            throw e;
        }
        this.uri = file.toURI().toString();
    }

    public static String toAttributePath(List<ItemPointer> itemPointers, int tag) {
        StringBuilder sb = new StringBuilder();
        for (ItemPointer itemPointer : itemPointers) {
            sb.append('/').append(Tag.toHexString(itemPointer.sequenceTag)).append('/').append(itemPointer.itemIndex);
        }
        sb.append('/').append(Tag.toHexString(tag));
        return sb.toString();
    }

    public final String getTransferSyntax() {
        return this.tsuid;
    }

    public final int getAllocateLimit() {
        return this.allocateLimit;
    }

    public final void setAllocateLimit(int allocateLimit) {
        this.allocateLimit = allocateLimit;
    }

    public final String getURI() {
        return this.uri;
    }

    public final void setURI(String uri) {
        this.uri = uri;
    }

    public final IncludeBulkData getIncludeBulkData() {
        return this.includeBulkData;
    }

    public final void setIncludeBulkData(IncludeBulkData includeBulkData) {
        if (includeBulkData == null) {
            throw new NullPointerException();
        }
        this.includeBulkData = includeBulkData;
    }

    public final BulkDataDescriptor getBulkDataDescriptor() {
        return this.bulkDataDescriptor;
    }

    public final void setBulkDataDescriptor(BulkDataDescriptor bulkDataDescriptor) {
        this.bulkDataDescriptor = bulkDataDescriptor;
    }

    public final String getBulkDataFilePrefix() {
        return this.blkFilePrefix;
    }

    public final void setBulkDataFilePrefix(String blkFilePrefix) {
        this.blkFilePrefix = blkFilePrefix;
    }

    public final String getBulkDataFileSuffix() {
        return this.blkFileSuffix;
    }

    public final void setBulkDataFileSuffix(String blkFileSuffix) {
        this.blkFileSuffix = blkFileSuffix;
    }

    public final File getBulkDataDirectory() {
        return this.blkDirectory;
    }

    public final void setBulkDataDirectory(File blkDirectory) {
        this.blkDirectory = blkDirectory;
    }

    public final boolean isConcatenateBulkDataFiles() {
        return this.catBlkFiles;
    }

    public final void setConcatenateBulkDataFiles(boolean catBlkFiles) {
        this.catBlkFiles = catBlkFiles;
    }

    public final List<File> getBulkDataFiles() {
        if (this.blkFiles != null) {
            return this.blkFiles;
        }
        return Collections.emptyList();
    }

    public final void setImageInputHandler(ImageInputHandler handler) {
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        this.handler = handler;
    }

    public void setBulkDataCreator(BulkDataCreator bulkDataCreator) {
        if (bulkDataCreator == null) {
            throw new NullPointerException("bulkDataCreator");
        }
        this.bulkDataCreator = bulkDataCreator;
    }

    public final void setFileMetaInformationGroupLength(byte[] val) {
        this.fmiEndPos = this.pos + (long)ByteUtils.bytesToInt((byte[])val, (int)0, (boolean)this.bigEndian);
    }

    public final byte[] getPreamble() {
        return this.preamble;
    }

    public Attributes getFileMetaInformation() throws IOException {
        this.readFileMetaInformation();
        return this.fileMetaInformation;
    }

    public final int level() {
        return this.itemPointers.size();
    }

    public final int tag() {
        return this.tag;
    }

    public final VR vr() {
        return this.vr;
    }

    public final int length() {
        return this.length;
    }

    public final long getPosition() {
        return this.pos;
    }

    public void setPosition(long pos) {
        this.pos = pos;
    }

    public long getTagPosition() {
        return this.tagPos;
    }

    public final boolean bigEndian() {
        return this.bigEndian;
    }

    public final boolean explicitVR() {
        return this.explicitVR;
    }

    public boolean isExcludeBulkData() {
        return this.excludeBulkData;
    }

    public boolean isIncludeBulkDataURI() {
        return this.includeBulkDataURI;
    }

    public String getAttributePath() {
        return ImageInputStream.toAttributePath(this.itemPointers, this.tag);
    }

    @Override
    public void close() throws IOException {
        IoUtils.close((Closeable)this.blkOut);
        super.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        super.mark(readlimit);
        this.markPos = this.pos;
    }

    @Override
    public synchronized void reset() throws IOException {
        super.reset();
        this.pos = this.markPos;
    }

    @Override
    public final int read() throws IOException {
        int read = super.read();
        if (read >= 0) {
            ++this.pos;
        }
        return read;
    }

    @Override
    public final int read(byte[] b, int off, int len) throws IOException {
        int read = super.read(b, off, len);
        if (read > 0) {
            this.pos += (long)read;
        }
        return read;
    }

    @Override
    public final int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public final long skip(long n) throws IOException {
        long skip = super.skip(n);
        this.pos += skip;
        return skip;
    }

    public void skipFully(long n) throws IOException {
        StreamUtils.skipFully((InputStream)this, (long)n);
    }

    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        StreamUtils.readFully((InputStream)this, (byte[])b, (int)off, (int)len);
    }

    public void readFully(short[] s, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > s.length || off + len < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > s.length!");
        }
        if (this.byteBuf == null) {
            this.byteBuf = new byte[8192];
        }
        while (len > 0) {
            int nelts = Math.min(len, this.byteBuf.length / 2);
            this.readFully(this.byteBuf, 0, nelts * 2);
            ByteUtils.bytesToShorts((byte[])this.byteBuf, (short[])s, (int)off, (int)nelts, (boolean)this.bigEndian);
            off += nelts;
            len -= nelts;
        }
    }

    public void readHeader() throws IOException {
        byte[] buf = this.buffer;
        this.tagPos = this.pos;
        this.readFully(buf, 0, 8);
        this.encodedVR = 0;
        this.tag = ByteUtils.bytesToTag((byte[])buf, (int)0, (boolean)this.bigEndian);
        switch (this.tag) {
            case -73728: 
            case -73715: 
            case -73507: {
                this.vr = null;
                break;
            }
            default: {
                if (this.explicitVR) {
                    this.encodedVR = ByteUtils.bytesToVR((byte[])buf, (int)4);
                    this.vr = VR.valueOf(this.encodedVR);
                    if (this.vr.headerLength() == 8) {
                        this.length = ByteUtils.bytesToUShort((byte[])buf, (int)6, (boolean)this.bigEndian);
                        return;
                    }
                    this.readFully(buf, 4, 4);
                    break;
                }
                this.vr = VR.UN;
            }
        }
        this.length = ByteUtils.bytesToInt((byte[])buf, (int)4, (boolean)this.bigEndian);
    }

    public boolean readItemHeader() throws IOException {
        while (true) {
            this.readHeader();
            if (this.tag == -73728) {
                return true;
            }
            if (this.tag == -73507) {
                if (this.length != 0) {
                    this.skipAttribute(UNEXPECTED_NON_ZERO_ITEM_LENGTH);
                }
                return false;
            }
            this.skipAttribute(UNEXPECTED_ATTRIBUTE);
        }
    }

    public Attributes readCommand() throws IOException {
        if (this.bigEndian || this.explicitVR) {
            throw new IllegalStateException("bigEndian=" + this.bigEndian + ", explicitVR=" + this.explicitVR);
        }
        Attributes attrs = new Attributes(9);
        this.readAttributes(attrs, -1, -1);
        return attrs;
    }

    public Attributes readDataset(int len, int stopTag) throws IOException {
        this.handler.startDataset(this);
        this.readFileMetaInformation();
        Attributes attrs = new Attributes(this.bigEndian, 64);
        this.readAttributes(attrs, len, stopTag);
        attrs.trimToSize();
        this.handler.endDataset(this);
        return attrs;
    }

    public Attributes readFileMetaInformation() throws IOException {
        if (!this.hasfmi) {
            return null;
        }
        if (this.fileMetaInformation != null) {
            return this.fileMetaInformation;
        }
        Attributes attrs = new Attributes(this.bigEndian, 9);
        while (this.pos != this.fmiEndPos) {
            this.mark(12);
            this.readHeader();
            if (Tag.groupNumber(this.tag) != 2) {
                Logger.warn((String)MISSING_FMI_LENGTH, (Object[])new Object[0]);
                this.reset();
                break;
            }
            if (this.vr != null) {
                if (this.vr == VR.UN) {
                    this.vr = ElementDictionary.getStandardElementDictionary().vrOf(this.tag);
                }
                this.handler.readValue(this, attrs);
                continue;
            }
            this.skipAttribute(UNEXPECTED_ATTRIBUTE);
        }
        this.fileMetaInformation = attrs;
        String tsuid = attrs.getString(131088, null);
        if (tsuid == null) {
            Logger.warn((String)MISSING_TRANSFER_SYNTAX, (Object[])new Object[0]);
            tsuid = "1.2.840.10008.1.2.1";
        }
        this.switchTransferSyntax(tsuid);
        return attrs;
    }

    public void readAttributes(Attributes attrs, int len, int stopTag) throws IOException {
        boolean undeflen = len == -1;
        boolean hasStopTag = stopTag != -1;
        long endPos = this.pos + ((long)len & 0xFFFFFFFFL);
        while (undeflen || this.pos < endPos) {
            try {
                this.readHeader();
            }
            catch (EOFException e) {
                if (undeflen && this.pos == this.tagPos) break;
                throw e;
            }
            if (hasStopTag && this.tag == stopTag) break;
            if (this.vr != null) {
                if (this.vr == VR.UN) {
                    this.vr = ElementDictionary.vrOf(this.tag, attrs.getPrivateCreator(this.tag));
                    if (this.vr == VR.UN && this.length == -1) {
                        this.vr = VR.SQ;
                    }
                }
                this.excludeBulkData = this.includeBulkData == IncludeBulkData.NO && this.isBulkData(attrs);
                this.includeBulkDataURI = len != 0 && this.vr != VR.SQ && this.includeBulkData == IncludeBulkData.URI && this.isBulkData(attrs);
                this.handler.readValue(this, attrs);
                continue;
            }
            this.skipAttribute(UNEXPECTED_ATTRIBUTE);
        }
    }

    @Override
    public void readValue(ImageInputStream dis, Attributes attrs) throws IOException {
        this.checkIsThis(dis);
        if (this.excludeBulkData) {
            this.skipFully(this.length);
        } else if (this.length == 0) {
            attrs.setNull(this.tag, this.vr);
        } else if (this.vr == VR.SQ) {
            this.readSequence(this.length, attrs, this.tag);
        } else if (this.length == -1) {
            this.readFragments(attrs, this.tag, this.vr);
        } else if (this.length == 64507 && this.in instanceof ObjectInputStream) {
            attrs.setValue(this.tag, this.vr, BulkData.deserializeFrom((ObjectInputStream)this.in));
        } else if (this.includeBulkDataURI) {
            attrs.setValue(this.tag, this.vr, this.bulkDataCreator.createBulkData(this));
        } else {
            byte[] b = this.readValue();
            if (!Tag.isGroupLength(this.tag)) {
                if (this.bigEndian != attrs.bigEndian()) {
                    this.vr.toggleEndian(b, false);
                }
                attrs.setBytes(this.tag, this.vr, b);
            } else if (this.tag == 131072) {
                this.setFileMetaInformationGroupLength(b);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BulkData createBulkData(ImageInputStream dis) throws IOException {
        BulkData bulkData;
        if (this.uri != null && !(this.in instanceof InflaterInputStream)) {
            bulkData = new BulkData(this.uri, this.pos, this.length, this.bigEndian);
            this.skipFully(this.length);
        } else {
            if (this.blkOut == null) {
                File blkfile = File.createTempFile(this.blkFilePrefix, this.blkFileSuffix, this.blkDirectory);
                if (this.blkFiles == null) {
                    this.blkFiles = new ArrayList();
                }
                this.blkFiles.add(blkfile);
                this.blkURI = blkfile.toURI().toString();
                this.blkOut = new FileOutputStream(blkfile);
                this.blkOutPos = 0L;
            }
            try {
                StreamUtils.copy((InputStream)this, (OutputStream)this.blkOut, (int)this.length);
            }
            finally {
                if (!this.catBlkFiles) {
                    IoUtils.close((Closeable)this.blkOut);
                    this.blkOut = null;
                }
            }
            bulkData = new BulkData(this.blkURI, this.blkOutPos, this.length, this.bigEndian);
            this.blkOutPos += (long)this.length;
        }
        return bulkData;
    }

    private boolean isBulkData(Attributes attrs) {
        return this.bulkDataDescriptor.isBulkData(this.itemPointers, attrs.getPrivateCreator(this.tag), this.tag, this.vr, this.length);
    }

    @Override
    public void readValue(ImageInputStream dis, Sequence seq) throws IOException {
        this.checkIsThis(dis);
        if (this.length == 0) {
            seq.add(new Attributes(seq.getParent().bigEndian(), 0));
            return;
        }
        Attributes attrs = new Attributes(seq.getParent().bigEndian());
        seq.add(attrs);
        this.readAttributes(attrs, this.length, -73715);
        attrs.trimToSize();
    }

    @Override
    public void readValue(ImageInputStream dis, Fragments frags) throws IOException {
        this.checkIsThis(dis);
        if (this.excludeBulkData) {
            this.skipFully(this.length);
        } else if (this.length == 0) {
            frags.add("");
        } else if (this.length == 64507 && this.in instanceof ObjectInputStream) {
            frags.add(BulkData.deserializeFrom((ObjectInputStream)this.in));
        } else if (this.includeBulkDataURI) {
            frags.add(this.bulkDataCreator.createBulkData(this));
        } else {
            byte[] b = this.readValue();
            if (this.bigEndian != frags.bigEndian()) {
                frags.vr().toggleEndian(b, false);
            }
            frags.add(b);
        }
    }

    @Override
    public void startDataset(ImageInputStream dis) {
    }

    @Override
    public void endDataset(ImageInputStream dis) {
    }

    private void checkIsThis(ImageInputStream dis) {
        if (dis != this) {
            throw new IllegalArgumentException("dis != this");
        }
    }

    private void skipAttribute(String message) throws IOException {
        Logger.warn((String)message, (Object[])new Object[]{Tag.toString(this.tag), this.length, this.tagPos});
        this.skipFully(this.length);
    }

    private void readSequence(int len, Attributes attrs, int sqtag) throws IOException {
        if (len == 0) {
            attrs.setNull(sqtag, VR.SQ);
            return;
        }
        Sequence seq = attrs.newSequence(sqtag, 10);
        String privateCreator = attrs.getPrivateCreator(sqtag);
        boolean undefLen = len == -1;
        long endPos = this.pos + ((long)len & 0xFFFFFFFFL);
        boolean explicitVR0 = this.explicitVR;
        boolean bigEndian0 = this.bigEndian;
        if (this.encodedVR == 21838 && !this.probeExplicitVR()) {
            this.explicitVR = false;
            this.bigEndian = false;
        }
        int i = 0;
        while ((undefLen || this.pos < endPos) && this.readItemHeader()) {
            this.addItemPointer(sqtag, privateCreator, i);
            this.handler.readValue(this, seq);
            this.removeItemPointer();
            ++i;
        }
        this.explicitVR = explicitVR0;
        this.bigEndian = bigEndian0;
        if (seq.isEmpty()) {
            attrs.setNull(sqtag, VR.SQ);
        } else {
            seq.trimToSize();
        }
    }

    private boolean probeExplicitVR() throws IOException {
        byte[] buf = new byte[14];
        if (this.in.markSupported()) {
            this.in.mark(14);
            this.in.read(buf);
            this.in.reset();
        } else {
            if (!(this.in instanceof PushbackInputStream)) {
                this.in = new PushbackInputStream(this.in, 14);
            }
            int len = this.in.read(buf);
            ((PushbackInputStream)this.in).unread(buf, 0, len);
        }
        switch (ByteUtils.bytesToVR((byte[])buf, (int)12)) {
            case 16709: 
            case 16723: 
            case 16724: 
            case 17235: 
            case 17473: 
            case 17491: 
            case 17492: 
            case 17988: 
            case 17996: 
            case 18771: 
            case 19535: 
            case 19540: 
            case 20290: 
            case 20292: 
            case 20294: 
            case 20300: 
            case 20311: 
            case 20558: 
            case 21320: 
            case 21324: 
            case 21329: 
            case 21331: 
            case 21332: 
            case 21581: 
            case 21827: 
            case 21833: 
            case 21836: 
            case 21838: 
            case 21842: 
            case 21843: 
            case 21844: {
                return true;
            }
        }
        return false;
    }

    private void addItemPointer(int sqtag, String privateCreator, int itemIndex) {
        this.itemPointers.add(new ItemPointer(sqtag, privateCreator, itemIndex));
    }

    private void removeItemPointer() {
        this.itemPointers.remove(this.itemPointers.size() - 1);
    }

    public Attributes readItem() throws IOException {
        this.readHeader();
        if (this.tag != -73728) {
            throw new IOException("Unexpected attribute " + Tag.toString(this.tag) + " #" + this.length + " @ " + this.pos);
        }
        Attributes attrs = new Attributes(this.bigEndian);
        attrs.setItemPosition(this.tagPos);
        this.readAttributes(attrs, this.length, -73715);
        attrs.trimToSize();
        return attrs;
    }

    private void readFragments(Attributes attrs, int fragsTag, VR vr) throws IOException {
        Fragments frags = new Fragments(vr, attrs.bigEndian(), 10);
        String privateCreator = attrs.getPrivateCreator(fragsTag);
        int i = 0;
        while (this.readItemHeader()) {
            this.addItemPointer(fragsTag, privateCreator, i);
            this.handler.readValue(this, frags);
            this.removeItemPointer();
            ++i;
        }
        if (frags.isEmpty()) {
            attrs.setNull(fragsTag, vr);
        } else {
            frags.trimToSize();
            attrs.setValue(fragsTag, vr, frags);
        }
    }

    public byte[] readValue() throws IOException {
        int valLen = this.length;
        try {
            if (valLen < 0) {
                throw new EOFException();
            }
            int allocLen = this.allocateLimit >= 0 ? Math.min(valLen, this.allocateLimit) : valLen;
            byte[] value = new byte[allocLen];
            this.readFully(value, 0, allocLen);
            while (allocLen < valLen) {
                int newLength = Math.min(valLen, allocLen << 1);
                value = Arrays.copyOf(value, newLength);
                this.readFully(value, allocLen, newLength - allocLen);
                allocLen = newLength;
            }
            return value;
        }
        catch (IOException e) {
            Logger.warn((String)"IOException during read of {} #{} @ {}", (Object[])new Object[]{Tag.toString(this.tag), this.length, this.tagPos, e});
            throw e;
        }
    }

    private void switchTransferSyntax(String tsuid) throws IOException {
        this.tsuid = tsuid;
        this.bigEndian = tsuid.equals("1.2.840.10008.1.2.2");
        boolean bl = this.explicitVR = !tsuid.equals("1.2.840.10008.1.2");
        if (tsuid.equals("1.2.840.10008.1.2.1.99") || tsuid.equals("1.2.840.10008.1.2.4.95")) {
            if (this.hasZLIBHeader()) {
                Logger.warn((String)DEFLATED_WITH_ZLIB_HEADER, (Object[])new Object[0]);
                this.in = new InflaterInputStream(this.in);
            } else {
                this.in = new InflaterInputStream(this.in, new Inflater(true));
            }
        }
    }

    private boolean hasZLIBHeader() throws IOException {
        if (!this.markSupported()) {
            return false;
        }
        byte[] buf = this.buffer;
        this.mark(2);
        this.read(buf, 0, 2);
        this.reset();
        return ByteUtils.bytesToUShortBE((byte[])buf, (int)0) == 30876;
    }

    private void guessTransferSyntax() throws IOException {
        byte[] b132 = new byte[132];
        this.mark(132);
        int rlen = StreamUtils.readAvailable((InputStream)this, (byte[])b132, (int)0, (int)132);
        if (rlen == 132 && b132[128] == 68 && b132[129] == 73 && b132[130] == 67 && b132[131] == 77) {
            this.preamble = new byte[128];
            System.arraycopy(b132, 0, this.preamble, 0, 128);
            if (!this.markSupported()) {
                this.hasfmi = true;
                this.tsuid = "1.2.840.10008.1.2.1";
                this.bigEndian = false;
                this.explicitVR = true;
                return;
            }
            this.mark(132);
            rlen = StreamUtils.readAvailable((InputStream)this, (byte[])b132, (int)0, (int)132);
        }
        if (rlen < 8 || !this.guessTransferSyntax(b132, rlen, false) && !this.guessTransferSyntax(b132, rlen, true)) {
            throw new InstrumentException(NOT_A_DICOM_STREAM);
        }
        this.reset();
        this.hasfmi = Tag.isFileMetaInformation(ByteUtils.bytesToTag((byte[])b132, (int)0, (boolean)this.bigEndian));
    }

    private boolean guessTransferSyntax(byte[] b128, int rlen, boolean bigEndian) throws InstrumentException {
        int tag1 = ByteUtils.bytesToTag((byte[])b128, (int)0, (boolean)bigEndian);
        VR vr = ElementDictionary.vrOf(tag1, null);
        if (vr == VR.UN) {
            return false;
        }
        if (ByteUtils.bytesToVR((byte[])b128, (int)4) == vr.code()) {
            this.tsuid = bigEndian ? "1.2.840.10008.1.2.2" : "1.2.840.10008.1.2.1";
            this.bigEndian = bigEndian;
            this.explicitVR = true;
            return true;
        }
        int len = ByteUtils.bytesToInt((byte[])b128, (int)4, (boolean)bigEndian);
        if (len < 0 || 8 + len > rlen) {
            return false;
        }
        if (bigEndian) {
            throw new InstrumentException(IMPLICIT_VR_BIG_ENDIAN);
        }
        this.tsuid = "1.2.840.10008.1.2";
        this.bigEndian = false;
        this.explicitVR = false;
        return true;
    }

    public static enum IncludeBulkData {
        NO,
        YES,
        URI;

    }
}

