/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.metric.internal.net;

import java.io.IOException;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketAddress;
import org.aoju.bus.image.metric.Connection;
import org.aoju.bus.image.metric.SocketListener;
import org.aoju.bus.image.metric.internal.net.UDPHandler;
import org.aoju.bus.logger.Logger;

public class UDPListener
implements SocketListener {
    private final Connection conn;
    private final UDPHandler handler;
    private final DatagramSocket ds;

    public UDPListener(Connection conn, UDPHandler handler) throws IOException {
        this.conn = conn;
        this.handler = handler;
        try {
            this.ds = new DatagramSocket(conn.getBindPoint());
        }
        catch (BindException e) {
            throw new IOException("Cannot start UDP listener on " + conn.getBindPoint().getHostName() + ":" + conn.getBindPoint().getPort(), e);
        }
        conn.setReceiveBufferSize(this.ds);
        conn.getDevice().execute(() -> this.listen());
    }

    private void listen() {
        SocketAddress sockAddr = this.ds.getLocalSocketAddress();
        Logger.info((String)"Start UDP listener on {}", (Object[])new Object[]{sockAddr});
        byte[] data = new byte[65536];
        block4: while (true) {
            try {
                while (!this.ds.isClosed()) {
                    Logger.debug((String)"Wait for UDP datagram package on {}", (Object[])new Object[]{sockAddr});
                    DatagramPacket dp = new DatagramPacket(data, 65536);
                    this.ds.receive(dp);
                    InetAddress senderAddr = dp.getAddress();
                    if (this.conn.isBlackListed(dp.getAddress())) {
                        Logger.info((String)"Ignore UDP datagram package received from blacklisted {}", (Object[])new Object[]{senderAddr});
                        continue;
                    }
                    Logger.info((String)"Received UDP datagram package from {}", (Object[])new Object[]{senderAddr});
                    try {
                        this.handler.onReceive(this.conn, dp);
                        continue block4;
                    }
                    catch (Throwable e) {
                        Logger.warn((String)"Exception processing UDP received from {}:", (Object[])new Object[]{senderAddr, e});
                    }
                }
                break;
            }
            catch (Throwable e) {
                if (this.ds.isClosed()) break;
                Logger.error((String)"Exception on listing on {}:", (Object[])new Object[]{sockAddr, e});
                break;
            }
        }
        Logger.info((String)"Stop UDP listener on {}", (Object[])new Object[]{sockAddr});
    }

    @Override
    public SocketAddress getEndPoint() {
        return this.ds.getLocalSocketAddress();
    }

    @Override
    public void close() {
        try {
            this.ds.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

