/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.plugin;

import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Properties;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.image.Args;
import org.aoju.bus.image.Builder;
import org.aoju.bus.image.Device;
import org.aoju.bus.image.Node;
import org.aoju.bus.image.Option;
import org.aoju.bus.image.Status;
import org.aoju.bus.image.metric.Connection;
import org.aoju.bus.image.metric.Progress;
import org.aoju.bus.image.plugin.GetSCU;
import org.aoju.bus.logger.Logger;

public class CGet {
    public static Status process(Node callingNode, Node calledNode, Progress progress, File outputDir, Args ... keys) {
        return CGet.process(new Args(), callingNode, calledNode, progress, outputDir, keys);
    }

    public static Status process(Args args, Node callingNode, Node calledNode, Progress progress, File outputDir, Args ... keys) {
        return CGet.process(args, callingNode, calledNode, progress, outputDir, null, keys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Status process(Args args, Node callingNode, Node calledNode, Progress progress, File outputDir, URL sopClassURL, Args ... keys) {
        Status status;
        if (callingNode == null || calledNode == null || outputDir == null) {
            throw new IllegalArgumentException("callingNode, calledNode or outputDir cannot be null!");
        }
        GetSCU getSCU = new GetSCU(progress);
        Connection remote = getSCU.getRemoteConnection();
        Connection conn = getSCU.getConnection();
        args.configureBind(getSCU.getAAssociateRQ(), remote, calledNode);
        args.configureBind(getSCU.getApplicationEntity(), conn, callingNode);
        Device device = getSCU.getDevice();
        args.configure(conn);
        args.configureTLS(conn, remote);
        getSCU.setPriority(args.getPriority());
        getSCU.setStorageDirectory(outputDir);
        getSCU.setInformationModel(CGet.getInformationModel(args), args.getTsuidOrder(), args.getTypes().contains((Object)Option.Type.RELATIONAL));
        CGet.configureRelatedSOPClass(getSCU, sopClassURL);
        for (Args p : keys) {
            getSCU.addKey(p.getTag(), p.getValues());
        }
        device.start();
        try {
            Status dcmState = getSCU.getState();
            long t1 = System.currentTimeMillis();
            getSCU.open();
            long t2 = System.currentTimeMillis();
            getSCU.retrieve();
            Builder.forceGettingAttributes(dcmState, getSCU);
            long t3 = System.currentTimeMillis();
            String timeMsg = MessageFormat.format("DICOM C-GET connected in {2}ms from {0} to {1}. Get files in {3}ms.", getSCU.getAAssociateRQ().getCallingAET(), getSCU.getAAssociateRQ().getCalledAET(), t2 - t1, t3 - t2);
            status = Status.build(dcmState, timeMsg, null);
        }
        catch (Exception e) {
            Status status2;
            try {
                Logger.error((String)"getscu", (Object[])new Object[]{e});
                Builder.forceGettingAttributes(getSCU.getState(), getSCU);
                status2 = Status.build(getSCU.getState(), null, e);
            }
            catch (Throwable throwable) {
                try {
                    Builder.close(getSCU);
                    device.stop();
                    throw throwable;
                }
                catch (Exception e2) {
                    Logger.error((String)"getscu", (Object[])new Object[]{e2});
                    return new Status(49152, "DICOM Get failed : " + e2.getMessage(), null);
                }
            }
            Builder.close(getSCU);
            device.stop();
            return status2;
        }
        Builder.close(getSCU);
        device.stop();
        return status;
    }

    private static void configureRelatedSOPClass(GetSCU getSCU, URL url) {
        Properties p = new Properties();
        try {
            if (url != null) {
                p.load(url.openStream());
            }
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                CGet.configureStorageSOPClass(getSCU, (String)entry.getKey(), (String)entry.getValue());
            }
        }
        catch (Exception e) {
            Logger.error((String)"Read sop classes", (Object[])new Object[]{e});
        }
    }

    private static void configureStorageSOPClass(GetSCU getSCU, String cuid, String tsuids) {
        String[] ts = (String[])StringUtils.split((String)tsuids, (char)';').toArray();
        for (int i = 0; i < ts.length; ++i) {
            ts[i] = Builder.toUID(ts[i]);
        }
        getSCU.addOfferedStorageSOPClass(Builder.toUID(cuid), ts);
    }

    private static GetSCU.InformationModel getInformationModel(Args options) {
        Object model = options.getInformationModel();
        if (model instanceof GetSCU.InformationModel) {
            return (GetSCU.InformationModel)((Object)model);
        }
        return GetSCU.InformationModel.StudyRoot;
    }
}

