/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.plugin;

import java.io.BufferedOutputStream;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;
import org.aoju.bus.image.Builder;
import org.aoju.bus.image.UID;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.galaxy.data.Sequence;
import org.aoju.bus.image.galaxy.data.VR;
import org.aoju.bus.image.galaxy.io.ImageEncodingOptions;
import org.aoju.bus.image.galaxy.io.ImageOutputStream;

public class MkKOS {
    private static final int[] PATIENT_AND_STUDY_ATTRS = new int[]{524293, 524320, 524336, 524368, 524369, 524432, 0x100010, 0x100020, 0x100021, 0x100030, 0x100040, 0x20000D, 0x200010};
    private final Attributes attrs = new Attributes();
    private String uidSuffix;
    private String fname;
    private boolean nofmi;
    private ImageEncodingOptions encOpts;
    private String tsuid;
    private String seriesNumber;
    private String instanceNumber;
    private String keyObjectDescription;
    private String retrieveAET;
    private String retrieveURL;
    private String locationUID;
    private Attributes documentTitle;
    private Attributes documentTitleModifier;
    private Properties codes;
    private Attributes kos;
    private Sequence evidenceSeq;
    private Sequence contentSeq;

    public String getFname() {
        return this.fname;
    }

    public final void setUIDSuffix(String uidSuffix) {
        this.uidSuffix = uidSuffix;
    }

    public void setOutputFile(String fname) {
        this.fname = fname;
    }

    public void setNoFileMetaInformation(boolean nofmi) {
        this.nofmi = nofmi;
    }

    public final void setEncodingOptions(ImageEncodingOptions encOpts) {
        this.encOpts = encOpts;
    }

    public final void setTransferSyntax(String tsuid) {
        this.tsuid = tsuid;
    }

    public final void setSeriesNumber(String seriesNumber) {
        this.seriesNumber = seriesNumber;
    }

    public final void setInstanceNumber(String instanceNumber) {
        this.instanceNumber = instanceNumber;
    }

    public final void setKeyObjectDescription(String keyObjectDescription) {
        this.keyObjectDescription = keyObjectDescription;
    }

    public void setRetrieveAET(String retrieveAET) {
        this.retrieveAET = retrieveAET;
    }

    public void setRetrieveURL(String retrieveURL) {
        this.retrieveURL = retrieveURL;
    }

    public void setLocationUID(String locationUID) {
        this.locationUID = locationUID;
    }

    public final void setCodes(Properties codes) {
        this.codes = codes;
    }

    public final void setDocumentTitle(Attributes codeItem) {
        this.documentTitle = codeItem;
    }

    public final void setDocumentTitleModifier(Attributes codeItem) {
        this.documentTitleModifier = codeItem;
    }

    public Attributes toCodeItem(String codeValue) {
        if (this.codes == null) {
            throw new IllegalStateException("codec not initialized");
        }
        String codeMeaning = this.codes.getProperty(codeValue);
        if (codeMeaning == null) {
            throw new IllegalArgumentException("undefined internal value: " + codeValue);
        }
        int endDesignator = codeValue.indexOf(45);
        Attributes attrs = new Attributes(3);
        attrs.setString(524544, VR.SH, endDesignator >= 0 ? codeValue.substring(endDesignator + 1) : codeValue);
        attrs.setString(524546, VR.SH, endDesignator >= 0 ? codeValue.substring(0, endDesignator) : "DCM");
        attrs.setString(524548, VR.LO, codeMeaning);
        return attrs;
    }

    public boolean addInstance(Attributes inst) {
        Builder.updateAttributes(inst, this.attrs, this.uidSuffix);
        String studyIUID = inst.getString(0x20000D);
        String seriesIUID = inst.getString(0x20000E);
        String iuid = inst.getString(524312);
        String cuid = inst.getString(524310);
        if (studyIUID == null || seriesIUID == null || iuid == null || cuid == null) {
            return false;
        }
        if (this.kos == null) {
            this.kos = this.createKOS(inst);
        }
        this.refSOPSeq(this.refSeriesSeq(studyIUID), seriesIUID).add(this.refSOP(cuid, iuid));
        this.contentSeq.add(this.contentItem(this.valueTypeOf(inst), this.refSOP(cuid, iuid)));
        return true;
    }

    public void writeKOS() throws IOException {
        dos.setEncodingOptions(this.encOpts);
        try (ImageOutputStream dos = new ImageOutputStream(new BufferedOutputStream(this.fname != null ? new FileOutputStream(this.fname) : new FileOutputStream(FileDescriptor.out)), this.nofmi ? "1.2.840.10008.1.2" : "1.2.840.10008.1.2.1");){
            dos.writeDataset(this.nofmi ? null : this.kos.createFileMetaInformation(this.tsuid), this.kos);
        }
    }

    private Sequence refSeriesSeq(String studyIUID) {
        for (Attributes refStudy : this.evidenceSeq) {
            if (!studyIUID.equals(refStudy.getString(0x20000D))) continue;
            return refStudy.getSequence(528661);
        }
        Attributes refStudy = new Attributes(2);
        Sequence refSeriesSeq = refStudy.newSequence(528661, 10);
        refStudy.setString(0x20000D, VR.UI, studyIUID);
        this.evidenceSeq.add(refStudy);
        return refSeriesSeq;
    }

    private Sequence refSOPSeq(Sequence refSeriesSeq, String seriesIUID) {
        for (Attributes refSeries : refSeriesSeq) {
            if (!seriesIUID.equals(refSeries.getString(0x20000E))) continue;
            return refSeries.getSequence(528793);
        }
        Attributes refSeries = new Attributes(5);
        if (this.retrieveAET != null) {
            refSeries.setString(524372, VR.AE, this.retrieveAET);
        }
        if (this.retrieveURL != null) {
            refSeries.setString(528784, VR.UR, this.retrieveURL);
        }
        Sequence refSOPSeq = refSeries.newSequence(528793, 100);
        refSeries.setString(0x20000E, VR.UI, seriesIUID);
        if (this.locationUID != null) {
            refSeries.setString(4251665, VR.UI, this.locationUID);
        }
        refSeriesSeq.add(refSeries);
        return refSOPSeq;
    }

    private String valueTypeOf(Attributes inst) {
        return inst.contains(2621444) ? "IMAGE" : (inst.contains(1409286400) ? "WAVEFORM" : "COMPOSITE");
    }

    private Attributes refSOP(String cuid, String iuid) {
        Attributes item = new Attributes(2);
        item.setString(528720, VR.UI, cuid);
        item.setString(528725, VR.UI, iuid);
        return item;
    }

    private Attributes createKOS(Attributes inst) {
        Attributes attrs = new Attributes(inst, PATIENT_AND_STUDY_ATTRS);
        attrs.setString(524310, VR.UI, "1.2.840.10008.5.1.4.1.1.88.59");
        attrs.setString(524312, VR.UI, UID.createUID());
        attrs.setDate(2251950138064947L, new Date());
        attrs.setString(524384, VR.CS, "KO");
        attrs.setNull(528657, VR.SQ);
        attrs.setString(0x20000E, VR.UI, UID.createUID());
        attrs.setString(0x200011, VR.IS, this.seriesNumber);
        attrs.setString(2097171, VR.IS, this.instanceNumber);
        attrs.setString(0x40A040, VR.CS, "CONTAINER");
        attrs.setString(4235344, VR.CS, "SEPARATE");
        attrs.newSequence(4235331, 1).add(this.documentTitle);
        this.evidenceSeq = attrs.newSequence(4236149, 1);
        attrs.newSequence(4236548, 1).add(this.templateIdentifier());
        this.contentSeq = attrs.newSequence(4237104, 1);
        if (this.documentTitleModifier != null) {
            this.contentSeq.add(this.documentTitleModifier());
        }
        if (this.keyObjectDescription != null) {
            this.contentSeq.add(this.keyObjectDescription());
        }
        return attrs;
    }

    private Attributes templateIdentifier() {
        Attributes attrs = new Attributes(2);
        attrs.setString(524549, VR.CS, "DCMR");
        attrs.setString(4250368, VR.CS, "2010");
        return attrs;
    }

    private Attributes documentTitleModifier() {
        Attributes item = new Attributes(4);
        item.setString(4235280, VR.CS, "HAS CONCEPT MOD");
        item.setString(0x40A040, VR.CS, "CODE");
        item.newSequence(4235331, 1).add(this.toCodeItem("DCM-113011"));
        item.newSequence(4235624, 1).add(this.documentTitleModifier);
        return item;
    }

    private Attributes keyObjectDescription() {
        Attributes item = new Attributes(4);
        item.setString(4235280, VR.CS, "CONTAINS");
        item.setString(0x40A040, VR.CS, "TEXT");
        item.newSequence(4235331, 1).add(this.toCodeItem("DCM-113012"));
        item.setString(4235616, VR.UT, this.keyObjectDescription);
        return item;
    }

    private Attributes contentItem(String valueType, Attributes refSOP) {
        Attributes item = new Attributes(3);
        item.setString(4235280, VR.CS, "CONTAINS");
        item.setString(0x40A040, VR.CS, valueType);
        item.newSequence(528793, 1).add(refSOP);
        return item;
    }
}

