/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.plugin;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.aoju.bus.core.utils.IoUtils;
import org.aoju.bus.image.Device;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.galaxy.data.IOD;
import org.aoju.bus.image.galaxy.data.ValidationResult;
import org.aoju.bus.image.galaxy.io.ImageInputStream;
import org.aoju.bus.image.galaxy.io.ImageOutputStream;
import org.aoju.bus.image.metric.ApplicationEntity;
import org.aoju.bus.image.metric.Association;
import org.aoju.bus.image.metric.Connection;
import org.aoju.bus.image.metric.ImageException;
import org.aoju.bus.image.metric.service.BasicCEchoSCP;
import org.aoju.bus.image.metric.service.BasicMPPSSCP;
import org.aoju.bus.image.metric.service.ServiceHandler;
import org.aoju.bus.logger.Logger;

public class MppsSCP {
    private final Device device = new Device("mppsscp");
    private final ApplicationEntity ae = new ApplicationEntity("*");
    private final Connection conn = new Connection();
    private File storageDir;
    private IOD mppsNCreateIOD;
    private IOD mppsNSetIOD;
    private final BasicMPPSSCP mppsSCP = new BasicMPPSSCP(){

        @Override
        protected Attributes create(Association as, Attributes rq, Attributes rqAttrs, Attributes rsp) throws ImageException {
            return MppsSCP.this.create(as, rq, rqAttrs);
        }

        @Override
        protected Attributes set(Association as, Attributes rq, Attributes rqAttrs, Attributes rsp) throws ImageException {
            return MppsSCP.this.set(as, rq, rqAttrs);
        }
    };

    public MppsSCP() {
        this.device.addConnection(this.conn);
        this.device.addApplicationEntity(this.ae);
        this.ae.setAssociationAcceptor(true);
        this.ae.addConnection(this.conn);
        ServiceHandler serviceHandler = new ServiceHandler();
        serviceHandler.addService(new BasicCEchoSCP());
        serviceHandler.addService(this.mppsSCP);
        this.ae.setDimseRQHandler(serviceHandler);
    }

    public File getStorageDirectory() {
        return this.storageDir;
    }

    public void setStorageDirectory(File storageDir) {
        if (storageDir != null) {
            storageDir.mkdirs();
        }
        this.storageDir = storageDir;
    }

    private void setMppsNCreateIOD(IOD mppsNCreateIOD) {
        this.mppsNCreateIOD = mppsNCreateIOD;
    }

    private void setMppsNSetIOD(IOD mppsNSetIOD) {
        this.mppsNSetIOD = mppsNSetIOD;
    }

    private Attributes create(Association as, Attributes rq, Attributes rqAttrs) throws ImageException {
        ValidationResult result;
        if (this.mppsNCreateIOD != null && !(result = rqAttrs.validate(this.mppsNCreateIOD)).isValid()) {
            throw ImageException.valueOf(result, rqAttrs);
        }
        if (this.storageDir == null) {
            return null;
        }
        String cuid = rq.getString(2);
        String iuid = rq.getString(4096);
        File file = new File(this.storageDir, iuid);
        if (file.exists()) {
            throw new ImageException(273).setUID(4096, iuid);
        }
        ImageOutputStream out = null;
        Logger.info((String)"{}: M-WRITE {}", (Object[])new Object[]{as, file});
        try {
            out = new ImageOutputStream(file);
            out.writeDataset(Attributes.createFileMetaInformation(iuid, cuid, "1.2.840.10008.1.2.1"), rqAttrs);
        }
        catch (IOException e) {
            try {
                Logger.warn((String)(as + ": Failed to store MPPS:"), (Object[])new Object[]{e});
                throw new ImageException(272, e);
            }
            catch (Throwable throwable) {
                IoUtils.close(out);
                throw throwable;
            }
        }
        IoUtils.close((Closeable)out);
        return null;
    }

    private Attributes set(Association as, Attributes rq, Attributes rqAttrs) throws ImageException {
        Attributes data;
        ValidationResult result;
        if (this.mppsNSetIOD != null && !(result = rqAttrs.validate(this.mppsNSetIOD)).isValid()) {
            throw ImageException.valueOf(result, rqAttrs);
        }
        if (this.storageDir == null) {
            return null;
        }
        String cuid = rq.getString(3);
        String iuid = rq.getString(4097);
        File file = new File(this.storageDir, iuid);
        if (!file.exists()) {
            throw new ImageException(274).setUID(4096, iuid);
        }
        Logger.info((String)"{}: M-UPDATE {}", (Object[])new Object[]{as, file});
        ImageInputStream in = null;
        try {
            in = new ImageInputStream(file);
            data = in.readDataset(-1, -1);
        }
        catch (IOException e) {
            try {
                Logger.warn((String)(as + ": Failed to read MPPS:"), (Object[])new Object[]{e});
                throw new ImageException(272, e);
            }
            catch (Throwable throwable) {
                IoUtils.close(in);
                throw throwable;
            }
        }
        IoUtils.close((Closeable)in);
        if (!"IN PROGRESS".equals(data.getString(4194898))) {
            BasicMPPSSCP.mayNoLongerBeUpdated();
        }
        data.addAll(rqAttrs);
        ImageOutputStream out = null;
        try {
            out = new ImageOutputStream(file);
            out.writeDataset(Attributes.createFileMetaInformation(iuid, cuid, "1.2.840.10008.1.2.1"), data);
        }
        catch (IOException e) {
            try {
                Logger.warn((String)(as + ": Failed to update MPPS:"), (Object[])new Object[]{e});
                throw new ImageException(272, e);
            }
            catch (Throwable throwable) {
                IoUtils.close(out);
                throw throwable;
            }
        }
        IoUtils.close((Closeable)out);
        return null;
    }
}

