/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Objects;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.image.metric.Association;
import org.aoju.bus.logger.Logger;

public class Node {
    private final String aet;
    private final String hostname;
    private final Integer port;
    private final boolean validate;

    public Node(String aet) {
        this(aet, null, null);
    }

    public Node(String aet, Integer port) {
        this(aet, null, port);
    }

    public Node(String aet, String hostname, Integer port) {
        this(aet, hostname, port, false);
    }

    public Node(String aet, String hostname, Integer port, boolean validate) {
        if (!StringUtils.hasText((String)aet)) {
            throw new IllegalArgumentException("Missing AETitle");
        }
        if (aet.length() > 16) {
            throw new IllegalArgumentException("AETitle has more than 16 characters");
        }
        if (port != null && (port < 1 || port > 65535)) {
            throw new IllegalArgumentException("Port is out of bound");
        }
        this.aet = aet;
        this.hostname = hostname;
        this.port = port;
        this.validate = validate;
    }

    public static String convertToIP(String hostname) {
        try {
            return InetAddress.getByName(hostname).getHostAddress();
        }
        catch (UnknownHostException e) {
            Logger.error((String)"Cannot resolve hostname", (Object[])new Object[]{e});
            return StringUtils.hasText((String)hostname) ? hostname : "127.0.0.1";
        }
    }

    public static Node buildLocalDicomNode(Association as) {
        String ip = null;
        InetAddress address = as.getSocket().getLocalAddress();
        if (address != null) {
            ip = address.getHostAddress();
        }
        return new Node(as.getLocalAET(), ip, as.getSocket().getLocalPort());
    }

    public static Node buildRemoteDicomNode(Association as) {
        String ip = null;
        InetAddress address = as.getSocket().getInetAddress();
        if (address != null) {
            ip = address.getHostAddress();
        }
        return new Node(as.getRemoteAET(), ip, as.getSocket().getPort());
    }

    public boolean equalsHostname(String anotherHostname) {
        if (Objects.equals(this.hostname, anotherHostname)) {
            return true;
        }
        return Node.convertToIP(this.hostname).equals(Node.convertToIP(anotherHostname));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Node node = (Node)o;
        return this.aet.equals(node.aet) && Objects.equals(this.hostname, node.hostname) && Objects.equals(this.port, node.port);
    }

    public int hashCode() {
        return Objects.hash(this.aet, this.hostname, this.port);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("Host=");
        buf.append(this.hostname);
        buf.append(" AET=");
        buf.append(this.aet);
        buf.append(" Port=");
        buf.append(this.port);
        return buf.toString();
    }

    public String getAet() {
        return this.aet;
    }

    public String getHostname() {
        return this.hostname;
    }

    public Integer getPort() {
        return this.port;
    }

    public boolean isValidate() {
        return this.validate;
    }
}

