/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.galaxy.media;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.image.galaxy.media.HeaderFieldValues;
import org.aoju.bus.image.galaxy.media.MultipartInputStream;
import org.aoju.bus.image.galaxy.media.MultipartReader;

public class MultipartParser {
    public static final byte CR = 13;
    public static final byte LF = 10;
    public static final byte DASH = 45;
    private String boundary;

    private MultipartParser() {
    }

    public MultipartParser(String boundary) {
        this.boundary = boundary;
    }

    public static void parseMultipartRelated(URLConnection urlConnection, InputStream inputStream, Handler handler) throws IOException {
        String contentType = urlConnection.getContentType();
        byte[] boundary = MultipartParser.getBoundary(contentType, "multipart/related");
        if (boundary == null) {
            throw new IllegalStateException("Cannot find boundary of multipart");
        }
        MultipartReader multipartReader = new MultipartReader(inputStream, boundary);
        multipartReader.setHeaderEncoding("UTF8");
        int k = 1;
        boolean nextPart = multipartReader.skipFirstBoundary();
        while (nextPart) {
            String headersString = multipartReader.readHeaders();
            handler.bodyPart(multipartReader, k++, MultipartParser.getHeaders(headersString));
            nextPart = multipartReader.readBoundary();
        }
    }

    protected static Map<String, String> getHeaders(String header) {
        int end;
        HashMap<String, String> headers = new HashMap<String, String>();
        int length = header.length();
        int start = 0;
        while (start != (end = MultipartParser.parseEOF(header, start))) {
            String field;
            int index;
            StringBuilder buf = new StringBuilder(header.substring(start, end));
            start = end + 2;
            while (start < length) {
                char c;
                int k;
                for (k = start; k < length && ((c = header.charAt(k)) == ' ' || c == '\t'); ++k) {
                }
                if (k == start) break;
                end = MultipartParser.parseEOF(header, k);
                buf.append(" ");
                buf.append(header, k, end);
                start = end + 2;
            }
            if ((index = (field = buf.toString()).indexOf(58)) == -1) continue;
            String name = field.substring(0, index).trim();
            String value = field.substring(field.indexOf(58) + 1).trim();
            if (headers.containsKey(name)) {
                headers.put(name, (String)headers.get(name) + "," + value);
                continue;
            }
            headers.put(name, value);
        }
        return headers;
    }

    private static int parseEOF(String header, int pos) {
        int index = pos;
        while (true) {
            int k;
            if ((k = header.indexOf(13, index)) == -1 || k + 1 >= header.length()) {
                throw new IllegalStateException("No EOF found in headers");
            }
            if (header.charAt(k + 1) == '\n') {
                return k;
            }
            index = k + 1;
        }
    }

    protected static byte[] getBoundary(String respContentType, String ckeckMultipartType) {
        if (!StringUtils.hasText((String)respContentType)) {
            return null;
        }
        HeaderFieldValues parser = new HeaderFieldValues(respContentType);
        String boundaryStr = parser.getValue("boundary");
        if (boundaryStr == null || ckeckMultipartType != null && !parser.hasKey(ckeckMultipartType)) {
            return null;
        }
        return boundaryStr.getBytes(StandardCharsets.ISO_8859_1);
    }

    public void parse(InputStream in, Handler handler) throws IOException {
        new MultipartInputStream(in, "--" + this.boundary).skipAll();
        int i = 1;
        while (true) {
            int ch2;
            int ch1;
            if (((ch1 = in.read()) | (ch2 = in.read())) < 0) {
                throw new EOFException();
            }
            if (ch1 == 45 && ch2 == 45) break;
            if (ch1 != 13 || ch2 != 10) {
                throw new IOException("missing CR/LF after boundary");
            }
            MultipartInputStream mis = new MultipartInputStream(in, "\r\n--" + this.boundary);
            handler.bodyPart(mis, i);
            mis.skipAll();
            ++i;
        }
    }

    public static interface Handler {
        public void bodyPart(MultipartInputStream var1, int var2) throws IOException;

        public void bodyPart(MultipartReader var1, int var2, Map<String, String> var3) throws IOException;
    }

    public static enum Separator {
        HEADER(new byte[]{13, 10, 13, 10}),
        FIELD(new byte[]{13, 10}),
        BOUNDARY(new byte[]{13, 10, 45, 45}),
        STREAM(new byte[]{45, 45});

        private final byte[] type;

        private Separator(byte[] type) {
            this.type = type;
        }

        public byte[] getType() {
            return this.type;
        }

        public String toString() {
            return new String(this.type);
        }
    }
}

