/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.nimble.codec.jpeg;

import org.aoju.bus.core.utils.ByteUtils;

public class SOSSegment {
    private final byte[] data;
    private final int offset;
    private final int numComponents;

    public SOSSegment(byte[] data, int offset) {
        this.data = data;
        this.offset = offset;
        this.numComponents = data[offset + 3] & 0xFF;
        this.getAl();
    }

    public int offset() {
        return this.offset;
    }

    public int getMarker() {
        return this.data[this.offset] & 0xFF;
    }

    public int getHeaderLength() {
        return ByteUtils.bytesToUShortBE((byte[])this.data, (int)(this.offset + 1));
    }

    public int getNumComponents() {
        return this.numComponents;
    }

    public int getComponentID(int index) {
        return this.data[this.offset + 4 + index * 2] & 0xFF;
    }

    public int getTa(int index) {
        return this.data[this.offset + 5 + index * 2] >> 4 & 0xF;
    }

    public int getTd(int index) {
        return this.data[this.offset + 5 + index * 2] & 0xF;
    }

    public int getSs() {
        return this.data[this.offset + 4 + this.numComponents * 2] & 0xFF;
    }

    public int getSe() {
        return this.data[this.offset + 5 + this.numComponents * 2] & 0xFF;
    }

    public int getAh() {
        return this.data[this.offset + 6 + this.numComponents * 2] >> 4 & 0xF;
    }

    public int getAl() {
        return this.data[this.offset + 6 + this.numComponents * 2] & 0xF;
    }

    public int getNear() {
        return this.getSs();
    }

    public int getILV() {
        return this.getSe();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SOS=[Ls=").append(this.getHeaderLength()).append(", Ns=").append(this.numComponents);
        for (int i = 0; i < this.numComponents; ++i) {
            sb.append(", C").append(i + 1).append('=').append(this.getComponentID(i)).append(", Td").append(i + 1).append('=').append(this.getTd(i)).append(", Ta").append(i + 1).append('=').append(this.getTa(i));
        }
        sb.append(", Ss=").append(this.getSs()).append(", Se=").append(this.getSe()).append(", Ah=").append(this.getAh()).append(", Al=").append(this.getAl()).append(']');
        return sb.toString();
    }
}

